/*****************************************************************************
 * $Source: /cvsroot/charm-6.0/src/ck-ldb/LBMachineUtil.h,v $
 * $Author: gzheng $
 * $Date: 2005-03-21 20:38:09 $
 * $Revision: 1.7 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

#ifndef _LDMACHINEUTIL_H_
#define _LDMACHINEUTIL_H_

class LBMachineUtil {
public:
  LBMachineUtil();
  void StatsOn();
  void StatsOff();
  void Clear();
  void TotalTime(double* walltime, double* cputime);
  void IdleTime(double* walltime) { *walltime = total_idletime; };

private:
  enum { off, on } state;
  double total_walltime;
  double total_cputime;
  double total_idletime;
  double start_totalwall;
  double start_totalcpu;
  double start_idle;

  int cancel_idleStart, cancel_idleEnd;

  void IdleStart(double curWallTime);
  void IdleEnd(double curWallTime);
  static void staticIdleStart(LBMachineUtil *util,double curWallTime);
  static void staticIdleEnd(LBMachineUtil *util,double curWallTime);
};

#endif  // _LDMACHINEUTIL_H_

/*@}*/
