/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import projections.gui.AnimationColorBarPanel;
import projections.gui.AnimationDisplayPanel;
import projections.gui.IntervalRangeDialog;
import projections.gui.JTimeTextField;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;

public class AnimationWindow
extends ProjectionsWindow
implements ActionListener,
AdjustmentListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private AnimationColorBarPanel colorbarPanel;
    AnimationDisplayPanel displayPanel;
    AnimationWindow thisWindow;
    JMenuBar mbar = new JMenuBar();
    private Button bPlusOne;
    private Button bMinusOne;
    private Button bAuto;
    private Button setRanges;
    private JTimeTextField delayField;
    private Panel statusPanel;
    private Panel titlePanel;
    private Label lTitle;
    private Label lStatus;
    private Label lDelay;
    Scrollbar slider;
    int redrawDelay;
    boolean keepAnimating;
    private AnimateThread thread;
    boolean layoutComplete = false;
    public long intervalSize;
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;

    protected void windowInit() {
        this.intervalSize = 1000L;
        this.validPEs = MainWindow.runObject[this.myRun].getValidProcessorList();
        this.startTime = 0L;
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
    }

    public AnimationWindow(MainWindow mainWindow, Integer myWindowID) {
        super(mainWindow, myWindowID);
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.setTitle("Projections Animation - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.thisWindow = this;
        this.showDialog();
    }

    public void showWindow() {
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Animation Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    if (AnimationWindow.this.thisWindow.layoutComplete) {
                        if (AnimationWindow.this.dialog.isModified()) {
                            AnimationWindow.this.displayPanel.setParameters();
                            AnimationWindow.this.slider.setValues(0, 1, 0, AnimationWindow.this.displayPanel.getNumI());
                        }
                    } else {
                        AnimationWindow.this.createMenus();
                        AnimationWindow.this.createLayout();
                    }
                    return null;
                }

                public void finished() {
                    if (AnimationWindow.this.thisWindow.layoutComplete) {
                        AnimationWindow.this.pack();
                        AnimationWindow.this.thisWindow.setVisible(true);
                    } else {
                        AnimationWindow.this.thisWindow.repaint();
                    }
                }
            };
            worker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = dialog.getIntervalSize();
        this.validPEs = dialog.getValidProcessors();
        this.startTime = dialog.getStartTime();
        this.endTime = dialog.getEndTime();
    }

    public void setDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        dialog.setIntervalSize(this.intervalSize);
        dialog.setValidProcessors(this.validPEs);
        dialog.setStartTime(this.startTime);
        dialog.setEndTime(this.endTime);
        super.setDialogData();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.delayField) {
            this.redrawDelay = (int)(this.delayField.getValue() / 1000L);
        } else if (evt.getSource() instanceof Button) {
            Button b = (Button)evt.getSource();
            if (b == this.bPlusOne) {
                this.changeCurI(this.displayPanel.getCurI() + 1);
            } else if (b == this.bMinusOne) {
                this.changeCurI(this.displayPanel.getCurI() - 1);
            } else if (b == this.bAuto) {
                if (b.getLabel().equals("Auto")) {
                    b.setLabel("Stop");
                    this.keepAnimating = true;
                    this.thread = new AnimateThread();
                    this.thread.start();
                } else {
                    b.setLabel("Auto");
                    if (this.thread != null && this.thread.isAlive()) {
                        this.keepAnimating = false;
                        this.thread = null;
                        this.changeCurI(this.displayPanel.getCurI());
                    }
                }
            } else if (b == this.setRanges) {
                this.showDialog();
            }
        } else if (evt.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)evt.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.slider.getValueIsAdjusting()) {
            this.changeCurI(this.slider.getValue());
        }
    }

    void changeCurI(int i) {
        this.displayPanel.setCurI(i);
        this.setTitleInfo(this.displayPanel.getCurI());
        this.slider.setValue(i);
    }

    protected void createMenus() {
        this.mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        this.mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        this.mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(this.mbar);
    }

    void createLayout() {
        Panel mainPanel = new Panel();
        this.titlePanel = new Panel();
        this.statusPanel = new Panel();
        Panel controlPanel = new Panel();
        this.colorbarPanel = new AnimationColorBarPanel();
        this.displayPanel = new AnimationDisplayPanel(this);
        this.bPlusOne = new Button(">>");
        this.bMinusOne = new Button("<<");
        this.bAuto = new Button("Auto");
        this.bPlusOne.addActionListener(this);
        this.bMinusOne.addActionListener(this);
        this.bAuto.addActionListener(this);
        this.redrawDelay = 500;
        this.lDelay = new Label("Frame Refresh Delay:", 1);
        this.delayField = new JTimeTextField("500 ms", 8);
        this.delayField.addActionListener(this);
        this.slider = new Scrollbar(0, 0, 1, 0, this.displayPanel.getNumI());
        this.slider.addAdjustmentListener(this);
        this.setRanges = new Button("Set Ranges");
        this.setRanges.addActionListener(this);
        this.titlePanel.setBackground(MainWindow.runObject[this.myRun].background);
        this.titlePanel.setForeground(MainWindow.runObject[this.myRun].foreground);
        Font titleFont = new Font("SansSerif", 1, 16);
        this.lTitle = new Label("", 1);
        this.lTitle.setFont(titleFont);
        this.setTitleInfo(0);
        this.titlePanel.add(this.lTitle);
        this.lStatus = new Label("");
        this.statusPanel.add((Component)this.lStatus, "Center");
        this.statusPanel.setBackground(Color.lightGray);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        controlPanel.setLayout(gbl);
        Util.gblAdd(controlPanel, this.slider, gbc, 0, 0, 6, 1, 1, 1);
        Util.gblAdd(controlPanel, this.bMinusOne, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(controlPanel, this.bPlusOne, gbc, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(controlPanel, this.bAuto, gbc, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(controlPanel, this.lDelay, gbc, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(controlPanel, this.delayField, gbc, 4, 1, 1, 1, 1, 1);
        Util.gblAdd(controlPanel, this.setRanges, gbc, 5, 1, 1, 1, 1, 1);
        mainPanel.setBackground(Color.gray);
        mainPanel.setLayout(gbl);
        Util.gblAdd(mainPanel, this.titlePanel, gbc, 0, 0, 1, 1, 1, 0);
        Util.gblAdd(mainPanel, this.displayPanel, gbc, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(mainPanel, this.colorbarPanel, gbc, 0, 2, 1, 1, 1, 0);
        Util.gblAdd(mainPanel, this.statusPanel, gbc, 0, 3, 1, 1, 1, 0);
        Util.gblAdd(mainPanel, controlPanel, gbc, 0, 4, 1, 1, 1, 0);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.layoutComplete = true;
    }

    public void setStatusInfo(int p, int i, int u) {
        String status = p < 0 ? "" : "Processor " + p + ": Usage = " + u + "% at " + U.t(this.startTime + (long)i * this.intervalSize);
        this.lStatus.setText(status);
        this.lStatus.invalidate();
        this.statusPanel.validate();
    }

    public void setTitleInfo(int i) {
        String title = "Processor Usage at " + U.t(this.startTime + (long)i * this.intervalSize) + "(" + U.t(this.intervalSize) + " step)";
        this.lTitle.setText(title);
        this.lTitle.invalidate();
        this.titlePanel.validate();
    }

    class AnimateThread
    extends Thread {
        public AnimateThread() {
            AnimationWindow.this.keepAnimating = true;
        }

        public void run() {
            long finish = (long)AnimationWindow.this.redrawDelay + System.currentTimeMillis();
            while (AnimationWindow.this.keepAnimating) {
                long timeLeft = finish - System.currentTimeMillis();
                if (timeLeft > 0L) {
                    try {
                        AnimateThread.sleep(timeLeft);
                    }
                    catch (InterruptedException E) {}
                    continue;
                }
                finish += (long)AnimationWindow.this.redrawDelay;
                AnimationWindow.this.changeCurI(AnimationWindow.this.displayPanel.getCurI() + 1);
            }
        }
    }
}

