/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ColorPanel
extends Canvas
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private int type;
    private int index;
    private int w;
    private int h;
    private Color background;
    private Color foreground;
    private int wDefault = 40;
    private int hDefault = 20;
    private boolean highlighted = false;
    private ActionListener actionListener = null;

    public ColorPanel(int type, int index, Color f) {
        this.type = type;
        this.index = index;
        this.background = Color.black;
        this.foreground = f;
        this.w = this.wDefault;
        this.h = this.hDefault;
        this.addMouseListener(this);
    }

    public ColorPanel(Color f) {
        this.background = Color.black;
        this.foreground = f;
        this.w = this.wDefault;
        this.h = this.hDefault;
        this.addMouseListener(this);
    }

    public ColorPanel(Color f, int w, int h) {
        this.background = Color.black;
        this.foreground = f;
        this.w = w;
        this.h = h;
        this.addMouseListener(this);
    }

    public ColorPanel(Color b, Color f) {
        this.background = b;
        this.foreground = f;
        this.w = this.wDefault;
        this.h = this.hDefault;
        this.addMouseListener(this);
    }

    public ColorPanel(Color b, Color f, int w, int h) {
        this.w = w;
        this.h = h;
        this.background = b;
        this.foreground = f;
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public Color getColor() {
        return this.foreground;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.w, this.h);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.w, this.h);
    }

    public void mouseClicked(MouseEvent evt) {
        this.processActionEvent();
    }

    public void mouseEntered(MouseEvent evt) {
        if (!this.highlighted) {
            this.highlighted = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent evt) {
        if (this.highlighted) {
            this.highlighted = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void paint(Graphics g) {
        g.setColor(this.background);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(Color.gray);
        g.drawLine(0, 0, this.w, 0);
        g.drawLine(0, 1, this.w, 1);
        g.drawLine(0, 0, 0, this.h);
        g.drawLine(1, 0, 1, this.h);
        g.setColor(Color.white);
        g.drawLine(0, this.h, this.w, this.h);
        g.drawLine(0, this.h - 1, this.w, this.h - 1);
        g.drawLine(this.w, this.h, this.w, 0);
        g.drawLine(this.w - 1, this.h, this.w - 1, 0);
        g.setColor(this.foreground);
        g.fillRect(5, 5, this.w - 10, this.h - 10);
        if (this.highlighted) {
            g.setColor(this.foreground.brighter().brighter());
            g.drawRect(5, 5, this.w - 10, this.h - 10);
        }
    }

    public void processActionEvent() {
        if (this.actionListener != null) {
            ActionEvent ae = new ActionEvent(this, 1001, "ColorPanel Action");
            this.actionListener.actionPerformed(ae);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void setColor(Color c) {
        this.foreground = c;
        this.repaint();
    }

    public int getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }
}

