/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.TextArea;
import java.io.Writer;

public class MultiRunTextAreaWriter
extends Writer {
    TextArea textArea;
    StringBuffer tempBuffer;
    boolean newInput = true;

    public MultiRunTextAreaWriter(TextArea NtextArea) {
        this.textArea = NtextArea;
        this.tempBuffer = new StringBuffer();
    }

    public void close() {
        this.flush();
        this.newInput = true;
    }

    public void flush() {
        this.textArea.append(this.tempBuffer.toString());
        this.tempBuffer = null;
        this.tempBuffer = new StringBuffer();
    }

    public void write(char[] cbuf) {
        this.checkNewInput();
        this.write(new String(cbuf));
    }

    public void write(char[] cbuf, int off, int len) {
        this.checkNewInput();
        this.write(new String(cbuf, off, len));
    }

    public void write(int c) {
        this.checkNewInput();
        this.write(String.valueOf((char)c));
    }

    public void write(String str) {
        this.checkNewInput();
        this.tempBuffer.append(str);
    }

    public void write(String str, int off, int len) {
        this.checkNewInput();
        this.write(str.substring(off, off + len));
    }

    private void checkNewInput() {
        if (this.newInput) {
            this.textArea.setText("");
        }
        this.newInput = false;
    }
}

