/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.KMeansClustering;
import projections.gui.Clickable;
import projections.gui.ColorSelectable;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OutlierDialog;
import projections.gui.SwingWorker;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class OutlierAnalysisWindow
extends GenericGraphWindow
implements ActionListener,
ItemListener,
ColorSelectable,
Clickable {
    private static final long serialVersionUID = 1L;
    OutlierAnalysisWindow thisWindow;
    static int myRun = 0;
    private JPanel mainPanel;
    private int threshold;
    private int currentActivity;
    private int currentAttribute;
    private int k;
    public String[][] attributes = new String[][]{{"Execution Time by Activity", "Idle Time", "Msgs Sent by Activity", "Bytes Sent by Activity"}, {"Execution Time (us)", "Time (us)", "Number of Messages", "Number of Bytes"}, {"us", "us", "", ""}};
    LinkedList outlierList;
    private int numActivities;
    private int numSpecials;
    private double[][] graphData;
    private Color[] graphColors;
    public OrderedIntList outlierPEs;
    DecimalFormat df = new DecimalFormat();

    public OutlierAnalysisWindow(MainWindow mainWindow, Integer myWindowID) {
        super("Projections Outlier Analysis Tool - " + MainWindow.runObject[myRun].getFilename() + ".sts", mainWindow, myWindowID);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        if (MainWindow.runObject[OutlierAnalysisWindow.myRun].rcReader.RC_OUTLIER_FILTERED.booleanValue()) {
            this.currentActivity = 0;
            this.currentAttribute = 0;
            this.validPEs = MainWindow.runObject[myRun].getValidProcessorList(0);
            this.outlierPEs = new OrderedIntList();
            this.startTime = 0L;
            this.endTime = MainWindow.runObject[myRun].getTotalTime();
            this.threshold = MainWindow.runObject[myRun].getNumProcessors() <= 256 ? (int)Math.ceil(0.1 * (double)MainWindow.runObject[myRun].getNumProcessors()) : 20;
            this.loadOnlineData();
        } else {
            this.showDialog();
        }
    }

    private void createLayout() {
        this.mainPanel = this.getMainPanel();
        this.getContentPane().add(this.mainPanel);
    }

    protected void createMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(mbar);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new OutlierDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            if (this.dialog.isModified()) {
                this.thisWindow.setVisible(false);
                this.loadData();
            }
        }
    }

    public void getDialogData() {
        OutlierDialog mydialog = (OutlierDialog)this.dialog;
        this.threshold = mydialog.threshold;
        this.k = mydialog.k;
        this.currentActivity = mydialog.currentActivity;
        this.currentAttribute = mydialog.currentAttribute;
        super.getDialogData();
    }

    private void loadData() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                OutlierAnalysisWindow.this.constructToolData();
                return null;
            }

            public void finished() {
                OutlierAnalysisWindow.this.setGraphSpecificData();
                OutlierAnalysisWindow.this.thisWindow.setVisible(true);
            }
        };
        worker.start();
    }

    void constructToolData() {
        int i;
        int p;
        int ep;
        this.numActivities = MainWindow.runObject[myRun].getNumActivity(this.currentActivity);
        Color[] tempGraphColors = MainWindow.runObject[myRun].getColorMap(this.currentActivity);
        this.numSpecials = 0;
        if (this.currentAttribute <= 1) {
            this.numSpecials = 1;
            this.graphColors = new Color[this.numActivities + this.numSpecials];
            for (int i2 = 0; i2 < this.numActivities; ++i2) {
                this.graphColors[i2] = tempGraphColors[i2];
            }
            this.graphColors[this.numActivities] = Color.white;
        } else {
            this.graphColors = tempGraphColors;
        }
        double[][] tempData = new double[this.validPEs.size()][this.numActivities + this.numSpecials];
        int nextPe = 0;
        int count = 0;
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[OutlierAnalysisWindow.myRun].guiRoot, "Reading log files", "", 0, this.validPEs.size());
        progressBar.setNote("Reading");
        progressBar.setProgress(0);
        this.validPEs.reset();
        while (this.validPEs.hasMoreElements()) {
            nextPe = this.validPEs.nextElement();
            progressBar.setProgress(count);
            progressBar.setNote("[PE: " + nextPe + " ] Reading Data.");
            if (progressBar.isCanceled()) {
                return;
            }
            GenericLogReader reader = new GenericLogReader(nextPe, MainWindow.runObject[myRun].getVersion());
            try {
                LogEntryData logData;
                if (this.currentActivity == 1) {
                    logData = new LogEntryData();
                    LogEntryData logDataEnd = new LogEntryData();
                    logData.time = 0L;
                    while (logData.time < this.startTime) {
                        reader.nextEventOfType(100, logData);
                        reader.nextEventOfType(100, logDataEnd);
                    }
                    int eventIndex = 0;
                    do {
                        eventIndex = MainWindow.runObject[myRun].getUserDefinedEventIndex(logData.userEventID);
                        double[] dArray = tempData[count];
                        int n = eventIndex;
                        dArray[n] = dArray[n] + (double)(logDataEnd.time - logData.time);
                        reader.nextEventOfType(100, logData);
                        reader.nextEventOfType(100, logDataEnd);
                    } while (logDataEnd.time <= this.endTime);
                } else {
                    logData = new LogEntryData();
                    logData.time = 0L;
                    boolean isFirstEvent = true;
                    boolean markedBegin = false;
                    boolean markedIdle = false;
                    long beginBlockTime = this.startTime;
                    reader.nextEventOnOrAfter(this.startTime, logData);
                    while (logData.time <= this.endTime) {
                        LogEntryData BE = reader.getLastBE();
                        switch (logData.type) {
                            case 1: {
                                if (isFirstEvent && BE != null && BE.type == 2) {
                                    beginBlockTime = this.startTime;
                                    markedBegin = true;
                                }
                                if (!markedBegin) break;
                                int eventIndex = logData.entry;
                                if (this.currentAttribute == 2) {
                                    double[] dArray = tempData[count];
                                    int n = eventIndex;
                                    dArray[n] = dArray[n] + 1.0;
                                    break;
                                }
                                if (this.currentAttribute != 3) break;
                                double[] dArray = tempData[count];
                                int n = eventIndex;
                                dArray[n] = dArray[n] + (double)logData.msglen;
                                break;
                            }
                            case 2: {
                                isFirstEvent = false;
                                if (!markedBegin) {
                                    markedBegin = true;
                                }
                                if (this.currentAttribute > 1) break;
                                beginBlockTime = logData.time;
                                break;
                            }
                            case 3: {
                                if (isFirstEvent) {
                                    markedBegin = true;
                                    beginBlockTime = this.startTime;
                                }
                                isFirstEvent = false;
                                if (!markedBegin) break;
                                markedBegin = false;
                                if (this.currentAttribute > 1) break;
                                double[] dArray = tempData[count];
                                int n = logData.entry;
                                dArray[n] = dArray[n] + (double)(logData.time - beginBlockTime);
                                break;
                            }
                            case 14: {
                                isFirstEvent = false;
                                if (!markedIdle) {
                                    markedIdle = true;
                                }
                                if (this.currentAttribute > 1) break;
                                beginBlockTime = logData.time;
                                break;
                            }
                            case 15: {
                                if (isFirstEvent) {
                                    markedIdle = true;
                                    beginBlockTime = this.startTime;
                                }
                                if (!markedIdle) break;
                                markedIdle = false;
                                if (this.currentAttribute > 1) break;
                                double[] dArray = tempData[count];
                                int n = this.numActivities;
                                dArray[n] = dArray[n] + (double)(logData.time - beginBlockTime);
                            }
                        }
                        reader.nextEvent(logData);
                    }
                    LogEntryData beginEvent = reader.getLastBE();
                    block9 : switch (logData.type) {
                        case 3: {
                            if (this.currentAttribute > 1) break;
                            double[] dArray = tempData[count];
                            int n = logData.entry;
                            dArray[n] = dArray[n] + (double)(this.endTime - beginBlockTime);
                            break;
                        }
                        case 15: {
                            if (this.currentAttribute > 1) break;
                            double[] dArray = tempData[count];
                            int n = this.numActivities;
                            dArray[n] = dArray[n] + (double)(this.endTime - beginBlockTime);
                            break;
                        }
                        default: {
                            if (beginEvent == null) break;
                            beginBlockTime = beginEvent.time > this.startTime ? beginEvent.time : this.startTime;
                            switch (beginEvent.type) {
                                case 2: {
                                    if (this.currentAttribute > 1) break block9;
                                    double[] dArray = tempData[count];
                                    int n = beginEvent.entry;
                                    dArray[n] = dArray[n] + (double)(this.endTime - beginBlockTime);
                                    break block9;
                                }
                                case 14: {
                                    if (this.currentAttribute != 1) break block9;
                                    double[] dArray = tempData[count];
                                    int n = this.numActivities;
                                    dArray[n] = dArray[n] + (double)(this.endTime - beginBlockTime);
                                }
                            }
                        }
                    }
                    reader.close();
                }
            }
            catch (EOFException e) {
                try {
                    reader.close();
                }
                catch (IOException evt) {
                    System.err.println("Outlier Analysis: Error in closing file for processor " + nextPe);
                    System.err.println(evt);
                }
            }
            catch (IOException e) {
                System.err.println("Outlier Analysis: Error in reading log data for processor " + nextPe);
                System.err.println(e);
            }
            ++count;
        }
        progressBar.close();
        int[] clusterMap = new int[tempData.length];
        double[] distanceFromClusterMean = new double[tempData.length];
        KMeansClustering.kMeans(tempData, this.k, clusterMap, distanceFromClusterMean);
        double[][] clusterAverage = new double[this.k][tempData[0].length];
        int[] clusterCounts = new int[this.k];
        int numNonZero = 0;
        for (int p2 = 0; p2 < tempData.length; ++p2) {
            for (ep = 0; ep < tempData[p2].length; ++ep) {
                double[] dArray = clusterAverage[clusterMap[p2]];
                int n = ep;
                dArray[n] = dArray[n] + tempData[p2][ep];
                int n2 = clusterMap[p2];
                clusterCounts[n2] = clusterCounts[n2] + 1;
            }
        }
        for (int k = 0; k < this.k; ++k) {
            if (clusterCounts[k] <= 0) continue;
            ep = 0;
            while (ep < clusterAverage[k].length) {
                double[] dArray = clusterAverage[k];
                int n = ep++;
                dArray[n] = dArray[n] / (double)clusterCounts[k];
            }
            ++numNonZero;
        }
        double[] tmpAvg = new double[this.numActivities + this.numSpecials];
        double[] processorDiffs = new double[this.validPEs.size()];
        int[] sortedMap = new int[this.validPEs.size()];
        String[] peNames = new String[this.validPEs.size()];
        this.validPEs.reset();
        for (p = 0; p < this.validPEs.size(); ++p) {
            sortedMap[p] = p;
            peNames[p] = Integer.toString(this.validPEs.nextElement());
        }
        int act = 0;
        while (act < this.numActivities + this.numSpecials) {
            for (int p3 = 0; p3 < this.validPEs.size(); ++p3) {
                int n = act;
                tmpAvg[n] = tmpAvg[n] + tempData[p3][act];
            }
            int n = act++;
            tmpAvg[n] = tmpAvg[n] / (double)this.validPEs.size();
        }
        for (p = 0; p < this.validPEs.size(); ++p) {
            if (this.currentAttribute == 1) {
                int n = p;
                processorDiffs[n] = processorDiffs[n] - tempData[p][this.numActivities];
                continue;
            }
            for (int act2 = 0; act2 < this.numActivities; ++act2) {
                int n = p;
                processorDiffs[n] = processorDiffs[n] + Math.abs(tempData[p][act2] - tmpAvg[act2]) * tmpAvg[act2];
            }
        }
        for (p = this.validPEs.size() - 1; p > 0; --p) {
            for (i = 0; i < p; ++i) {
                if (!(processorDiffs[i + 1] < processorDiffs[i])) continue;
                double temp = processorDiffs[i + 1];
                processorDiffs[i + 1] = processorDiffs[i];
                processorDiffs[i] = temp;
                int tempI = sortedMap[i + 1];
                sortedMap[i + 1] = sortedMap[i];
                sortedMap[i] = tempI;
            }
        }
        int offset = this.validPEs.size() - this.threshold;
        this.graphData = new double[this.threshold + 3 + numNonZero][this.numActivities + this.numSpecials];
        this.outlierList = new LinkedList();
        for (i = 0; i < this.threshold; ++i) {
            for (int act3 = 0; act3 < this.numActivities + this.numSpecials; ++act3) {
                this.graphData[i + 3 + numNonZero][act3] = tempData[sortedMap[i + offset]][act3];
            }
            this.outlierList.add(peNames[sortedMap[i + offset]]);
        }
        int[] minDistanceIndex = new int[this.k];
        double[] minDistanceFromClusterMean = new double[this.k];
        for (int k = 0; k < this.k; ++k) {
            minDistanceFromClusterMean[k] = Double.MAX_VALUE;
            minDistanceIndex[k] = -1;
        }
        for (int p4 = 0; p4 < distanceFromClusterMean.length; ++p4) {
            if (!(distanceFromClusterMean[p4] <= minDistanceFromClusterMean[clusterMap[p4]])) continue;
            minDistanceIndex[clusterMap[p4]] = p4;
        }
        int clusterIndex = 0;
        for (int k = 0; k < this.k; ++k) {
            if (minDistanceIndex[k] == -1) continue;
            for (int act4 = 0; act4 < this.numActivities + this.numSpecials; ++act4) {
                this.graphData[3 + clusterIndex][act4] = tempData[minDistanceIndex[k]][act4];
            }
            this.outlierList.addFirst("C" + k + "R" + minDistanceIndex[k]);
            ++clusterIndex;
        }
        this.graphData[0] = tmpAvg;
        for (int act5 = 0; act5 < this.numActivities + this.numSpecials; ++act5) {
            int i3;
            for (i3 = 0; i3 < offset; ++i3) {
                double[] dArray = this.graphData[1];
                int n = act5;
                dArray[n] = dArray[n] + tempData[sortedMap[i3]][act5];
            }
            if (offset != 0) {
                double[] dArray = this.graphData[1];
                int n = act5;
                dArray[n] = dArray[n] / (double)offset;
            }
            for (i3 = offset; i3 < this.validPEs.size(); ++i3) {
                double[] dArray = this.graphData[2];
                int n = act5;
                dArray[n] = dArray[n] + tempData[sortedMap[i3]][act5];
            }
            if (this.threshold == 0) continue;
            double[] dArray = this.graphData[2];
            int n = act5;
            dArray[n] = dArray[n] / (double)this.threshold;
        }
        this.outlierList.addFirst("Out.");
        this.outlierList.addFirst("Non.");
        this.outlierList.addFirst("Avg");
    }

    private void loadOnlineData() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                OutlierAnalysisWindow.this.readOutlierStats();
                return null;
            }

            public void finished() {
                OutlierAnalysisWindow.this.setGraphSpecificData();
                OutlierAnalysisWindow.this.thisWindow.setVisible(true);
            }
        };
        worker.start();
    }

    void readOutlierStats() {
        this.numActivities = MainWindow.runObject[myRun].getNumActivity(this.currentActivity);
        Color[] tempGraphColors = MainWindow.runObject[myRun].getColorMap(this.currentActivity);
        this.numSpecials = 1;
        this.graphColors = new Color[this.numActivities + this.numSpecials];
        for (int i = 0; i < this.numActivities; ++i) {
            this.graphColors[i] = tempGraphColors[i];
        }
        this.graphColors[this.numActivities] = Color.white;
        this.graphData = new double[this.threshold + 3][this.numActivities + this.numSpecials];
        String statsFilePath = MainWindow.runObject[myRun].getLogDirectory() + File.separator + MainWindow.runObject[myRun].getFilename() + ".outlier";
        try {
            int i;
            BufferedReader InFile = new BufferedReader(new InputStreamReader(new FileInputStream(statsFilePath)));
            String statsLine = InFile.readLine();
            StringTokenizer st = new StringTokenizer(statsLine);
            for (int i2 = 0; i2 < this.numActivities + this.numSpecials; ++i2) {
                this.graphData[0][i2] = Double.parseDouble(st.nextToken());
            }
            statsLine = InFile.readLine();
            st = new StringTokenizer(statsLine);
            int offset = 0;
            if (this.validPEs.size() > this.threshold) {
                offset = this.validPEs.size() - this.threshold;
            }
            int nextPe = 0;
            ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[OutlierAnalysisWindow.myRun].guiRoot, "Reading log files", "", 0, this.threshold);
            progressBar.setNote("Reading");
            progressBar.setProgress(0);
            for (i = 0; i < offset; ++i) {
                st.nextToken();
            }
            this.outlierList = new LinkedList();
            this.outlierList.add("Avg");
            this.outlierList.add("Non.");
            this.outlierList.add("Out.");
            for (i = 0; i < this.threshold; ++i) {
                nextPe = Integer.parseInt(st.nextToken());
                this.outlierList.add(nextPe + "");
                progressBar.setProgress(i);
                progressBar.setNote("[PE: " + nextPe + " ] Reading Data. (" + i + " of " + this.threshold + ")");
                if (progressBar.isCanceled()) {
                    return;
                }
                this.readOnlineOutlierProcessor(nextPe, i + 3);
            }
            progressBar.close();
        }
        catch (IOException e) {
            System.err.println("Error: Projections failed to read outlier data file [" + statsFilePath + "].");
            System.err.println(e.toString());
            System.exit(-1);
        }
        int act = 0;
        while (act < this.numActivities + this.numSpecials) {
            for (int i = 0; i < this.threshold; ++i) {
                double[] dArray = this.graphData[2];
                int n = act;
                dArray[n] = dArray[n] + this.graphData[i + 3][act];
            }
            this.graphData[1][act] = this.graphData[0][act] * (double)MainWindow.runObject[myRun].getNumProcessors() - this.graphData[2][act];
            double[] dArray = this.graphData[1];
            int n = act;
            dArray[n] = dArray[n] / (double)(MainWindow.runObject[myRun].getNumProcessors() - this.threshold);
            double[] dArray2 = this.graphData[2];
            int n2 = act++;
            dArray2[n2] = dArray2[n2] / (double)this.threshold;
        }
    }

    private void readOnlineOutlierProcessor(int pe, int index) {
        GenericLogReader reader = new GenericLogReader(pe, MainWindow.runObject[myRun].getVersion());
        try {
            LogEntryData logData = new LogEntryData();
            logData.time = 0L;
            boolean markedBegin = false;
            boolean markedIdle = false;
            long beginBlockTime = 0L;
            reader.nextEventOnOrAfter(this.startTime, logData);
            while (logData.time <= this.endTime) {
                if (logData.type == 2) {
                    if (!markedBegin) {
                        markedBegin = true;
                    }
                    beginBlockTime = logData.time;
                } else if (logData.type == 3) {
                    if (markedBegin) {
                        markedBegin = false;
                        double[] dArray = this.graphData[index];
                        int n = logData.entry;
                        dArray[n] = dArray[n] + (double)(logData.time - beginBlockTime);
                    }
                } else if (logData.type == 14) {
                    if (!markedIdle) {
                        markedIdle = true;
                    }
                    beginBlockTime = logData.time;
                } else if (logData.type == 15 && markedIdle) {
                    markedIdle = false;
                    double[] dArray = this.graphData[index];
                    int n = this.numActivities;
                    dArray[n] = dArray[n] + (double)(logData.time - beginBlockTime);
                }
                reader.nextEvent(logData);
            }
            reader.close();
        }
        catch (EOFException e) {
            try {
                reader.close();
            }
            catch (IOException evt) {
                System.err.println("Outlier Analysis: Error in closing file for processor " + pe);
                System.err.println(evt);
            }
        }
        catch (IOException e) {
            System.err.println("Outlier Analysis: Error in reading log data for processor " + pe);
            System.err.println(e);
        }
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Outliers", this.outlierList);
        this.setYAxis(this.attributes[1][this.currentAttribute], this.attributes[2][this.currentAttribute]);
        this.setDataSource("Outliers: " + this.attributes[0][this.currentAttribute] + " (Threshold = " + this.threshold + " processors)", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public void showWindow() {
    }

    public void applyDialogColors() {
        this.setDataSource("Outliers", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public String[] getPopup(int xVal, int yVal) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        if (xVal < 0 || yVal < 0) {
            return null;
        }
        String[] rString = new String[]{xVal == 0 ? "Global Average" : (xVal == 1 ? "Non Outlier Average" : (xVal == 2 ? "Outlier Average" : "Outlier Processor " + (String)this.outlierList.get(xVal))), yVal == this.numActivities ? "Activity: Idle Time" : "Activity: " + MainWindow.runObject[myRun].getActivityNameByIndex(this.currentActivity, yVal), this.currentActivity >= 2 ? df.format(this.graphData[xVal][yVal]) + "" : U.t((long)this.graphData[xVal][yVal])};
        return rString;
    }

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        if (xVal >= 3) {
            if (this.parentWindow.childWindows[1][0] != null) {
                final int myX = xVal;
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ((TimelineWindow)OutlierAnalysisWindow.this.parentWindow.childWindows[1][0]).addProcessor(Integer.parseInt((String)OutlierAnalysisWindow.this.outlierList.get(myX)));
                        return null;
                    }

                    public void finished() {
                    }
                };
                worker.start();
            } else {
                System.err.println("You wanted to load processor " + (String)this.outlierList.get(xVal) + "'s data onto Timeline. However," + "the ability to open a new " + "timeline window from Outlier Analysis " + "is not supported yet!");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)e.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }
}

