/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.MainWindow;
import projections.gui.ProfileData;
import projections.gui.Util;

public class ProfileLabelCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private ProfileData data;
    private Image offscreen;
    private int maxwidth;
    private FontMetrics fm;
    private int labelincrement;

    public ProfileLabelCanvas(ProfileData data) {
        this.data = data;
        this.offscreen = null;
        this.maxwidth = 0;
        this.setForeground(MainWindow.runObject[this.myRun].foreground);
        this.setBackground(MainWindow.runObject[this.myRun].background);
    }

    private void drawLabels(Graphics g) {
        g.setColor(this.getForeground());
        int h = this.getSize().height;
        float width = (float)(this.data.dcw - 2 * this.data.offset) / (float)this.data.numPs;
        if (this.fm == null) {
            this.fm = g.getFontMetrics(g.getFont());
            this.maxwidth = this.fm.stringWidth("" + MainWindow.runObject[this.myRun].getNumProcessors()) + 20;
        }
        this.labelincrement = (int)Math.ceil((double)this.maxwidth / (double)width);
        this.labelincrement = Util.getBestIncrement(this.labelincrement);
        int textheight = this.fm.getHeight();
        int longlineht = h - textheight - 2;
        int shortlineht = longlineht / 2;
        this.data.plist.reset();
        String tmp1 = "Avg";
        int xloc1 = (int)(0.5 * (double)width) + this.data.offset;
        g.drawLine(xloc1, 0, xloc1, longlineht);
        g.drawString(tmp1, xloc1 -= (int)(0.5 * (double)this.fm.stringWidth(tmp1)), h);
        for (int p = 1; p < this.data.numPs; ++p) {
            String tmp = "" + this.data.plist.nextElement();
            int xloc = (int)(((double)p + 0.5) * (double)width) + this.data.offset;
            if (p % this.labelincrement == 0) {
                g.drawLine(xloc, 0, xloc, longlineht);
                g.drawString(tmp, xloc -= (int)(0.5 * (double)this.fm.stringWidth(tmp)), h);
                continue;
            }
            g.drawLine(xloc, 0, xloc, shortlineht);
        }
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.plist == null) {
            return;
        }
        int h = this.getSize().height;
        if (this.data.dcw > 0 && h > 0) {
            this.offscreen = this.createImage(this.data.dcw, h);
            if (this.offscreen == null) {
                return;
            }
            Graphics og = this.offscreen.getGraphics();
            og.setClip(0, 0, this.data.dcw, h);
            this.drawLabels(og);
            og.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        if (this.offscreen != null) {
            int x = this.data.profileWindow.getHSBValue();
            int h = this.getSize().height;
            g.drawImage(this.offscreen, 0, 0, this.data.vpw, h, x, 0, this.data.vpw + x, h, null);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

