/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.Analysis;
import projections.gui.ColorPanel;
import projections.gui.ColorWindowFrame;
import projections.gui.LWPanel;
import projections.gui.MainWindow;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.TimelineWindow;
import projections.gui.Util;

public class ColorChooser
extends ColorWindowFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private Data data;
    private TimelineWindow parentTimelineWindow;
    private ColorPanel[] cpEntry;
    private ColorPanel selectedCP;
    private Button bApply;
    private Button bClose;

    public ColorChooser(Frame parent, Data data, TimelineWindow parentTimelineWindow_) {
        super(parent);
        this.parentTimelineWindow = parentTimelineWindow_;
        this.data = data;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ColorChooser.this.Close();
            }
        });
        this.setBackground(Color.lightGray);
        this.setTitle("Timeline Colors");
        this.setLocation(0, 0);
        this.CreateLayout();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button b = (Button)evt.getSource();
            if (b == this.bApply) {
                for (int e = 0; e < MainWindow.runObject[this.myRun].getNumUserEntries(); ++e) {
                    if (this.cpEntry[e] == null) continue;
                    this.data.entryColor()[e] = this.cpEntry[e].getColor();
                }
                this.parentTimelineWindow.refreshDisplay(false);
            } else if (b == this.bClose) {
                this.Close();
            }
        } else if (evt.getSource() instanceof ColorPanel) {
            this.selectedCP = (ColorPanel)evt.getSource();
            String s = null;
            for (int e = 0; e < MainWindow.runObject[this.myRun].getNumUserEntries(); ++e) {
                if (this.selectedCP != this.cpEntry[e]) continue;
                s = MainWindow.runObject[this.myRun].getEntryNameByIndex(e);
            }
            JColorChooser colorWindow = new JColorChooser();
            Color returnColor = JColorChooser.showDialog(this, s, this.selectedCP.getColor());
            if (returnColor != null) {
                this.selectedCP.setColor(returnColor);
            }
        }
    }

    void Close() {
        this.setVisible(false);
        this.parentTimelineWindow.controls.CloseColorWindow();
        this.dispose();
    }

    private void CreateLayout() {
        Panel p = new Panel();
        this.add("Center", p);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.cpEntry = new ColorPanel[MainWindow.runObject[this.myRun].getNumUserEntries()];
        LWPanel p1 = new LWPanel();
        p1.setLayout(gbl);
        int ypos = 0;
        String charename = new String();
        Analysis a = MainWindow.runObject[this.myRun];
        for (int e = 0; e < a.getNumUserEntries(); ++e) {
            if (this.data.entries()[e] <= 0) continue;
            if (!charename.equals(a.getEntryChareNameByIndex(e))) {
                charename = a.getEntryChareNameByIndex(e);
                Label lc = new Label(a.getEntryChareNameByIndex(e), 0);
                Util.gblAdd(p1, lc, gbc, 0, ypos++, 1, 1, 1, 0, 0, 5, 0, 5);
            }
            Label l = new Label(a.getEntryNameByIndex(e), 2);
            Util.gblAdd(p1, l, gbc, 0, ypos, 1, 1, 1, 0, 0, 5, 0, 5);
            this.cpEntry[e] = new ColorPanel(this.data.entryColor()[e]);
            Util.gblAdd(p1, this.cpEntry[e], gbc, 1, ypos++, 1, 1, 0, 0, 0, 5, 0, 5);
            this.cpEntry[e].addActionListener(this);
        }
        Util.gblAdd(p1, new Label(""), gbc, 0, ypos, 1, 1, 1, 1);
        ScrollPane sp = new ScrollPane();
        sp.add(p1);
        GrayLWPanel p2 = new GrayLWPanel();
        p2.setLayout(gbl);
        Util.gblAdd(p2, sp, gbc, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        GrayLWPanel p3 = new GrayLWPanel();
        p3.setLayout(new FlowLayout());
        this.bApply = new Button("Apply");
        this.bApply.addActionListener(this);
        p3.add(this.bApply);
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        p3.add(this.bClose);
        p.setLayout(gbl);
        Util.gblAdd(p, p2, gbc, 0, 0, 1, 1, 1, 1, 4, 4, 2, 4);
        Util.gblAdd(p, p3, gbc, 0, 1, 1, 1, 1, 0, 2, 4, 4, 4);
    }

    class GrayLWPanel
    extends LWPanel {
        private static final long serialVersionUID = 1L;

        GrayLWPanel() {
        }

        public void paint(Graphics g) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            super.paint(g);
        }
    }
}

