/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.util.LinkedList;
import java.util.ListIterator;
import projections.gui.graph.XAxis;

public class XAxisDiscrete
extends XAxis {
    String title;
    String[] discreteNames;

    public XAxisDiscrete(String title, LinkedList discreteList) {
        this.title = title;
        try {
            this.discreteNames = new String[discreteList.size()];
            for (int i = 0; i < this.discreteNames.length; ++i) {
                this.discreteNames[i] = (String)discreteList.get(i);
            }
        }
        catch (ClassCastException e) {
            ListIterator temp = discreteList.listIterator();
            this.discreteNames = new String[discreteList.size()];
            int count = 0;
            try {
                while (temp.hasNext()) {
                    this.discreteNames[count++] = ((Integer)temp.next()).toString();
                }
            }
            catch (ClassCastException evt) {
                System.err.println("Internal Error: XAxisDiscrete expects either an Integer or String LinkedList . Please report this error to a developer.");
                System.err.println(evt);
                System.exit(-1);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getIndexName(int index) {
        return this.discreteNames[index];
    }

    public double getMultiplier() {
        return 1.0;
    }
}

