/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.debug.preference.Execution;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParamsDialog
extends JDialog
implements ActionListener {
    Execution exec = null;
    private JTextField clParams;
    private JTextField numPes;
    private JTextField portno;
    private JTextField sshport;
    private JTextField hostname;
    private JTextField username;
    private JTextField filename;
    private JTextField dir;
    private JTextField inputFile;
    private JCheckBox sshTunnel;
    private JCheckBox waitFile;
    private JButton chooser;
    private JButton dirchooser;

    public ParamsDialog(Frame parent, boolean modal, Execution obj) {
        super(parent, modal);
        this.exec = obj;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    private void initComponents() {
        this.setTitle("Program Parameters");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel contents = new JPanel();
        int nextLine = 0;
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        contents.setLayout(grid);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel filenamelabel = new JLabel("Executable:");
        filenamelabel.setLabelFor(this.filename);
        grid.setConstraints(filenamelabel, c);
        contents.add(filenamelabel);
        this.filename = new JTextField(35);
        this.filename.setActionCommand("cmd.ok");
        this.filename.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.filename, c);
        this.chooser = new JButton("Change");
        this.chooser.setActionCommand("browse");
        this.chooser.addActionListener(this);
        c.gridx = 3;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 13;
        c.insets = new Insets(12, 5, 0, 10);
        grid.setConstraints(this.chooser, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel dirlabel = new JLabel("Working dir:");
        dirlabel.setLabelFor(this.dir);
        grid.setConstraints(dirlabel, c);
        contents.add(dirlabel);
        this.dir = new JTextField(35);
        this.dir.setActionCommand("cmd.ok");
        this.dir.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.dir, c);
        this.dirchooser = new JButton("Change");
        this.dirchooser.setActionCommand("browsedir");
        this.dirchooser.addActionListener(this);
        c.gridx = 3;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 13;
        c.insets = new Insets(12, 5, 0, 10);
        grid.setConstraints(this.dirchooser, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel paramlabel = new JLabel();
        paramlabel.setText("Command Line Parameters:");
        paramlabel.setLabelFor(this.clParams);
        grid.setConstraints(paramlabel, c);
        contents.add(paramlabel);
        this.clParams = new JTextField(35);
        this.clParams.setActionCommand("cmd.ok");
        this.clParams.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(11, 7, 0, 0);
        grid.setConstraints(this.clParams, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel peslabel = new JLabel();
        peslabel.setText("Number of Processors:");
        peslabel.setLabelFor(this.numPes);
        grid.setConstraints(peslabel, c);
        contents.add(peslabel);
        this.numPes = new JTextField(5);
        this.numPes.setActionCommand("cmd.ok");
        this.numPes.addActionListener(this);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        grid.setConstraints(this.numPes, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel portNumberLabel = new JLabel();
        portNumberLabel.setText("Port Number:");
        portNumberLabel.setLabelFor(this.portno);
        grid.setConstraints(portNumberLabel, c);
        contents.add(portNumberLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.portno = new JTextField(5);
        this.portno.setActionCommand("cmd.ok");
        this.portno.addActionListener(this);
        grid.setConstraints(this.portno, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel sshportNameLabel = new JLabel();
        sshportNameLabel.setText("SSH port number:");
        sshportNameLabel.setLabelFor(this.sshport);
        grid.setConstraints(sshportNameLabel, c);
        contents.add(sshportNameLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.sshport = new JTextField(5);
        this.sshport.setActionCommand("cmd.ok");
        this.sshport.addActionListener(this);
        grid.setConstraints(this.sshport, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(12, 12, 0, 0);
        JLabel hostNameLabel = new JLabel();
        hostNameLabel.setText("Host name:");
        hostNameLabel.setLabelFor(this.hostname);
        grid.setConstraints(hostNameLabel, c);
        contents.add(hostNameLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(12, 8, 0, 0);
        this.hostname = new JTextField(20);
        this.hostname.setActionCommand("cmd.ok");
        this.hostname.addActionListener(this);
        grid.setConstraints(this.hostname, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(6, 12, 0, 0);
        JLabel userNameLabel = new JLabel();
        userNameLabel.setText("Username:");
        userNameLabel.setLabelFor(this.username);
        grid.setConstraints(userNameLabel, c);
        contents.add(userNameLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(6, 8, 0, 0);
        this.username = new JTextField(15);
        this.username.setActionCommand("cmd.ok");
        this.username.addActionListener(this);
        grid.setConstraints(this.username, c);
        c.gridx = 0;
        c.gridy = nextLine;
        c.anchor = 17;
        c.insets = new Insets(6, 12, 0, 0);
        JLabel inputFileLabel = new JLabel();
        inputFileLabel.setText("Input file:");
        inputFileLabel.setLabelFor(this.inputFile);
        grid.setConstraints(inputFileLabel, c);
        contents.add(inputFileLabel);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(6, 8, 0, 0);
        this.inputFile = new JTextField(15);
        this.inputFile.setActionCommand("cmd.ok");
        this.inputFile.addActionListener(this);
        grid.setConstraints(this.inputFile, c);
        c.gridx = 1;
        c.gridy = nextLine++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 4, 0, 0);
        this.waitFile = new JCheckBox("Wait for file to be created");
        grid.setConstraints(this.waitFile, c);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 4, 0, 0);
        this.sshTunnel = new JCheckBox("Use ssh tunneling");
        grid.setConstraints(this.sshTunnel, c);
        contents.add(this.filename);
        contents.add(this.chooser);
        contents.add(this.dir);
        contents.add(this.dirchooser);
        contents.add(this.clParams);
        contents.add(this.numPes);
        contents.add(this.portno);
        contents.add(this.sshport);
        contents.add(this.hostname);
        contents.add(this.username);
        contents.add(this.inputFile);
        contents.add(this.waitFile);
        contents.add(this.sshTunnel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton();
        okButton.setText("OK");
        okButton.setActionCommand("cmd.ok");
        okButton.addActionListener(this);
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton cancelButton = new JButton();
        cancelButton.setText("CANCEL");
        cancelButton.setActionCommand("cmd.cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        c.gridx = 1;
        c.gridy = nextLine;
        c.gridwidth = 7;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.insets = new Insets(4, 8, 4, 4);
        grid.setConstraints(buttonPanel, c);
        contents.add(buttonPanel);
        this.getContentPane().add(contents);
        this.filename.setText(this.exec.executable);
        this.clParams.setText(this.exec.parameters);
        this.numPes.setText("" + this.exec.npes);
        this.portno.setText("" + this.exec.port);
        this.sshport.setText("" + this.exec.sshport);
        this.hostname.setText(this.exec.hostname);
        this.username.setText(this.exec.username);
        this.inputFile.setText(this.exec.inputFile);
        this.waitFile.setSelected(this.exec.waitFile);
        this.sshTunnel.setSelected(this.exec.sshTunnel);
        this.dir.setText(this.exec.workingDir);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean closeWindow = false;
        if (e.getActionCommand().equals("browse")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.filename.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getActionCommand().equals("browsedir")) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.dir.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getActionCommand().equals("cmd.cancel")) {
            closeWindow = true;
        } else if (e.getActionCommand().equals("cmd.ok")) {
            int numberPes;
            int sshportNumber = 0;
            try {
                numberPes = Integer.parseInt(this.numPes.getText());
                if (!this.portno.getText().equals("")) {
                    int n = Integer.parseInt(this.portno.getText());
                }
                if (!this.sshport.getText().equals("")) {
                    sshportNumber = Integer.parseInt(this.sshport.getText());
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
                return;
            }
            this.exec.executable = this.filename.getText();
            this.exec.parameters = this.clParams.getText();
            this.exec.npes = numberPes;
            this.exec.port = this.portno.getText();
            this.exec.sshport = sshportNumber;
            this.exec.hostname = this.hostname.getText();
            this.exec.username = this.username.getText();
            this.exec.inputFile = this.inputFile.getText();
            this.exec.waitFile = this.waitFile.isSelected();
            this.exec.sshTunnel = this.sshTunnel.isSelected();
            this.exec.workingDir = this.dir.getText();
            closeWindow = true;
        }
        if (closeWindow) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(200, 100);
            }
        };
        frame.setTitle("Debugging frame");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(false);
        ParamsDialog dialog = new ParamsDialog((Frame)frame, true, null);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent event) {
                System.exit(0);
            }
        });
        dialog.pack();
        dialog.setVisible(true);
    }
}

