/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjDefs;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;

public class LogReader
extends ProjDefs {
    int myRun = 0;
    public static final int SYS_Q = 0;
    public static final int SYS_CPU = 1;
    public static final int SYS_IDLE = 2;
    public static final int IDLE_ENTRY = -1;
    public static final int CREATE = 0;
    public static final int PROCESS = 1;
    public static final int TIME = 2;
    private int[][][] sysUsgData;
    private int[][][][] userEntries;
    private int[][][][] categorized;
    private int numProcessors;
    private int numUserEntries;
    private long startTime;
    private int currentEntry;
    private int currentMtype;
    private int interval;
    private int curPeIdx;
    private int numIntervals;
    private long intervalSize;
    private int intervalStart;
    private int intervalEnd;
    private int processing;
    private boolean byEntryPoint;
    private LogEntryData curData = new LogEntryData();
    private GenericLogReader reader;

    public long getIntervalSize() {
        return this.intervalSize;
    }

    private final void addToInterval(int extra, int j, boolean maxPercents) {
        if (this.processing <= 0) {
            return;
        }
        if (j < this.intervalStart || j > this.intervalEnd) {
            return;
        }
        if (this.currentEntry == -1) {
            int[] nArray = this.sysUsgData[2][this.curPeIdx];
            int n = j - this.intervalStart;
            nArray[n] = nArray[n] + (maxPercents ? 100 : extra);
        } else {
            int[] nArray = this.sysUsgData[1][this.curPeIdx];
            int n = j - this.intervalStart;
            nArray[n] = nArray[n] + (maxPercents ? 100 : extra);
            if (this.byEntryPoint) {
                int[] nArray2 = this.userEntries[MainWindow.runObject[this.myRun].getEntryIndex(this.currentEntry)][2][this.curPeIdx];
                int n2 = j - this.intervalStart;
                nArray2[n2] = nArray2[n2] + extra;
                int catIdx = this.mtypeToCategoryIdx(this.currentMtype);
                if (catIdx != -1) {
                    int[] nArray3 = this.categorized[catIdx][2][this.curPeIdx];
                    int n3 = j - this.intervalStart;
                    nArray3[n3] = nArray3[n3] + extra;
                }
            }
        }
        this.startTime += (long)extra;
    }

    private final void count(int mtype, int entryID, int TYPE) {
        int entry = MainWindow.runObject[this.myRun].getEntryIndex(entryID);
        if (!this.byEntryPoint) {
            return;
        }
        if (this.userEntries[entry][TYPE][this.curPeIdx] == null) {
            this.userEntries[entry][TYPE][this.curPeIdx] = new int[this.numIntervals + 1];
        }
        if (TYPE == 1 && this.userEntries[entry][2][this.curPeIdx] == null) {
            this.userEntries[entry][2][this.curPeIdx] = new int[this.numIntervals + 1];
        }
        int[] nArray = this.userEntries[entry][TYPE][this.curPeIdx];
        int n = this.interval - this.intervalStart;
        nArray[n] = nArray[n] + 1;
        int catIdx = this.mtypeToCategoryIdx(mtype);
        if (catIdx != -1) {
            if (this.categorized[catIdx][TYPE][this.curPeIdx] == null) {
                this.categorized[catIdx][TYPE][this.curPeIdx] = new int[this.numIntervals + 1];
                if (TYPE == 1) {
                    this.categorized[catIdx][2][this.curPeIdx] = new int[this.numIntervals + 1];
                }
            }
            int[] nArray2 = this.categorized[catIdx][TYPE][this.curPeIdx];
            int n2 = this.interval - this.intervalStart;
            nArray2[n2] = nArray2[n2] + 1;
        }
    }

    private void fillToInterval(int newinterval) {
        if (this.interval >= newinterval) {
            return;
        }
        int extra = (int)((long)(this.interval + 1) * this.intervalSize - this.startTime);
        this.addToInterval(extra, this.interval, false);
        this.rescale(this.interval);
        for (int j = this.interval + 1; j < newinterval; ++j) {
            this.addToInterval((int)this.intervalSize, j, true);
        }
        this.interval = newinterval;
    }

    public int[][][][] getSystemMsgs() {
        return this.categorized;
    }

    public int[][][] getSystemUsageData() {
        return this.sysUsgData;
    }

    public int[][][][] getUserEntries() {
        return this.userEntries;
    }

    private void intervalCalc(int type, int mtype, int entry, long time) {
        this.fillToInterval((int)(time / this.intervalSize));
        switch (type) {
            case 4: {
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPeIdx];
                int n = this.interval - this.intervalStart;
                nArray[n] = nArray[n] + 1;
                break;
            }
            case 1: {
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPeIdx];
                int n = this.interval - this.intervalStart;
                nArray[n] = nArray[n] + 1;
                this.count(mtype, entry, 0);
                break;
            }
            case 21: {
                break;
            }
            case 2: {
                ++this.processing;
                this.startTime = time;
                if (this.interval < this.intervalStart || this.interval > this.intervalEnd) break;
                int[] nArray = this.sysUsgData[0][this.curPeIdx];
                int n = this.interval - this.intervalStart;
                nArray[n] = nArray[n] - 1;
                this.currentMtype = mtype;
                this.currentEntry = entry;
                this.count(this.currentMtype, this.currentEntry, 1);
                break;
            }
            case 3: {
                if (mtype == -5) break;
                if (this.interval >= this.intervalStart && this.interval <= this.intervalEnd) {
                    this.addToInterval((int)(time - this.startTime), this.interval, false);
                }
                --this.processing;
                break;
            }
            case 14: {
                ++this.processing;
                this.startTime = time;
                this.currentEntry = -1;
                break;
            }
            case 15: {
                if (this.interval >= this.intervalStart && this.interval <= this.intervalEnd) {
                    this.addToInterval((int)(time - this.startTime), this.interval, false);
                }
                --this.processing;
                break;
            }
            case 12: {
                this.currentEntry = -1;
                break;
            }
            default: {
                System.out.println("Unhandled type " + type + " in logreader!");
            }
        }
    }

    private final int mtypeToCategoryIdx(int mtype) {
        switch (mtype) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 14: 
            case 15: {
                return 4;
            }
        }
        return -1;
    }

    public void read(long reqIntervalSize, int NintervalStart, int NintervalEnd, boolean NbyEntryPoint, OrderedIntList processorList) {
        this.numProcessors = MainWindow.runObject[this.myRun].getNumProcessors();
        this.numUserEntries = MainWindow.runObject[this.myRun].getNumUserEntries();
        this.intervalSize = reqIntervalSize;
        this.intervalStart = NintervalStart;
        this.intervalEnd = NintervalEnd;
        this.numIntervals = this.intervalEnd - this.intervalStart + 1;
        this.byEntryPoint = NbyEntryPoint;
        if (processorList == null) {
            processorList = new OrderedIntList();
            for (int pe = 0; pe < this.numProcessors; ++pe) {
                processorList.insert(pe);
            }
        } else {
            this.numProcessors = processorList.size();
        }
        ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Reading log files", "", 0, this.numProcessors);
        progressBar.setNote("Allocating Global Memory");
        progressBar.setProgress(0);
        this.sysUsgData = new int[3][this.numProcessors][];
        if (this.byEntryPoint) {
            this.userEntries = new int[this.numUserEntries][3][this.numProcessors][this.numIntervals];
            this.categorized = new int[5][3][this.numProcessors][];
        }
        processorList.reset();
        int curPe = processorList.nextElement();
        this.curPeIdx = 0;
        while (curPe != -1) {
            progressBar.setProgress(this.curPeIdx);
            progressBar.setNote("[PE: " + curPe + " ] Allocating Memory.");
            this.sysUsgData[0][this.curPeIdx] = new int[this.numIntervals + 1];
            this.sysUsgData[1][this.curPeIdx] = new int[this.numIntervals + 1];
            this.sysUsgData[2][this.curPeIdx] = new int[this.numIntervals + 1];
            progressBar.setNote("[PE: " + curPe + " ] Reading data.");
            if (progressBar.isCanceled()) {
                this.userEntries = null;
                this.categorized = null;
                this.sysUsgData = null;
                return;
            }
            this.processing = 0;
            this.interval = 0;
            this.currentEntry = -1;
            this.startTime = 0L;
            int nLines = 2;
            this.reader = new GenericLogReader(curPe, MainWindow.runObject[this.myRun].getVersion());
            boolean isProcessing = false;
            try {
                while (true) {
                    this.curData = this.reader.nextEvent();
                    ++nLines;
                    switch (this.curData.type) {
                        case 14: 
                        case 15: {
                            this.intervalCalc(this.curData.type, 0, 0, this.curData.time);
                            break;
                        }
                        case 1: {
                            this.intervalCalc(this.curData.type, this.curData.mtype, this.curData.entry, this.curData.time);
                            break;
                        }
                        case 2: {
                            if (isProcessing) {
                                this.intervalCalc(3, this.curData.mtype, this.curData.entry, this.curData.time);
                                isProcessing = false;
                            }
                            this.intervalCalc(this.curData.type, this.curData.mtype, this.curData.entry, this.curData.time);
                            isProcessing = true;
                            break;
                        }
                        case 3: {
                            if (!isProcessing) {
                                this.intervalCalc(this.curData.type, -5, this.curData.entry, this.curData.time);
                            } else {
                                this.intervalCalc(this.curData.type, this.curData.mtype, this.curData.entry, this.curData.time);
                            }
                            isProcessing = false;
                            break;
                        }
                        case 4: {
                            this.intervalCalc(this.curData.type, this.curData.mtype, 0, this.curData.time);
                            break;
                        }
                        case 7: {
                            this.fillToInterval(this.numIntervals);
                            break;
                        }
                        case 11: {
                            break;
                        }
                        case 12: {
                            this.intervalCalc(this.curData.type, this.curData.mtype, 0, this.curData.time);
                        }
                    }
                }
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                System.err.println("Error: Failure to read log file!");
                System.exit(-1);
            }
            try {
                this.reader.close();
            }
            catch (IOException e) {
                System.err.println("Error! Failed to close reader!");
                System.exit(-1);
            }
            ++this.curPeIdx;
            curPe = processorList.nextElement();
        }
        progressBar.close();
    }

    private void rescale(int j) {
        if (j < this.intervalStart || j > this.intervalEnd) {
            return;
        }
        this.sysUsgData[1][this.curPeIdx][j - this.intervalStart] = (int)((long)(this.sysUsgData[1][this.curPeIdx][j - this.intervalStart] * 100) / this.intervalSize);
        this.sysUsgData[2][this.curPeIdx][j - this.intervalStart] = (int)((long)(this.sysUsgData[2][this.curPeIdx][j - this.intervalStart] * 100) / this.intervalSize);
    }
}

