/*****************************************************************************
 * $Source: /cvsroot/charm-6.1.2/src/ck-ldb/RandCentLB.C,v $
 * $Author: gzheng $
 * $Date: 2005-01-10 04:20:39 $
 * $Revision: 1.29 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

/*
Status:
  * support nonmigratable attrib
  * support processor avail bitvector
*/

#include <charm++.h>

#include "cklists.h"

#include "RandCentLB.h"

CreateLBFunc_Def(RandCentLB, "Assign objects to processors randomly");

RandCentLB::RandCentLB(const CkLBOptions &opt): CentralLB(opt)
{
  lbname = "RandCentLB";
  if (CkMyPe() == 0)
    CkPrintf("[%d] RandCentLB created\n",CkMyPe());
}

CmiBool RandCentLB::QueryBalanceNow(int _step)
{
  return CmiTrue;
}

inline int chooseProc(int count)
{
  return (int)(CrnDrand()*(count-1) + 0.5);
}

void RandCentLB::work(BaseLB::LDStats* stats, int count)
{
  if (_lb_args.debug()) CkPrintf("Calling RandCentLB strategy\n",CkMyPe());

  int proc;
  for (proc=0; proc<count; proc++) {
    if (stats->procs[proc].available) break;
  }
  if (proc == count) CmiAbort("RandCentLB> no available processor!");

  int nmigrated = 0;
  for(int obj=0; obj < stats->n_objs; obj++) {
      LDObjData &odata = stats->objData[obj];
      if (odata.migratable) {
	int dest = chooseProc(count);
	while (!stats->procs[dest].available) dest = chooseProc(count);
	if (dest != stats->from_proc[obj]) {
          if (_lb_args.debug() >= 2)
            CkPrintf("[%d] Obj %d migrating from %d to %d\n", CkMyPe(),obj,stats->from_proc[obj],dest);
          nmigrated ++;
	  stats->to_proc[obj] = dest;
        }
      }
  }
}

#include "RandCentLB.def.h"

/*@}*/
