/*****************************************************************************
 * $Source: /cvsroot/charm-6.1.2/src/ck-core/msgalloc.C,v $
 * $Author: idooley2 $
 * $Date: 2008-12-04 00:22:36 $
 * $Revision: 2.18 $
 *****************************************************************************/

#include "ck.h"
#include "queueing.h"

extern "C"
void *CkAllocSysMsg(void)
{
  return CkpvAccess(_msgPool)->get();
}

extern "C"
void CkFreeSysMsg(void *m)
{
  CkpvAccess(_msgPool)->put(m);
}

extern "C"
void* CkAllocMsg(int msgIdx, int msgBytes, int prioBits)
{
  register envelope* env;
  env = _allocEnv(ForChareMsg, msgBytes, prioBits);
  setMemoryTypeMessage(env);

  env->setQueueing(_defaultQueueing);
  env->setMsgIdx(msgIdx);

#ifdef USE_CRITICAL_PATH_HEADER_ARRAY
  env->setEpIdxHistory();
#endif

  return EnvToUsr(env);
}

extern "C"
void* CkAllocBuffer(void *msg, int bufsize)
{
  bufsize = CkMsgAlignLength(bufsize);
  register envelope *env = UsrToEnv(msg);
  register envelope *packbuf;
  packbuf = _allocEnv(env->getMsgtype(), bufsize, 
                      env->getPriobits());
  
  register int size = packbuf->getTotalsize();
  CmiMemcpy(packbuf, env, sizeof(envelope));
  packbuf->setTotalsize(size);
  packbuf->setPacked(!env->isPacked());
  CmiMemcpy(packbuf->getPrioPtr(), env->getPrioPtr(), packbuf->getPrioBytes());

#ifdef USE_CRITICAL_PATH_HEADER_ARRAY
  env->setEpIdxHistory();
#endif

  return EnvToUsr(packbuf);;
}

extern "C"
void  CkFreeMsg(void *msg)
{
  if (msg!=NULL) {
      CmiFree(UsrToEnv(msg));
  }
}


extern "C"
void* CkCopyMsg(void **pMsg)
{// cannot simply memcpy, because srcMsg could be varsize msg
  register void *srcMsg = *pMsg;
  register envelope *env = UsrToEnv(srcMsg);
  register unsigned char msgidx = env->getMsgIdx();
  if(!env->isPacked() && _msgTable[msgidx]->pack) {
    srcMsg = _msgTable[msgidx]->pack(srcMsg);
    UsrToEnv(srcMsg)->setPacked(1);
  }
  register int size = UsrToEnv(srcMsg)->getTotalsize();
  register envelope *newenv = (envelope *) CmiAlloc(size);
  CmiMemcpy(newenv, UsrToEnv(srcMsg), size);
  if(UsrToEnv(srcMsg)->isPacked() && _msgTable[msgidx]->unpack) {
    srcMsg = _msgTable[msgidx]->unpack(srcMsg);
    UsrToEnv(srcMsg)->setPacked(0);
  }
  *pMsg = srcMsg;
  if(newenv->isPacked() && _msgTable[msgidx]->unpack) {
    srcMsg = _msgTable[msgidx]->unpack(EnvToUsr(newenv));
    UsrToEnv(srcMsg)->setPacked(0);
  } else srcMsg = EnvToUsr(newenv);

  setMemoryTypeMessage(newenv);
  return srcMsg;
}

extern "C"
void  CkSetQueueing(void *msg, int strategy)
{
  UsrToEnv(msg)->setQueueing((unsigned char) strategy);
}


extern "C"
void* CkPriorityPtr(void *msg)
{
  return UsrToEnv(msg)->getPrioPtr();
}

CkMarshallMsg *CkAllocateMarshallMsgNoninline(int size,const CkEntryOptions *opts)
{
	//Allocate the message
	CkMarshallMsg *m=new (size,opts->getPriorityBits())CkMarshallMsg;
	//Copy the user's priority data into the message
	envelope *env=UsrToEnv(m);
	setMemoryTypeMessage(env);
	CmiMemcpy(env->getPrioPtr(),opts->getPriorityPtr(),env->getPrioBytes());
	//Set the message's queueing type
	env->setQueueing((unsigned char)opts->getQueueing());
#ifdef USE_CRITICAL_PATH_HEADER_ARRAY
	env->setEpIdxHistory();
#endif
	return m;
}

