package projector.core;


import projector.gui.*;
import projector.language.*;

import java.io.*;
import java.util.Vector;
import java.util.StringTokenizer;

/*** Author Sayantan Chakravorty
	Date 01/07/2003
	File to read in initialization data from Projector Logs ********/

public class InitDataReader {
	private StsReader sts;
	private PTCReader ptcReader;
	private String validPEstring;
	private double endTime;
	public InitDataReader(StsReader stsreader){
		try{
		sts = stsreader;
		ptcReader = new PTCReader(sts.getFilename()+".ptc");
		String baseName = sts.getFilename();
		validPEstring = "0-"+(new Integer (ptcReader.numProcs-1)).toString();
		endTime = 0.0;
		
		for(int i=0;i < ptcReader.maxLangs;i++){
			if(ptcReader.lName[i] == null) continue;
			String langName = ptcReader.lName[i]+".log";
			for(int npe=0;npe<ptcReader.numProcs;npe++){
				RandomAccessFile fReader = new RandomAccessFile(baseName+"."+npe+"."+langName,"r");
				long len = fReader.length()-1;
				while(len > 0 ){
					fReader.seek(len-1);
					if(fReader.readByte() == '\n'){
						break;
					}
					len = len-2;
				}
				if(len > 0 && len < fReader.length()-2){
					String Line = fReader.readLine();
					StringTokenizer st = new StringTokenizer(Line);
					Integer.parseInt(st.nextToken());
					double time = Double.parseDouble(st.nextToken());
					System.out.println("LastTime = " +time);
					if(time > endTime){
						endTime = time;
					}
					
				}
			}
		}
		}catch(Exception e){
			System.err.println("Exception :"+e);
		}
	}
	
	public long getEndTime(){
		long val = (long )(endTime * 1000000.0);
		return val;
	}
	
	public String getValidPEString(){
		return validPEstring;
	}
}
