/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.util.Vector;
import projections.gui.Analysis;

public class AmpiFunctionData {
    public int FunctionID;
    public int LineNo;
    public String sourceFileName;
    private long accExecTime;
    private long lastBeginTime;
    private Vector execIntervals;

    public AmpiFunctionData() {
        this.LineNo = 0;
        this.FunctionID = 0;
        this.sourceFileName = null;
        this.accExecTime = 0L;
        this.lastBeginTime = 0L;
        this.execIntervals = new Vector();
    }

    public AmpiFunctionData(int n, int n2, String string) {
        this.FunctionID = n;
        this.LineNo = n2;
        this.sourceFileName = string;
        this.accExecTime = 0L;
        this.execIntervals = new Vector();
    }

    public void incrAccExecTime(long l) {
        this.accExecTime += l;
    }

    public long getAccExecTime() {
        return this.accExecTime;
    }

    public void incrAccExecTimeNow(long l) {
        this.accExecTime += l - this.lastBeginTime;
    }

    public void setLastBeginTime(long l) {
        this.lastBeginTime = l;
    }

    public long getLastBeginTime() {
        return this.lastBeginTime;
    }

    public String toString() {
        return this.sourceFileName + "@" + this.LineNo + "::" + this.FunctionID + " : " + this.accExecTime;
    }

    public Vector getExecIntervals() {
        return this.execIntervals;
    }

    public void insertExecInterval(AmpiFuncExecInterval ampiFuncExecInterval) {
        this.execIntervals.add(ampiFuncExecInterval);
    }

    public AmpiFuncExecInterval getIntervalAt(int n) {
        return (AmpiFuncExecInterval)this.execIntervals.get(n);
    }

    public int execIntervalCnt() {
        return this.execIntervals.size();
    }

    public String getFunctionName() {
        String string = Analysis.getFunctionName(this.FunctionID);
        return string + "@" + this.sourceFileName + "(" + this.LineNo + ")";
    }

    public static class AmpiFuncExecInterval {
        public long startTimestamp;
        public long endTimestamp;

        public AmpiFuncExecInterval(long l, long l2) {
            this.startTimestamp = l;
            this.endTimestamp = l2;
        }

        public String toString() {
            return "Start: " + this.startTimestamp + "; End: " + this.endTimestamp;
        }
    }
}

