/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Component;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjDefs;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.misc.LogEntryData;

public class CallGraph
extends ProjDefs {
    private int numPe;
    private int numEPs;
    private double[][] messageArray;
    private double[][] byteArray;
    private double[][] externalMessageArray;
    private double[][] externalByteArray;
    private long startTime;
    private long endTime;
    private OrderedIntList peList;

    public CallGraph(int n, int n2, long l, OrderedIntList orderedIntList) {
        this.peList = orderedIntList;
        this.numPe = this.peList.size();
        this.numEPs = Analysis.getNumUserEntries();
        this.startTime = (long)n * l;
        this.endTime = (long)n2 * l;
        this.messageArray = new double[n2 - n + 1][this.numEPs * 2];
        this.byteArray = new double[n2 - n + 1][this.numEPs * 2];
        this.externalMessageArray = new double[n2 - n + 1][this.numEPs * 2];
        this.externalByteArray = new double[n2 - n + 1][this.numEPs * 2];
    }

    public void GatherData(Component component) {
        LogEntryData logEntryData = new LogEntryData();
        int n = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(component, "Reading log files", "", 0, this.numPe);
        while (this.peList.hasMoreElements()) {
            int n2 = this.peList.nextElement();
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                break;
            }
            progressMonitor.setNote("[PE: " + n2 + "] Reading data.");
            progressMonitor.setProgress(n + 1);
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n2), Analysis.getVersion());
            try {
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                while (logEntryData.time < this.endTime) {
                    int n3;
                    int n4;
                    if (logEntryData.type == 1) {
                        n4 = logEntryData.entry;
                        n3 = this.getInterval(logEntryData.time);
                        double[] dArray = this.messageArray[n3];
                        int n5 = n4;
                        dArray[n5] = dArray[n5] + 1.0;
                        double[] dArray2 = this.byteArray[n3];
                        int n6 = n4;
                        dArray2[n6] = dArray2[n6] + (double)logEntryData.msglen;
                    } else if (logEntryData.type == 2) {
                        n4 = logEntryData.entry;
                        n3 = logEntryData.pe;
                        int n7 = this.getInterval(logEntryData.time);
                        double[] dArray = this.messageArray[n7];
                        int n8 = n4 + this.numEPs;
                        dArray[n8] = dArray[n8] + 1.0;
                        double[] dArray3 = this.byteArray[n7];
                        int n9 = n4 + this.numEPs;
                        dArray3[n9] = dArray3[n9] + (double)logEntryData.msglen;
                        if (n2 != n3) {
                            double[] dArray4 = this.externalMessageArray[n7];
                            int n10 = n4 + this.numEPs;
                            dArray4[n10] = dArray4[n10] + 1.0;
                            double[] dArray5 = this.externalByteArray[n7];
                            int n11 = n4 + this.numEPs;
                            dArray5[n11] = dArray5[n11] + (double)logEntryData.msglen;
                        }
                    }
                    genericLogReader.nextEvent(logEntryData);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
        progressMonitor.close();
    }

    public double[][] getMessageArray() {
        return this.messageArray;
    }

    public double[][] getByteArray() {
        return this.byteArray;
    }

    public double[][] getExternalMessageArray() {
        return this.externalMessageArray;
    }

    public double[][] getExternalByteArray() {
        return this.externalByteArray;
    }

    private int getInterval(long l) {
        float f = l - this.startTime;
        return (int)((f /= (float)(this.endTime - this.startTime)) * (float)this.messageArray.length);
    }
}

