/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.util.Hashtable;
import java.util.Stack;

public class CallStackManager
extends Hashtable {
    Stack activeStack;

    public void push(Object object, int n, int n2, int n3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(n, n2, n3));
        if (this.activeStack == null) {
            this.activeStack = new Stack();
            this.put(this.tripleToKey(n, n2, n3), this.activeStack);
        }
        this.activeStack.push(object);
    }

    public Object pop(int n, int n2, int n3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(n, n2, n3));
        if (this.activeStack == null) {
            return null;
        }
        if (this.activeStack.empty()) {
            return null;
        }
        return this.activeStack.pop();
    }

    public Object read(int n, int n2, int n3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(n, n2, n3));
        if (this.activeStack == null) {
            return null;
        }
        if (this.activeStack.empty()) {
            return null;
        }
        return this.activeStack.peek();
    }

    public Stack getStack(int n, int n2, int n3) {
        this.activeStack = (Stack)this.get(this.tripleToKey(n, n2, n3));
        if (this.activeStack == null) {
            return null;
        }
        if (this.activeStack.empty()) {
            return null;
        }
        return (Stack)this.activeStack.clone();
    }

    private Object tripleToKey(int n, int n2, int n3) {
        String string = "[0]" + String.valueOf(n) + "[1]" + String.valueOf(n2) + "[2]" + String.valueOf(n3);
        return string;
    }

    public static void main(String[] stringArray) {
        CallStackManager callStackManager = new CallStackManager();
        callStackManager.push("Hello", 3, 4, 5);
        callStackManager.push("There", 3, 4, 5);
        callStackManager.push("You", 3, 4, 5);
        Stack stack = callStackManager.getStack(3, 4, 5);
        callStackManager.pop(3, 4, 5);
        Stack stack2 = callStackManager.getStack(3, 4, 5);
        callStackManager.push("Dummy", 3, 4, 5);
        System.out.println("Stack1 top = " + (String)stack.pop());
        System.out.println("Stack2 top = " + (String)stack2.pop());
        System.out.println("Current top = " + (String)callStackManager.getStack(3, 4, 5).pop());
    }
}

