/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.PointCapableReader;
import projections.analysis.ProjectionsReader;
import projections.gui.Analysis;
import projections.misc.LogEntryData;

public class GenericLogReader
extends ProjectionsReader
implements PointCapableReader {
    private static final long INITIAL_STEP = 1024L;
    private AsciiIntegerReader reader;
    private double version;
    private boolean fakedEndComputation = false;
    private long lastRecordedTime = 0L;
    private LogEntryData lastBeginEvent = new LogEntryData();
    private Vector[] intervalData;

    public GenericLogReader(String string, double d) {
        super(string, String.valueOf(d));
        this.lastBeginEvent.setValid(false);
        try {
            this.reader = new AsciiIntegerReader(new FileReader(string));
            this.version = d;
            this.reader.nextLine();
        }
        catch (IOException iOException) {
            System.err.println("Error reading file " + string);
        }
    }

    public GenericLogReader(int n, double d) {
        super(Analysis.getLogName(n), String.valueOf(d));
        this.lastBeginEvent.setValid(false);
        try {
            this.reader = new AsciiIntegerReader(new FileReader(this.sourceString));
            this.version = d;
            this.reader.nextLine();
        }
        catch (IOException iOException) {
            System.err.println("Error reading file " + this.sourceString);
        }
    }

    protected boolean checkAvailable() {
        File file = new File(this.sourceString);
        return file.canRead();
    }

    public void readStaticData() {
    }

    public void reset() throws IOException {
        this.reader.close();
        this.reader = new AsciiIntegerReader(new FileReader(this.sourceString));
        this.reader.nextLine();
    }

    public void nextEvent(LogEntryData logEntryData) throws IOException, EOFException {
        try {
            logEntryData.type = this.reader.nextInt();
            switch (logEntryData.type) {
                case 14: {
                    this.lastBeginEvent.time = logEntryData.time = this.reader.nextLong();
                    this.lastBeginEvent.pe = logEntryData.pe = this.reader.nextInt();
                    this.lastBeginEvent.setValid(true);
                    this.reader.nextLine();
                    break;
                }
                case 15: {
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.pe = this.reader.nextInt();
                    this.lastBeginEvent.setValid(false);
                    this.reader.nextLine();
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 1: {
                    logEntryData.mtype = this.reader.nextInt();
                    logEntryData.entry = this.reader.nextInt();
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    logEntryData.msglen = this.version >= 2.0 ? this.reader.nextInt() : -1;
                    if (!(this.version >= 5.0)) break;
                    logEntryData.sendTime = this.reader.nextLong();
                    break;
                }
                case 21: {
                    logEntryData.mtype = this.reader.nextInt();
                    logEntryData.entry = this.reader.nextInt();
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    logEntryData.msglen = this.version >= 2.0 ? this.reader.nextInt() : -1;
                    if (this.version >= 5.0) {
                        logEntryData.sendTime = this.reader.nextLong();
                    }
                    logEntryData.destPEs = new int[this.reader.nextInt()];
                    for (int i = 0; i < logEntryData.destPEs.length; ++i) {
                        logEntryData.destPEs[i] = this.reader.nextInt();
                    }
                    break;
                }
                case 2: {
                    this.lastBeginEvent.mtype = logEntryData.mtype = this.reader.nextInt();
                    this.lastBeginEvent.entry = logEntryData.entry = this.reader.nextInt();
                    this.lastBeginEvent.time = logEntryData.time = this.reader.nextLong();
                    this.lastBeginEvent.event = logEntryData.event = this.reader.nextInt();
                    this.lastBeginEvent.pe = logEntryData.pe = this.reader.nextInt();
                    if (this.version >= 2.0) {
                        this.lastBeginEvent.msglen = logEntryData.msglen = this.reader.nextInt();
                    } else {
                        logEntryData.msglen = -1;
                        this.lastBeginEvent.msglen = -1;
                    }
                    if (this.version >= 4.0) {
                        this.lastBeginEvent.recvTime = logEntryData.recvTime = this.reader.nextLong();
                        this.lastBeginEvent.id[0] = logEntryData.id[0] = this.reader.nextInt();
                        this.lastBeginEvent.id[1] = logEntryData.id[1] = this.reader.nextInt();
                        this.lastBeginEvent.id[2] = logEntryData.id[2] = this.reader.nextInt();
                    }
                    if (this.version >= 6.5) {
                        this.lastBeginEvent.cpuStartTime = logEntryData.cpuStartTime = this.reader.nextLong();
                    }
                    if (this.version >= 6.6) {
                        this.lastBeginEvent.numPerfCounts = logEntryData.numPerfCounts = this.reader.nextInt();
                        this.lastBeginEvent.perfCounts = new long[logEntryData.numPerfCounts];
                        logEntryData.perfCounts = new long[logEntryData.numPerfCounts];
                        for (int i = 0; i < logEntryData.numPerfCounts; ++i) {
                            this.lastBeginEvent.perfCounts[i] = logEntryData.perfCounts[i] = this.reader.nextLong();
                        }
                    }
                    this.lastBeginEvent.setValid(true);
                    this.reader.nextLine();
                    break;
                }
                case 3: {
                    logEntryData.mtype = this.reader.nextInt();
                    logEntryData.entry = this.reader.nextInt();
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    logEntryData.msglen = this.version >= 2.0 ? this.reader.nextInt() : -1;
                    if (this.version >= 6.5) {
                        logEntryData.cpuEndTime = this.reader.nextLong();
                    }
                    if (this.version >= 6.6) {
                        logEntryData.numPerfCounts = this.reader.nextInt();
                        logEntryData.perfCounts = new long[logEntryData.numPerfCounts];
                        for (int i = 0; i < logEntryData.numPerfCounts; ++i) {
                            logEntryData.perfCounts[i] = this.reader.nextLong();
                        }
                    }
                    this.reader.nextLine();
                    break;
                }
                case 11: {
                    logEntryData.time = this.reader.nextLong();
                    this.lastBeginEvent.setValid(false);
                    this.reader.nextLine();
                    break;
                }
                case 12: {
                    logEntryData.time = this.reader.nextLong();
                    this.reader.nextLine();
                    break;
                }
                case 22: {
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.entry = this.reader.nextInt();
                    logEntryData.lineNo = this.reader.nextInt();
                    logEntryData.funcName = this.reader.nextString();
                    this.reader.nextLine();
                    break;
                }
                case 23: {
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.entry = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 10: {
                    logEntryData.mtype = this.reader.nextInt();
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    logEntryData.msglen = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 4: 
                case 5: {
                    logEntryData.mtype = this.reader.nextInt();
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 8: 
                case 9: {
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 6: 
                case 7: {
                    logEntryData.time = this.reader.nextLong();
                    this.reader.nextLine();
                    break;
                }
                case 13: {
                    logEntryData.entry = logEntryData.userEventID = this.reader.nextInt();
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                case 100: {
                    logEntryData.entry = logEntryData.userEventID = this.reader.nextInt();
                    logEntryData.time = this.reader.nextLong();
                    logEntryData.event = this.reader.nextInt();
                    logEntryData.pe = this.reader.nextInt();
                    this.reader.nextLine();
                    break;
                }
                default: {
                    logEntryData.type = -1;
                    this.reader.nextLine();
                }
            }
            this.lastRecordedTime = logEntryData.time;
        }
        catch (EOFException eOFException) {
            if (this.fakedEndComputation || logEntryData.type == 7) {
                throw eOFException;
            }
            this.fakedEndComputation = true;
            logEntryData.type = 7;
            logEntryData.time = this.lastRecordedTime;
            System.err.println("[" + this.sourceString + "] " + "WARNING: Partial or Corrupted " + "Projections log. Faked END_COMPUTATION " + "entry added for last recorded time of " + logEntryData.time);
        }
    }

    public void nextEventOnOrAfter(long l, LogEntryData logEntryData) throws IOException, EOFException {
        this.seqLookForNextEventOnOrAfter(l, logEntryData);
    }

    private void lookForNextEventOnOrAfter(long l, long l2, long l3, long l4, LogEntryData logEntryData) throws IOException, EOFException {
        this.reader.skip(l2 - l4);
        this.reader.nextLine();
        this.nextEvent(logEntryData);
        while (logEntryData.type == -1) {
            this.nextEvent(logEntryData);
        }
        if (logEntryData.time >= l && logEntryData.time <= l) {
            return;
        }
    }

    private void seqLookForNextEventOnOrAfter(long l, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEvent(logEntryData);
            while (logEntryData.type == -1) {
                this.nextEvent(logEntryData);
            }
        } while (logEntryData.time < l);
    }

    public void nextEventOfType(int n, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEvent(logEntryData);
        } while (logEntryData.type != n);
    }

    public void nextEventOfTypeOnOrAfter(int n, long l, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEventOnOrAfter(l, logEntryData);
        } while (logEntryData.type != n);
    }

    public void nextBeginEvent(LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEvent(logEntryData);
        } while (!this.isBeginType(logEntryData));
    }

    public void nextEndEvent(LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEvent(logEntryData);
        } while (!this.isEndType(logEntryData));
    }

    public void nextBeginEventOnOrAfter(long l, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEventOnOrAfter(l, logEntryData);
        } while (!this.isBeginType(logEntryData));
    }

    public void nextEndEventOnOrAfter(long l, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEventOnOrAfter(l, logEntryData);
        } while (!this.isEndType(logEntryData));
    }

    public LogEntryData getLastBE() {
        if (this.lastBeginEvent.isValid()) {
            return this.lastBeginEvent;
        }
        return null;
    }

    private boolean isBeginType(LogEntryData logEntryData) {
        return logEntryData.type == 14 || logEntryData.type == 16 || logEntryData.type == 18 || logEntryData.type == 2 || logEntryData.type == 11 || logEntryData.type == 22 || logEntryData.type == 8;
    }

    private boolean isEndType(LogEntryData logEntryData) {
        return logEntryData.type == 15 || logEntryData.type == 17 || logEntryData.type == 19 || logEntryData.type == 3 || logEntryData.type == 12 || logEntryData.type == 23 || logEntryData.type == 9;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

