/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import projections.analysis.IntervalUtils;
import projections.analysis.RLEBlock;
import projections.analysis.SumDetailReader;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;

public class IntervalData {
    public static final int NUM_TYPES = 2;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_NUM_MSGS = 1;
    private static SumDetailReader[] summaryDetails;
    private Vector[][][] rawData;
    private int[][][] systemUsageData = null;
    private int[][][][] systemMsgsData = null;
    private int[][][][] userEntryData = null;
    private int numEPs = 0;
    private int numPEs = Analysis.getNumProcessors();
    private int numIntervals = 0;
    private double intervalSize = 0.0;

    public IntervalData() {
        this.numEPs = Analysis.getNumUserEntries();
        if (Analysis.hasSumDetailData()) {
            summaryDetails = new SumDetailReader[this.numPEs];
            this.rawData = new Vector[2][this.numPEs][];
            OrderedIntList orderedIntList = Analysis.getValidProcessorList(2);
            orderedIntList.reset();
            while (orderedIntList.hasMoreElements()) {
                int n = orderedIntList.nextElement();
                try {
                    IntervalData.summaryDetails[n] = new SumDetailReader(Analysis.getSumDetailName(n), Analysis.getVersion());
                    summaryDetails[n].read();
                    for (int i = 0; i < 2; ++i) {
                        this.rawData[i][n] = summaryDetails[n].getData(i);
                    }
                    if (this.numIntervals < summaryDetails[n].getNumIntervals()) {
                        this.numIntervals = summaryDetails[n].getNumIntervals();
                    }
                    this.intervalSize = summaryDetails[n].getIntervalSize();
                }
                catch (IOException iOException) {
                    System.err.println("Warning: Failed to read summary detail file for processor " + n);
                }
            }
        }
    }

    public void loadIntervalData(long l, int n, int n2, boolean bl, OrderedIntList orderedIntList) {
        int n3 = n2 - n + 1;
        this.systemUsageData = new int[3][orderedIntList.size()][n3];
        this.systemMsgsData = new int[5][3][orderedIntList.size()][n3];
        if (bl) {
            this.userEntryData = new int[this.numEPs][3][orderedIntList.size()][n3];
        }
        double[][] dArray = null;
        int n4 = 0;
        int n5 = 0;
        orderedIntList.reset();
        while (orderedIntList.hasMoreElements()) {
            int n6;
            int n7;
            n5 = orderedIntList.nextElement();
            dArray = this.getData(n5, 0, l, n, n2 - n + 1);
            for (n7 = 0; n7 < n3; ++n7) {
                for (n6 = 0; n6 < this.numEPs; ++n6) {
                    if (bl) {
                        this.userEntryData[n6][2][n4][n7] = (int)dArray[n6][n7];
                    }
                    int[] nArray = this.systemUsageData[1][n4];
                    int n8 = n7;
                    nArray[n8] = nArray[n8] + (int)dArray[n6][n7];
                }
                this.systemUsageData[1][n4][n7] = (int)IntervalUtils.timeToUtil(this.systemUsageData[1][n4][n7], (double)l);
            }
            dArray = this.getData(n5, 1, l, n, n2 - n + 1);
            for (n7 = 0; n7 < n3; ++n7) {
                for (n6 = 0; n6 < this.numEPs; ++n6) {
                    int[] nArray = this.systemMsgsData[1][2][n4];
                    int n9 = n7;
                    nArray[n9] = nArray[n9] + (int)dArray[n6][n7];
                }
            }
            ++n4;
        }
    }

    public int[][][] getSystemUsageData() {
        return this.systemUsageData;
    }

    public int[][][][] getSystemMsgs() {
        return this.systemMsgsData;
    }

    public int[][][][] getUserEntries() {
        return this.userEntryData;
    }

    public double[][] getData(int n, int n2) {
        double[][] dArray = new double[this.numEPs][this.numIntervals];
        for (int i = 0; i < this.numEPs; ++i) {
            Iterator iterator = this.rawData[n2][n][i].iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                RLEBlock rLEBlock = (RLEBlock)iterator.next();
                for (int j = 0; j < rLEBlock.count; ++j) {
                    dArray[i][n3 + j] = rLEBlock.value;
                }
                n3 += rLEBlock.count;
            }
        }
        return dArray;
    }

    public double[][] getData(int n, int n2, long l, int n3, int n4) {
        double[][] dArray = this.getData(n, n2);
        double[][] dArray2 = null;
        if ((double)l == this.intervalSize) {
            if (n3 == 0 && n4 == this.numIntervals) {
                return dArray;
            }
            dArray2 = new double[this.numEPs][n4];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = n3; j < n3 + n4; ++j) {
                    dArray2[i][j - n3] = dArray[i][j];
                }
            }
            return dArray2;
        }
        dArray2 = new double[this.numEPs][n4];
        boolean bl = false;
        if (n2 == 1) {
            bl = true;
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                IntervalUtils.fillIntervals(dArray2[i], l, n3, (long)((double)j * this.intervalSize), (long)((double)(j + 1) * this.intervalSize - 1.0), dArray[i][j], bl);
            }
        }
        return dArray2;
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    private void accumulateIntoArray(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        int n6 = 0;
        boolean bl = false;
        Iterator iterator = this.rawData[n][n2][n3].iterator();
        while (iterator.hasNext()) {
            RLEBlock rLEBlock = (RLEBlock)iterator.next();
            int n7 = n6 + rLEBlock.count - 1;
            if (n7 < n4) {
                n6 = n7 + 1;
                continue;
            }
            if (n6 < n4) {
                n6 = n4;
            }
            if (n7 > n5) {
                n7 = n5;
                bl = true;
            }
            for (int i = n6 - n4; i <= n7 - n4; ++i) {
                dArray[i] = rLEBlock.value;
            }
            n6 = n7 + 1;
            if (!bl) continue;
            break;
        }
    }

    public double[][] getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3) {
        int n4 = Analysis.getNumUserEntries();
        double[][] dArray = new double[n4][n3 - n2 + 1];
        for (int i = 0; i < n4; ++i) {
            orderedIntList.reset();
            for (int j = 0; j < orderedIntList.size(); ++j) {
                int n5 = orderedIntList.nextElement();
                this.accumulateIntoArray(n, n5, i, n2, n3, dArray[i]);
            }
        }
        return dArray;
    }

    public Vector getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3, OrderedIntList orderedIntList2) {
        Vector<double[]> vector = new Vector<double[]>();
        double[] dArray = null;
        orderedIntList2.reset();
        for (int i = 0; i < orderedIntList2.size(); ++i) {
            dArray = new double[n3 - n2 + 1];
            int n4 = orderedIntList2.nextElement();
            orderedIntList.reset();
            for (int j = 0; j < orderedIntList.size(); ++j) {
                int n5 = orderedIntList.nextElement();
                this.accumulateIntoArray(n, n5, n4, n2, n3, dArray);
            }
            vector.add(dArray);
        }
        return vector;
    }
}

