/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.analysis.CallStackManager;
import projections.analysis.GenericLogReader;
import projections.analysis.LogEntry;
import projections.analysis.ObjectId;
import projections.analysis.PackTime;
import projections.analysis.ProjDefs;
import projections.analysis.TimelineEvent;
import projections.analysis.TimelineMessage;
import projections.analysis.UserEvent;
import projections.analysis.ViewerEvent;
import projections.gui.Analysis;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.EntryNotFoundException;
import projections.misc.LogEntryData;
import projections.misc.LogLoadException;

public class LogLoader
extends ProjDefs {
    private long prevTime = 0L;
    private boolean deltaEncoded = false;
    private int tokenExpected = 2;
    private boolean isProcessing = false;
    boolean ampiTraceOn = false;

    public long determineEndTime(OrderedIntList orderedIntList) throws LogLoadException {
        long l = 0L;
        long l2 = Integer.MIN_VALUE;
        int n = orderedIntList.size();
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Determining end time", "", 0, n);
        orderedIntList.reset();
        int n2 = 1;
        while (orderedIntList.hasMoreElements()) {
            int n3 = orderedIntList.nextElement();
            if (!progressMonitor.isCanceled()) {
                progressMonitor.setNote("[" + n3 + "] " + n2 + " of " + n + " files");
                progressMonitor.setProgress(n2);
            } else {
                System.err.println("Fatal error - Projections cannot function without proper end time!");
                System.exit(-1);
            }
            ++n2;
            long l3 = 0L;
            int n4 = 0;
            long l4 = 0L;
            int n5 = 0;
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(new File(Analysis.getLogName(n3)), "r");
                long l5 = randomAccessFile.length() - 240L;
                if (l5 < 0L) {
                    l5 = 0L;
                }
                randomAccessFile.seek(l5);
                while (randomAccessFile.readByte() != 10) {
                }
                while (true) {
                    String string;
                    if ((string = randomAccessFile.readLine()) == null) {
                        throw new EOFException();
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    n5 = Integer.parseInt(stringTokenizer.nextToken());
                    if (n5 == 7) {
                        long l6 = Long.parseLong(stringTokenizer.nextToken());
                        if (l6 <= l2) break;
                        l2 = l6;
                        break;
                    }
                    switch (n5) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 21: {
                            n4 = Integer.parseInt(stringTokenizer.nextToken());
                            n4 = Integer.parseInt(stringTokenizer.nextToken());
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 10: 
                        case 13: 
                        case 100: {
                            n4 = Integer.parseInt(stringTokenizer.nextToken());
                            break;
                        }
                    }
                    l3 = Long.parseLong(stringTokenizer.nextToken());
                }
                randomAccessFile.close();
            }
            catch (EOFException eOFException) {
                System.err.println("[" + n3 + "] " + "WARNING: Partial Log: Faking End " + "Time determination at last recorded " + "time of " + l3);
                if (l3 <= l2) continue;
                l2 = l3;
            }
            catch (IOException iOException) {
                System.err.println("Couldn't read log file " + Analysis.getLogName(n3));
            }
        }
        progressMonitor.close();
        return l2 - l;
    }

    public void createAMPIUsageProfile(int n, long l, long l2, Vector vector) throws LogLoadException {
        Object object;
        GenericLogReader genericLogReader = null;
        LogEntryData logEntryData = null;
        LogEntry logEntry = null;
        LogEntry logEntry2 = null;
        Object object2 = null;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        try {
            genericLogReader = new GenericLogReader(n, Analysis.getVersion());
            logEntryData = new LogEntryData();
            do {
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
            } while (logEntry.TransactionType != 2 || logEntry.Entry == -1 || logEntry.Time < l);
            object2 = new AmpiProcessProfile(logEntry.Time, logEntry.id);
            logEntry2 = logEntry;
            boolean bl = false;
            while (!bl) {
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
                if (logEntry.Entry == -1) continue;
                switch (logEntry.TransactionType) {
                    case 2: {
                        if (object2 != null) {
                            System.err.println("Error in parsing log file as processing overlapped!");
                            return;
                        }
                        object = new AmpiProcessProfile(logEntry.Time, logEntry.id);
                        Object object3 = (AmpiProcessProfile)hashtable.get(((AmpiProcessProfile)object).toHashKey());
                        object2 = object3 == null ? object : object3;
                        break;
                    }
                    case 3: {
                        if (object2 == null) {
                            System.err.println("Error in parsing log file as processing is not paired!");
                            return;
                        }
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        if (!((AmpiProcessProfile)object2).getAuxCallFuncStack().empty()) {
                            object = (AmpiFunctionData)((AmpiProcessProfile)object2).getAuxCallFuncStack().peek();
                            ((AmpiFunctionData)object).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        }
                        if (hashtable.get(((AmpiProcessProfile)object2).toHashKey()) == null) {
                            hashtable.put(((AmpiProcessProfile)object2).toHashKey(), object2);
                        }
                        object2 = null;
                        if (logEntry.Time < l2) break;
                        bl = true;
                        break;
                    }
                    case 22: {
                        if (object2 == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        object = logEntry.ampiData;
                        Object object3 = ((AmpiProcessProfile)object2).getAuxCallFuncStack();
                        ((Stack)object3).push(object);
                        break;
                    }
                    case 23: {
                        if (object2 == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        if (((AmpiProcessProfile)object2).getAuxCallFuncStack().empty()) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        object = (AmpiFunctionData)((AmpiProcessProfile)object2).getAuxCallFuncStack().peek();
                        if (((AmpiFunctionData)object).FunctionID != logEntry.FunctionID) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        ((AmpiFunctionData)object).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        ((AmpiProcessProfile)object2).getAuxCallFuncStack().pop();
                        ((AmpiProcessProfile)object2).getFinalCallFuncStack().push(object);
                        break;
                    }
                    case 1: 
                    case 16: 
                    case 18: {
                        if (object2 == null) break;
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        if (((AmpiProcessProfile)object2).getAuxCallFuncStack().empty()) break;
                        object = (AmpiFunctionData)((AmpiProcessProfile)object2).getAuxCallFuncStack().peek();
                        ((AmpiFunctionData)object).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        break;
                    }
                }
                logEntry2 = logEntry;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (IOException iOException) {
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (AmpiProcessProfile)hashtable.get(enumeration.nextElement());
            if (((AmpiProcessProfile)object).getFinalCallFuncStack().size() <= 0) continue;
            vector.add(object);
        }
    }

    public void createAMPIFuncTimeProfile(int n, long l, long l2, Vector vector) throws LogLoadException {
        Object object;
        GenericLogReader genericLogReader = null;
        LogEntryData logEntryData = null;
        LogEntry logEntry = null;
        LogEntry logEntry2 = null;
        Object object2 = null;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        try {
            genericLogReader = new GenericLogReader(n, Analysis.getVersion());
            logEntryData = new LogEntryData();
            do {
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
            } while (logEntry.TransactionType != 2 || logEntry.Entry == -1 || logEntry.Time < l);
            object2 = new AmpiProcessProfile(logEntry.Time, logEntry.id);
            logEntry2 = logEntry;
            boolean bl = false;
            while (!bl) {
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
                if (logEntry.Entry == -1) continue;
                switch (logEntry.TransactionType) {
                    case 2: {
                        if (object2 != null) {
                            System.err.println("Error in parsing log file as processing overlapped!");
                            return;
                        }
                        object = new AmpiProcessProfile(logEntry.Time, logEntry.id);
                        Object object3 = (AmpiProcessProfile)hashtable.get(((AmpiProcessProfile)object).toHashKey());
                        object2 = object3 == null ? object : object3;
                        break;
                    }
                    case 3: {
                        Object object3;
                        if (object2 == null) {
                            System.err.println("Error in parsing log file as processing is not paired!");
                            return;
                        }
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        if (!((AmpiProcessProfile)object2).getAuxCallFuncStack().empty()) {
                            object = (AmpiFunctionData)((AmpiProcessProfile)object2).getAuxCallFuncStack().peek();
                            object3 = new AmpiFunctionData.AmpiFuncExecInterval(logEntry2.Time, logEntry.Time);
                            ((AmpiFunctionData)object).insertExecInterval((AmpiFunctionData.AmpiFuncExecInterval)object3);
                            ((AmpiFunctionData)object).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        }
                        if (hashtable.get(((AmpiProcessProfile)object2).toHashKey()) == null) {
                            hashtable.put(((AmpiProcessProfile)object2).toHashKey(), object2);
                        }
                        object2 = null;
                        if (logEntry.Time < l2) break;
                        bl = true;
                        break;
                    }
                    case 22: {
                        if (object2 == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        object = logEntry.ampiData;
                        Object object3 = ((AmpiProcessProfile)object2).getAuxCallFuncStack();
                        ((Stack)object3).push(object);
                        break;
                    }
                    case 23: {
                        if (object2 == null) {
                            System.err.println("Error in parsing log file as a function is not in a processing!");
                            return;
                        }
                        if (((AmpiProcessProfile)object2).getAuxCallFuncStack().empty()) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        object = (AmpiFunctionData)((AmpiProcessProfile)object2).getAuxCallFuncStack().peek();
                        if (((AmpiFunctionData)object).FunctionID != logEntry.FunctionID) {
                            System.err.println("Error in parsing log file as a function is not paired properly!");
                            return;
                        }
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        Object object3 = new AmpiFunctionData.AmpiFuncExecInterval(logEntry2.Time, logEntry.Time);
                        ((AmpiFunctionData)object).insertExecInterval((AmpiFunctionData.AmpiFuncExecInterval)object3);
                        ((AmpiFunctionData)object).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        ((AmpiProcessProfile)object2).getAuxCallFuncStack().pop();
                        ((AmpiProcessProfile)object2).getFinalCallFuncStack().push(object);
                        break;
                    }
                    case 1: 
                    case 16: 
                    case 18: {
                        if (object2 == null) break;
                        ((AmpiProcessProfile)object2).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        if (((AmpiProcessProfile)object2).getAuxCallFuncStack().empty()) break;
                        object = (AmpiFunctionData)((AmpiProcessProfile)object2).getAuxCallFuncStack().peek();
                        Object object3 = new AmpiFunctionData.AmpiFuncExecInterval(logEntry2.Time, logEntry.Time);
                        ((AmpiFunctionData)object).insertExecInterval((AmpiFunctionData.AmpiFuncExecInterval)object3);
                        ((AmpiFunctionData)object).incrAccExecTime(logEntry.Time - logEntry2.Time);
                        break;
                    }
                }
                logEntry2 = logEntry;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (IOException iOException) {
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (AmpiProcessProfile)hashtable.get(enumeration.nextElement());
            if (((AmpiProcessProfile)object).getFinalCallFuncStack().size() <= 0) continue;
            vector.add(object);
        }
    }

    public Vector createtimeline(int n, long l, long l2, Vector vector, Vector vector2) throws LogLoadException {
        long l3 = 0L;
        int n2 = 0;
        long l4 = Long.MIN_VALUE;
        boolean bl = true;
        LogEntry logEntry = null;
        TimelineEvent timelineEvent = null;
        Hashtable hashtable = new Hashtable();
        UserEvent userEvent = null;
        TimelineMessage timelineMessage = null;
        PackTime packTime = null;
        System.gc();
        try {
            GenericLogReader genericLogReader = new GenericLogReader(n, Analysis.getVersion());
            LogEntryData logEntryData = new LogEntryData();
            if (Analysis.getNumFunctionEvents() > 0) {
                this.ampiTraceOn = true;
            }
            this.prevTime = 0L;
            this.isProcessing = false;
            LogEntry logEntry2 = null;
            while (true) {
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
                if (logEntry.Time >= l) break;
                if (logEntry.Entry == -1) continue;
                if (logEntry.TransactionType == 2 && logEntry.Entry != -1) {
                    l4 = logEntry.Time - l3;
                    n2 = logEntry.Entry;
                    logEntry2 = logEntry;
                    continue;
                }
                if (logEntry.TransactionType == 3 && logEntry.Entry != -1) {
                    l4 = logEntry.Time - l3;
                    n2 = logEntry.Entry;
                    logEntry2 = null;
                    continue;
                }
                if (logEntry.TransactionType == 14) {
                    l4 = logEntry.Time - l3;
                    logEntry2 = logEntry;
                    continue;
                }
                if (logEntry.TransactionType != 15) continue;
                logEntry2 = null;
            }
            if (l4 == Long.MIN_VALUE) {
                l4 = l;
            }
            if (logEntry.Time > l2) {
                switch (logEntry.TransactionType) {
                    case 2: {
                        System.out.println("finished empty timeline for " + n);
                        return vector;
                    }
                    case 3: {
                        if (logEntry2 != null && logEntry2.TransactionType == 2 && logEntry2.Entry == logEntry.Entry) {
                            timelineEvent = new TimelineEvent(logEntry2.Time - l3, logEntry.Time - l3, logEntry2.Entry, logEntry2.Pe);
                            vector.addElement(timelineEvent);
                        }
                        return vector;
                    }
                    case 14: {
                        System.out.println("finished empty timeline for " + n);
                        return vector;
                    }
                    case 15: {
                        if (logEntry2 != null && logEntry2.TransactionType == 14) {
                            timelineEvent = new TimelineEvent(logEntry2.Time - l3, logEntry.Time - l3, -1, -1);
                            vector.addElement(timelineEvent);
                        }
                        return vector;
                    }
                }
                if (logEntry2 != null) {
                    switch (logEntry2.TransactionType) {
                        case 2: {
                            timelineEvent = new TimelineEvent(logEntry2.Time - l3, l2 - l3, logEntry2.Entry, logEntry2.Pe);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 14: {
                            timelineEvent = new TimelineEvent(logEntry2.Time - l3, l2 - l3, -1, -1);
                            vector.addElement(timelineEvent);
                        }
                    }
                } else {
                    System.out.println("finished empty timeline for " + n);
                }
                return vector;
            }
            CallStackManager callStackManager = new CallStackManager();
            LogEntry logEntry3 = null;
            ObjectId objectId = null;
            AmpiFunctionData ampiFunctionData = null;
            block29: while (true) {
                if (logEntry.Entry != -1) {
                    switch (logEntry.TransactionType) {
                        case 22: {
                            logEntry2 = null;
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = logEntry.Time - l3;
                            }
                            timelineEvent = new TimelineEvent();
                            timelineEvent.isFunction = true;
                            timelineEvent.BeginTime = logEntry.Time - l3;
                            timelineEvent.EntryPoint = logEntry.FunctionID;
                            timelineEvent.EventID = -1;
                            timelineEvent.id = logEntry3.id;
                            callStackManager.push(logEntry.ampiData, timelineEvent.id.id[0], timelineEvent.id.id[1], timelineEvent.id.id[2]);
                            timelineEvent.callStack = callStackManager.getStack(timelineEvent.id.id[0], timelineEvent.id.id[1], timelineEvent.id.id[2]);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 23: {
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = logEntry.Time - l3;
                                callStackManager.pop(timelineEvent.id.id[0], timelineEvent.id.id[1], timelineEvent.id.id[2]);
                            }
                            timelineEvent = null;
                            objectId = logEntry3.id;
                            ampiFunctionData = (AmpiFunctionData)callStackManager.read(objectId.id[0], objectId.id[1], objectId.id[2]);
                            if (ampiFunctionData == null || ampiFunctionData.FunctionID == 0) {
                                timelineEvent = new TimelineEvent(logEntry.Time - l3, logEntry.Time - l3, logEntry3.Entry, logEntry3.Pe, logEntry3.MsgLen, logEntry3.recvTime, logEntry3.id, -1, logEntry3.cpuBegin, logEntry3.cpuEnd, logEntry3.numPapiCounts, logEntry3.papiCounts);
                                vector.addElement(timelineEvent);
                                break;
                            }
                            timelineEvent = new TimelineEvent();
                            timelineEvent.isFunction = true;
                            timelineEvent.BeginTime = logEntry.Time - l3;
                            timelineEvent.EntryPoint = ampiFunctionData.FunctionID;
                            timelineEvent.EventID = -1;
                            timelineEvent.id = objectId;
                            timelineEvent.callStack = callStackManager.getStack(timelineEvent.id.id[0], timelineEvent.id.id[1], timelineEvent.id.id[2]);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 2: {
                            logEntry2 = null;
                            if (this.isProcessing) {
                                if (timelineEvent != null) {
                                    timelineEvent.EndTime = logEntry.Time - l3;
                                }
                                timelineEvent = null;
                            }
                            this.isProcessing = true;
                            if (this.ampiTraceOn && logEntry.Entry == 0) {
                                logEntry3 = logEntry;
                                objectId = logEntry3.id;
                                ampiFunctionData = (AmpiFunctionData)callStackManager.read(objectId.id[0], objectId.id[1], objectId.id[2]);
                                if (ampiFunctionData != null && ampiFunctionData.FunctionID != 0) {
                                    timelineEvent = new TimelineEvent();
                                    timelineEvent.isFunction = true;
                                    timelineEvent.BeginTime = logEntry.Time - l3;
                                    timelineEvent.EntryPoint = ampiFunctionData.FunctionID;
                                    timelineEvent.SrcPe = logEntry3.Pe;
                                    timelineEvent.EventID = logEntry3.EventID;
                                    timelineEvent.MsgLen = logEntry3.MsgLen;
                                    timelineEvent.RecvTime = logEntry3.recvTime;
                                    timelineEvent.id = objectId;
                                    timelineEvent.callStack = callStackManager.getStack(timelineEvent.id.id[0], timelineEvent.id.id[1], timelineEvent.id.id[2]);
                                    vector.addElement(timelineEvent);
                                    break;
                                }
                            }
                            timelineEvent = new TimelineEvent(logEntry.Time - l3, logEntry.Time - l3, logEntry.Entry, logEntry.Pe, logEntry.MsgLen, logEntry.recvTime, logEntry.id, logEntry.EventID, logEntry.cpuBegin, logEntry.cpuEnd, logEntry.numPapiCounts, logEntry.papiCounts);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 3: {
                            if (logEntry2 != null && logEntry2.TransactionType == 2 && logEntry2.Entry == logEntry.Entry) {
                                timelineEvent = new TimelineEvent(logEntry2.Time - l3, logEntry.Time - l3, logEntry2.Entry, logEntry2.Pe);
                                vector.addElement(timelineEvent);
                                timelineEvent = null;
                                this.isProcessing = false;
                                break;
                            }
                            logEntry2 = null;
                            if (this.ampiTraceOn && logEntry.Entry == 0) {
                                objectId = logEntry3.id;
                                ampiFunctionData = (AmpiFunctionData)callStackManager.read(objectId.id[0], objectId.id[1], objectId.id[2]);
                                if (ampiFunctionData != null && ampiFunctionData.FunctionID != 0) {
                                    if (timelineEvent != null) {
                                        timelineEvent.EndTime = logEntry.Time - l3;
                                    }
                                    timelineEvent = null;
                                    logEntry3 = null;
                                    break;
                                }
                            }
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = logEntry.Time - l3;
                                timelineEvent.cpuEnd = logEntry.cpuEnd;
                                for (int i = 0; i < logEntry.numPapiCounts; ++i) {
                                    timelineEvent.papiCounts[i] = logEntry.papiCounts[i] - timelineEvent.papiCounts[i];
                                }
                            }
                            timelineEvent = null;
                            this.isProcessing = false;
                            break;
                        }
                        case 1: {
                            if (logEntry2 != null && logEntry2.TransactionType == 2) {
                                timelineEvent = new TimelineEvent(logEntry2.Time - l3, l2 - l3, logEntry2.Entry, logEntry2.Pe);
                                vector.addElement(timelineEvent);
                                this.isProcessing = true;
                            }
                            logEntry2 = null;
                            boolean bl2 = false;
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(logEntry.Time - l3, logEntry.Time - l3, -2, logEntry.Pe, logEntry.MsgLen);
                                vector.addElement(timelineEvent);
                                bl2 = true;
                            }
                            timelineMessage = new TimelineMessage(logEntry.Time - l3, logEntry.Entry, logEntry.MsgLen, logEntry.EventID);
                            timelineEvent.addMessage(timelineMessage);
                            if (!bl2) break;
                            timelineEvent = null;
                            break;
                        }
                        case 21: {
                            if (logEntry2 != null && logEntry2.TransactionType == 2) {
                                timelineEvent = new TimelineEvent(logEntry2.Time - l3, l2 - l3, logEntry2.Entry, logEntry2.Pe);
                                vector.addElement(timelineEvent);
                                this.isProcessing = true;
                            }
                            logEntry2 = null;
                            boolean bl2 = false;
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(logEntry.Time - l3, logEntry.Time - l3, -2, logEntry.Pe, logEntry.MsgLen);
                                vector.addElement(timelineEvent);
                                bl2 = true;
                            }
                            timelineMessage = new TimelineMessage(logEntry.Time - l3, logEntry.Entry, logEntry.MsgLen, logEntry.EventID, logEntry.destPEs);
                            timelineEvent.addMessage(timelineMessage);
                            if (!bl2) break;
                            timelineEvent = null;
                            break;
                        }
                        case 13: {
                            UserEvent userEvent2 = new UserEvent(logEntry.Time - l3, logEntry.Entry, logEntry.EventID, 1);
                            vector2.addElement(userEvent2);
                            break;
                        }
                        case 100: {
                            userEvent = new UserEvent(logEntry.Time - l3, logEntry.Entry, logEntry.EventID, 2);
                            userEvent.EndTime = l2;
                            genericLogReader.nextEvent(logEntryData);
                            logEntry = LogEntry.adapt(logEntryData);
                            if (logEntry.TransactionType != 100) {
                                userEvent = null;
                                continue block29;
                            }
                            if (userEvent.CharmEventID != logEntry.EventID || userEvent.UserEventID != logEntry.Entry) {
                                userEvent = null;
                                continue block29;
                            }
                            userEvent.EndTime = logEntry.Time - l3;
                            vector2.addElement(userEvent);
                            break;
                        }
                        case 16: {
                            if (logEntry2 != null && logEntry2.TransactionType == 2) {
                                timelineEvent = new TimelineEvent(logEntry2.Time - l3, l2 - l3, logEntry2.Entry, logEntry2.Pe);
                                vector.addElement(timelineEvent);
                                this.isProcessing = true;
                            }
                            logEntry2 = null;
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(logEntry.Time - l3, logEntry.Time - l3, -2, logEntry.Pe);
                                vector.addElement(timelineEvent);
                            }
                            packTime = new PackTime(logEntry.Time - l3);
                            timelineEvent.addPack(packTime);
                            break;
                        }
                        case 17: {
                            if (packTime != null) {
                                packTime.EndTime = logEntry.Time - l3;
                            }
                            packTime = null;
                            if (timelineEvent == null || timelineEvent.EntryPoint != -2) break;
                            timelineEvent = null;
                            break;
                        }
                        case 14: {
                            logEntry2 = null;
                            if (MainWindow.IGNORE_IDLE) break;
                            timelineEvent = new TimelineEvent(logEntry.Time - l3, Long.MAX_VALUE, -1, -1);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 15: {
                            if (MainWindow.IGNORE_IDLE) break;
                            if (logEntry2 != null && logEntry2.TransactionType == 14) {
                                timelineEvent = new TimelineEvent(logEntry2.Time - l3, l2 - l3, -1, -1);
                                vector.addElement(timelineEvent);
                                this.isProcessing = true;
                            }
                            logEntry2 = null;
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = logEntry.Time - l3;
                            }
                            timelineEvent = null;
                        }
                    }
                }
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
                if (logEntry.Entry != -1 && logEntry.Time - l3 > l2) break;
            }
            while (timelineEvent != null) {
                if (logEntry.Entry != -1 && logEntry.TransactionType == 3) {
                    timelineEvent.EndTime = logEntry.Time - l3;
                    timelineEvent = null;
                }
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (IOException iOException) {
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        return vector;
    }

    private ViewerEvent entrytotext(LogEntry logEntry) {
        long l = 0L;
        ViewerEvent viewerEvent = new ViewerEvent();
        viewerEvent.Time = logEntry.Time - l;
        viewerEvent.EventType = logEntry.TransactionType;
        if (logEntry.Entry == -1) {
            return null;
        }
        switch (logEntry.TransactionType) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return viewerEvent;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                String[][] stringArray = Analysis.getEntryNames();
                viewerEvent.Dest = new String(stringArray[logEntry.Entry][1] + "::" + stringArray[logEntry.Entry][0]);
                if (logEntry.TransactionType != 1) {
                    viewerEvent.SrcPe = logEntry.Pe;
                }
                return viewerEvent;
            }
        }
        return null;
    }

    public long searchtimeline(int n, int n2, int n3) throws LogLoadException, EntryNotFoundException {
        long l = 0L;
        long l2 = 0L;
        LogEntry logEntry = null;
        try {
            System.gc();
            GenericLogReader genericLogReader = new GenericLogReader(n, Analysis.getVersion());
            LogEntryData logEntryData = new LogEntryData();
            this.prevTime = 0L;
            while (true) {
                genericLogReader.nextEvent(logEntryData);
                logEntry = LogEntry.adapt(logEntryData);
                if (logEntry.Entry == -1) continue;
                if (logEntry.Entry == n2 && logEntry.TransactionType == 2) {
                    ++l2;
                }
                if (l2 > (long)n3) break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        return logEntry.Time - l;
    }

    public Vector view(int n) throws LogLoadException {
        Vector<ViewerEvent> vector = null;
        try {
            vector = new Vector<ViewerEvent>();
            GenericLogReader genericLogReader = new GenericLogReader(n, Analysis.getVersion());
            LogEntryData logEntryData = new LogEntryData();
            this.prevTime = 0L;
            while (true) {
                genericLogReader.nextEvent(logEntryData);
                ViewerEvent viewerEvent = this.entrytotext(LogEntry.adapt(logEntryData));
                if (viewerEvent == null) continue;
                vector.addElement(viewerEvent);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + Analysis.getLogName(n));
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            System.out.println("throwing....2");
            throw new LogLoadException(Analysis.getLogName(n), 1);
        }
        return vector;
    }

    private void updatePEStringBuffer(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(",");
        }
        if (n2 > n) {
            stringBuffer.append(String.valueOf(n));
            stringBuffer.append("-");
            stringBuffer.append(String.valueOf(n2));
        } else if (n2 == n) {
            stringBuffer.append(String.valueOf(n));
        } else {
            System.err.println("Internal Error: When determining valid processor range, basePE(" + n + ") " + "> upperPE(" + n2 + ") which is " + "impossible. Please report to developers!");
            System.exit(-1);
        }
    }
}

