/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Color;
import java.util.Vector;
import projections.gui.ColorManager;
import projections.gui.U;
import projections.gui.graph.MultiRunDataSource;
import projections.gui.graph.MultiRunXAxis;
import projections.gui.graph.MultiRunYAxis;
import projections.misc.MultiRunData;
import projections.misc.ProjectionsStatistics;

public class MultiRunDataAnalyzer {
    private MultiRunData data;
    private double[][][] dataTable;
    private double[][][] extraTable;
    public static final int NUM_EXTR_ENTRIES = 1;
    public static final int EXTR_OVERHEAD = 0;
    private static final String[] extraNames = new String[]{"Idle Time and System Overhead"};
    private double[] runTimeSum;
    private double[] epTimeMean;
    private double[] epTimeVariance;
    private double[] extraTimeMean;
    private double[] extraTimeVariance;
    private Vector[][] categories;
    private String[] catNames;
    private static final int NUM_CATEGORIES = 4;
    private static final int CAT_EP_NO_CHANGE = 0;
    private static final int CAT_EP_INSIGNIFICANT = 1;
    private static final int CAT_EP_CHANGE = 2;
    private static final int CAT_OVERHEAD_IDLE = 3;
    private static final Color[] catColors = new Color[]{Color.green, Color.yellow, Color.red, Color.white};
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;
    private ProjectionsStatistics timeStats = new ProjectionsStatistics();
    private ProjectionsStatistics numCallsStats = new ProjectionsStatistics();
    double[][] outputData;

    public MultiRunDataAnalyzer(MultiRunData multiRunData) {
        this.data = multiRunData;
        this.numEPs = multiRunData.getNumEPs();
        this.numRuns = multiRunData.getNumRuns();
        this.epNames = multiRunData.getEPNames();
        this.runNames = multiRunData.getRunNames();
        this.dataTable = multiRunData.getData();
        this.computeDerivedInformation();
        this.computeExtraInformation();
        this.computeExtraDerivedInformation();
        this.constructCategories();
    }

    private void computeDerivedInformation() {
        int n;
        this.runTimeSum = new double[this.numRuns];
        for (n = 0; n < this.numRuns; ++n) {
            this.timeStats.reset();
            this.timeStats.accumulate(this.dataTable[0][n]);
            this.runTimeSum[n] = this.timeStats.getSum();
        }
        this.epTimeMean = new double[this.numEPs];
        this.epTimeVariance = new double[this.numEPs];
        for (n = 0; n < this.numEPs; ++n) {
            this.timeStats.reset();
            for (int i = 0; i < this.numRuns; ++i) {
                this.timeStats.accumulate(this.dataTable[0][i][n]);
            }
            this.epTimeMean[n] = this.timeStats.getMean();
            this.epTimeVariance[n] = this.timeStats.getVariance(this.epTimeMean[n]);
        }
    }

    public void computeExtraInformation() {
        this.extraTable = new double[4][this.numRuns][1];
        double[] dArray = this.data.getRunWallTimes();
        for (int i = 0; i < this.numRuns; ++i) {
            this.extraTable[0][i][0] = dArray[i] - this.runTimeSum[i];
        }
    }

    public void computeExtraDerivedInformation() {
    }

    private void constructCategories() {
        int n;
        this.categories = new Vector[4][4];
        this.catNames = new String[4];
        for (n = 0; n < 4; ++n) {
            this.catNames[n] = this.getCategoryName(n);
        }
        for (n = 0; n < 4; ++n) {
            for (int i = 0; i < 4; ++i) {
                this.categories[n][i] = new Vector();
            }
            this.categorize(n);
        }
    }

    private String getCategoryName(int n) {
        switch (n) {
            case 0: {
                return "EPs with little change";
            }
            case 1: {
                return "Insignificant EPs";
            }
            case 2: {
                return "EPs with change";
            }
            case 3: {
                return "Idle time and System Overhead";
            }
        }
        return "unknown category";
    }

    public void categorize(int n) {
        int n2;
        for (n2 = 0; n2 < this.numEPs; ++n2) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < this.numRuns; ++n3) {
                if (!(this.dataTable[n][n3][n2] < 0.01 * this.runTimeSum[n3])) continue;
                ++n4;
            }
            if (n4 > this.numRuns / 2) {
                this.categories[n][1].add(new Integer(n2));
                continue;
            }
            n3 = 0;
            int n5 = 0;
            boolean bl = true;
            double d = 0.0;
            double d2 = this.dataTable[n][0][n2];
            if (this.dataTable[n][1][n2] > d2) {
                n3 = 1;
                d += this.dataTable[n][1][n2] - d2;
                bl = true;
            } else if (this.dataTable[n][1][n2] < d2) {
                n5 = 1;
                d += d2 - this.dataTable[n][1][n2];
                bl = false;
            }
            d2 = this.dataTable[n][1][n2];
            for (int i = 2; i < this.numRuns; ++i) {
                double d3;
                if (this.dataTable[n][i][n2] > d2) {
                    d3 = this.dataTable[n][i][n2] - d2;
                    if (bl) {
                        d = d * (double)n3 + d3;
                        d /= (double)(++n3);
                    } else {
                        n3 = 1;
                        d = d3;
                    }
                    bl = true;
                } else if (this.dataTable[n][i][n2] < d2) {
                    d3 = d2 - this.dataTable[n][i][n2];
                    if (!bl) {
                        d = d * (double)n5 + d3;
                        d /= (double)(++n5);
                    } else {
                        n5 = 1;
                        d = d3;
                    }
                    bl = false;
                }
                d2 = this.dataTable[n][i][n2];
            }
            if (this.numRuns == 1) {
                this.categories[n][0].add(new Integer(n2));
                continue;
            }
            if (((double)n3 > (double)(this.numRuns - 1) * 0.5 || (double)n5 > (double)(this.numRuns - 1) * 0.5) && d > this.dataTable[n][0][n2] * 0.1) {
                this.categories[n][2].add(new Integer(n2));
                continue;
            }
            this.categories[n][0].add(new Integer(n2));
        }
        for (n2 = 0; n2 < 1; ++n2) {
            switch (n2) {
                case 0: {
                    this.categories[n][3].add(new Integer(this.numEPs + 0));
                }
            }
        }
    }

    public int getNumRows(int n, int n2) {
        return this.categories[n][n2].size();
    }

    public int getNumColumns(int n, int n2) {
        return this.numRuns + 1;
    }

    public String getColumnName(int n, int n2, int n3) {
        if (n3 == 0) {
            return "Entry Point Name";
        }
        return this.runNames[n3 - 1];
    }

    public Object getTableValueAt(int n, int n2, int n3, int n4) {
        int n5 = (Integer)this.categories[n][n2].elementAt(n3);
        if (n4 == 0) {
            if (n5 >= this.numEPs) {
                return extraNames[this.numEPs - n5];
            }
            return this.epNames[n5];
        }
        if (n5 >= this.numEPs) {
            return new Double(this.extraTable[n][n4 - 1][this.numEPs - n5]);
        }
        return new Double(this.dataTable[n][n4 - 1][n5]);
    }

    public String[] getCategoryNames() {
        return this.catNames;
    }

    public MultiRunDataSource getDataSource(int n) {
        int n2 = this.numEPs - this.categories[n][1].size() + 1 + 1;
        this.outputData = new double[this.numRuns][n2];
        String string = "";
        switch (n) {
            case 0: {
                string = "Time taken";
                break;
            }
            case 1: {
                string = "Number of times called";
                break;
            }
            case 2: {
                string = "Messages sent per processor";
                break;
            }
            case 3: {
                string = "Amount of data sent";
            }
        }
        this.computeOutputArray(this.outputData, n, 0);
        Color[] colorArray = this.computeColorMap(n2, n, 0);
        return new MultiRunDataSource(this, this.outputData, n, colorArray, string);
    }

    public MultiRunXAxis getMRXAxisData() {
        return new MultiRunXAxis(this.runNames);
    }

    public MultiRunYAxis getMRYAxisData(int n) {
        String string = "";
        int n2 = 1;
        switch (n) {
            case 0: {
                string = "Time summed across processors (us)";
                n2 = 1;
                break;
            }
            case 1: {
                string = "Number of times entry point was called";
                n2 = 2;
                break;
            }
            case 2: {
                string = "Number of messages sent per processor";
                n2 = 2;
                break;
            }
            case 3: {
                string = "Total amount of data sent (bytes)";
                n2 = 2;
            }
        }
        ProjectionsStatistics projectionsStatistics = new ProjectionsStatistics();
        for (int i = 0; i < this.numRuns; ++i) {
            projectionsStatistics.accumulate(this.outputData[i]);
        }
        return new MultiRunYAxis(n2, string, projectionsStatistics.getMax());
    }

    public String[] getPopup(int n, int n2, int n3) {
        String[] stringArray = new String[4];
        stringArray[0] = this.runNames[n];
        int n4 = this.categories[n3][0].size();
        int n5 = this.categories[n3][1].size();
        int n6 = this.categories[n3][2].size();
        int n7 = this.categories[n3][3].size();
        int n8 = 0;
        if (n2 < n4) {
            n8 = 0;
            int n9 = n2;
            int n10 = (Integer)this.categories[n3][n8].elementAt(n9);
            stringArray[2] = "Entry Point: " + this.epNames[n10];
        } else if (n2 < n4 + 1) {
            n8 = 1;
            stringArray[2] = "Bunch of EPs";
        } else if (n2 < n4 + 1 + n6) {
            n8 = 2;
            int n11 = n2 - 1 - n4;
            int n12 = (Integer)this.categories[n3][n8].elementAt(n11);
            stringArray[2] = "Entry Point: " + this.epNames[n12];
        } else {
            n8 = 3;
            stringArray[2] = "";
        }
        stringArray[1] = this.catNames[n8];
        switch (n3) {
            case 0: {
                stringArray[3] = "Exec Time: " + U.t((long)this.outputData[n][n2]);
                break;
            }
            case 1: {
                stringArray[3] = "Times called: " + (long)this.outputData[n][n2];
                break;
            }
            case 2: {
                stringArray[3] = "Msgs Sent: " + (long)this.outputData[n][n2];
                break;
            }
            case 3: {
                stringArray[3] = "Msg Volume: " + (long)this.outputData[n][n2];
            }
        }
        return stringArray;
    }

    private void computeOutputArray(double[][] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = this.categories[n][0].size();
        for (n7 = 0; n7 < n9; ++n7) {
            n6 = (Integer)this.categories[n][0].elementAt(n7);
            for (n5 = 0; n5 < this.numRuns; ++n5) {
                dArray[n5][n8] = this.dataTable[n][n5][n6];
            }
            ++n8;
        }
        n7 = this.categories[n][1].size();
        for (n6 = 0; n6 < this.numRuns; ++n6) {
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = (Integer)this.categories[n][1].elementAt(n5);
                double[] dArray2 = dArray[n6];
                int n10 = n8;
                dArray2[n10] = dArray2[n10] + this.dataTable[n][n6][n4];
            }
        }
        ++n8;
        n6 = this.categories[n][2].size();
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = (Integer)this.categories[n][2].elementAt(n5);
            for (n3 = 0; n3 < this.numRuns; ++n3) {
                dArray[n3][n8] = this.dataTable[n][n3][n4];
            }
            ++n8;
        }
        n5 = this.categories[n][3].size();
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.numEPs - (Integer)this.categories[n][3].elementAt(n4);
            for (int i = 0; i < this.numRuns; ++i) {
                dArray[i][n8] = this.extraTable[n][i][n3];
            }
            ++n8;
        }
    }

    private Color[] computeColorMap(int n, int n2, int n3) {
        Color[] colorArray = new Color[n];
        int n4 = this.categories[n2][0].size();
        int n5 = this.categories[n2][2].size();
        colorArray = ColorManager.createColorMap(n);
        colorArray[n4] = Color.gray;
        int n6 = this.categories[n2][3].size();
        int n7 = n4 + 1 + n5;
        for (int i = 0; i < n6; ++i) {
            switch (i) {
                case 0: {
                    colorArray[n7 + i] = Color.white;
                }
            }
        }
        return colorArray;
    }
}

