/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.ParseTokenizer;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;

public class PoseDopReader {
    private static final int NUM_SIM_STATES = 2;
    private static final int FORWARD_SIM_PROGRESS = 0;
    private static final int NO_SIM_PROGRESS = 1;
    private int[][] dopRealTime;
    private int[] dopVirtTime;
    private BufferedReader reader;
    private ParseTokenizer tokenizer;
    private long totalRealTime;
    private long totalVirtualTime;
    private OrderedIntList validPEs = Analysis.getValidProcessorList(3);

    public long getTotalRealTime() {
        if (this.totalRealTime > 0L) {
            return this.totalRealTime;
        }
        this.computeEndTimes();
        return this.totalRealTime;
    }

    public long getTotalVirtualTime() {
        if (this.totalVirtualTime > 0L) {
            return this.totalVirtualTime;
        }
        this.computeEndTimes();
        return this.totalVirtualTime;
    }

    private void computeEndTimes() {
        int n = 0;
        int n2 = this.validPEs.size();
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Computing End Times", "", 0, n2);
        this.validPEs.reset();
        long l = 0L;
        int n3 = this.validPEs.nextElement();
        while (n3 != -1) {
            progressMonitor.setProgress(n);
            progressMonitor.setNote("[PE: " + n3 + "] Getting End Time ...");
            try {
                this.reader = new BufferedReader(new FileReader(Analysis.getPoseDopName(n3)));
                this.initTokenizer(this.reader);
                try {
                    while (true) {
                        double d = this.tokenizer.nextNumber("Fake Start event");
                        d = this.tokenizer.nextNumber("end of event");
                        long l2 = (long)this.tokenizer.nextNumber("Fake S VT");
                        l2 = (long)this.tokenizer.nextNumber("end VT");
                        if ((long)(d * 1000000.0) > this.totalRealTime) {
                            this.totalRealTime = (long)(d * 1000000.0);
                        }
                        if (l2 > this.totalVirtualTime) {
                            this.totalVirtualTime = l2;
                        }
                        this.tokenizer.nextToken();
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
                System.exit(-1);
            }
            n3 = this.validPEs.nextElement();
            ++n;
        }
        progressMonitor.close();
    }

    public void read(long l, int n, int n2, long l2, int n3, int n4, OrderedIntList orderedIntList) {
        int n5 = 0;
        int n6 = orderedIntList.size();
        long l3 = (long)n * l;
        long l4 = (long)n2 * l;
        long l5 = (long)n3 * l2;
        long l6 = (long)n4 * l2;
        int[][] nArray = new int[2][10000000];
        int[] nArray2 = new int[10000000];
        long l7 = 0L;
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading dop files", "", 0, n6);
        int n7 = orderedIntList.nextElement();
        while (n7 != -1) {
            progressMonitor.setProgress(n5);
            progressMonitor.setNote("[PE: " + n7 + "] Reading ...");
            try {
                this.reader = new BufferedReader(new FileReader(Analysis.getPoseDopName(n7)));
                this.initTokenizer(this.reader);
                try {
                    while (true) {
                        long l8 = (long)(this.tokenizer.nextNumber("start of event") * 1000000.0);
                        long l9 = (long)(this.tokenizer.nextNumber("end of event") * 1000000.0);
                        long l10 = (long)this.tokenizer.nextNumber("start VT");
                        long l11 = (long)this.tokenizer.nextNumber("end VT");
                        int n8 = l11 - l10 > 0L ? 0 : 1;
                        if (l8 < l3 && l9 >= l3) {
                            int[] nArray3 = nArray[n8];
                            nArray3[0] = nArray3[0] + 1;
                            if (l9 <= l4) {
                                int[] nArray4 = nArray[n8];
                                int n9 = (int)(l9 - l3);
                                nArray4[n9] = nArray4[n9] - 1;
                            }
                        } else if (l8 >= l3) {
                            if (l8 <= l4) {
                                int[] nArray5 = nArray[n8];
                                int n10 = (int)(l8 - l3);
                                nArray5[n10] = nArray5[n10] + 1;
                            }
                            if (l9 == l8 && l9 < l4) {
                                int[] nArray6 = nArray[n8];
                                int n11 = (int)(l9 - l3 + 1L);
                                nArray6[n11] = nArray6[n11] - 1;
                            } else if (l9 <= l4) {
                                int[] nArray7 = nArray[n8];
                                int n12 = (int)(l9 - l3);
                                nArray7[n12] = nArray7[n12] - 1;
                            }
                        }
                        if (l10 == -1L || l11 == -1L) {
                            this.tokenizer.nextToken();
                            continue;
                        }
                        if (l10 < l5 && l11 >= l5) {
                            nArray2[0] = nArray2[0] + 1;
                            if (l11 < l6) {
                                int n13 = (int)(l11 - l5 + 1L);
                                nArray2[n13] = nArray2[n13] - 1;
                            }
                        } else if (l10 >= l5) {
                            if (l10 <= l6) {
                                int n14 = (int)(l10 - l5);
                                nArray2[n14] = nArray2[n14] + 1;
                            }
                            if (l11 < l6) {
                                int n15 = (int)(l11 - l5 + 1L);
                                nArray2[n15] = nArray2[n15] - 1;
                            }
                        }
                        this.tokenizer.nextToken();
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
                System.exit(-1);
            }
            n7 = orderedIntList.nextElement();
            ++n5;
        }
        progressMonitor.close();
        int n16 = n2 - n + 1;
        int n17 = n4 - n3 + 1;
        this.dopRealTime = new int[n16][2];
        this.dopVirtTime = new int[n17];
        long[] lArray = new long[2];
        for (int i = 0; i < n16; ++i) {
            for (int j = 0; j < 2; ++j) {
                double[] dArray = new double[2];
                int n18 = 0;
                while ((long)n18 < l) {
                    int n19 = j;
                    lArray[n19] = lArray[n19] + (long)nArray[j][(int)((long)i * l + (long)n18)];
                    int n20 = j;
                    dArray[n20] = dArray[n20] + (double)lArray[j];
                    ++n18;
                }
                this.dopRealTime[i][j] = (int)Math.floor(dArray[j] / (double)l);
            }
        }
        long l12 = 0L;
        for (int i = 0; i < n17; ++i) {
            double d = 0.0;
            int n21 = 0;
            while ((long)n21 < l2) {
                d += (double)(l12 += (long)nArray2[(int)((long)i * l2 + (long)n21)]);
                ++n21;
            }
            this.dopVirtTime[i] = (int)Math.floor(d / (double)l2);
        }
    }

    public int[][] getRealTimeDopData() {
        return this.dopRealTime;
    }

    public int[] getVirtualTimeDopData() {
        return this.dopVirtTime;
    }

    private void initTokenizer(BufferedReader bufferedReader) {
        this.tokenizer = new ParseTokenizer(bufferedReader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
    }
}

