/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import projections.gui.MainWindow;

public class ProjMain {
    public static double CUR_VERSION = 4.0;
    public static boolean IGNORE_IDLE = false;
    public static boolean BLUEGENE = false;
    public static int[] BLUEGENE_SIZE = new int[3];
    public static boolean PRINT_USAGE = false;
    public static final int NUM_TYPES = 5;
    public static final int LOG = 0;
    public static final int SUMMARY = 1;
    public static final int SUMDETAIL = 2;
    public static final int DOP = 3;
    public static final int SUMACC = 4;
    private static MainWindow mainWindow = null;

    public static void help() {
        System.out.println();
        System.out.println("Usage: projections [options] [sts-filename]");
        System.out.println();
        System.out.println("-h --help: show this page");
        System.out.println("-V --version: show Projections version");
        System.out.println("-u --use-version <ver>: use old version format");
        System.out.println("-no-idle: ignore idle time in analysis");
        System.out.println("-bgsize <x> <y> <z>: bluegene torus emulation");
        System.out.println("-print_usage: details written to stdout when viewing usage profiles.");
        System.out.println();
        System.exit(0);
    }

    public static void shutdown(int n) {
        if (mainWindow != null) {
            mainWindow.shutdown();
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help")) {
                ProjMain.help();
                continue;
            }
            if (stringArray[i].equals("-V") || stringArray[i].equals("--version")) {
                System.out.println("Projections version: " + CUR_VERSION);
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-u") || stringArray[i].equals("-use-version")) {
                double d;
                if (++i == stringArray.length) {
                    ProjMain.help();
                }
                if ((d = Double.parseDouble(stringArray[i])) > CUR_VERSION) {
                    System.out.println("Unable to use version " + d + "! Maximum supported version on " + "this binary is " + CUR_VERSION + ".");
                    System.exit(1);
                }
                CUR_VERSION = d;
                continue;
            }
            if (stringArray[i].equals("-no-idle")) {
                IGNORE_IDLE = true;
                continue;
            }
            if (stringArray[i].equals("-bgsize")) {
                ProjMain.BLUEGENE_SIZE[0] = Integer.parseInt(stringArray[++i]);
                ProjMain.BLUEGENE_SIZE[1] = Integer.parseInt(stringArray[++i]);
                ProjMain.BLUEGENE_SIZE[2] = Integer.parseInt(stringArray[++i]);
                BLUEGENE = true;
                continue;
            }
            if (stringArray[i].equals("-print_usage")) {
                PRINT_USAGE = true;
                continue;
            }
            string = stringArray[i];
        }
        mainWindow = new MainWindow();
        mainWindow.pack();
        mainWindow.setTitle("Projections");
        mainWindow.setVisible(true);
        if (string != null) {
            mainWindow.openFile(string);
        }
    }
}

