/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import projections.misc.FileUtils;
import projections.misc.LogLoadException;

public class ProjectionsConfigurationReader {
    private String baseName;
    private String logDirectory;
    private String configurationName;
    private boolean dirty;
    public static Long RC_GLOBAL_END_TIME = new Long(-1L);
    public static Long RC_POSE_REAL_TIME = new Long(-1L);
    public static Long RC_POSE_VIRT_TIME = new Long(-1L);
    public static Boolean RC_OUTLIER_FILTERED = false;

    public ProjectionsConfigurationReader(String string) {
        this.baseName = FileUtils.getBaseName(string);
        this.logDirectory = FileUtils.dirFromFile(string);
        this.configurationName = this.baseName + ".projrc";
        this.dirty = false;
        try {
            this.readfile();
        }
        catch (LogLoadException logLoadException) {
            System.err.println(logLoadException.toString());
            System.exit(-1);
        }
    }

    public void readfile() throws LogLoadException {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.configurationName)));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = "";
                try {
                    string2 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                String string3 = "";
                if (!string2.startsWith("RC_")) {
                    System.err.println("Warning: Key [" + string2 + "] does not " + "start with RC_ and is rejected.");
                    continue;
                }
                try {
                    Field field = this.getClass().getField(string2);
                    try {
                        string3 = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        string3 = "";
                    }
                    if (Class.forName("java.lang.String").equals(field.getType())) {
                        field.set(this, string3);
                        continue;
                    }
                    field.set(this, field.getType().getMethod("valueOf", Class.forName("java.lang.String")).invoke(null, string3));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    System.err.println("Warning: Key [" + string2 + "] is " + "not supported on this version " + "of Projections!");
                }
                catch (Exception exception) {
                    System.err.println("Internal Error: Encountered when attempting to assign value [" + string3 + "] to configuration key [" + string2 + "] Please report to " + "developers!");
                    System.err.println(exception.toString());
                    System.exit(-1);
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                File file = new File(this.configurationName);
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println("WARNING: Unable to write to rc file [" + this.configurationName + "]. Reason: ");
                System.err.println(iOException.toString());
            }
        }
        catch (IOException iOException) {
            throw new LogLoadException(this.configurationName, 1);
        }
    }

    public void writeFile() throws LogLoadException {
        if (this.dirty) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.configurationName));
                try {
                    Field[] fieldArray = this.getClass().getFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        String string = fieldArray[i].getName();
                        if (!string.startsWith("RC_")) continue;
                        printWriter.println(string + " " + fieldArray[i].get(this).toString());
                    }
                }
                catch (Exception exception) {
                    System.err.println("Internal Error: Cannot write configuration file. Please report to developers!");
                    System.err.println(exception.toString());
                    System.exit(-1);
                }
                printWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new LogLoadException(this.configurationName, 0);
            }
            catch (IOException iOException) {
                throw new LogLoadException(this.configurationName, 3);
            }
        }
        return;
    }

    public void setValue(String string, Object object) {
        if (!string.startsWith("RC_")) {
            System.err.println("Internal Error: Request to set configuration option [" + string + "] not supported! Please report to " + "developers!");
            System.exit(-1);
        } else {
            try {
                Field field = this.getClass().getField(string);
                field.set(this, object);
                this.dirty = true;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                System.err.println("Internal Error: Request to set configuration option [" + string + "] not supported! Please report to " + "developers!");
                System.err.println(noSuchFieldException.toString());
                System.exit(-1);
            }
            catch (SecurityException securityException) {
                System.err.println("Internal Error: Request to set configuration option [" + string + "] not supported! Please report to " + "developers!");
                System.err.println(securityException.toString());
                System.exit(-1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Internal Error: Request to set configuration option [" + string + "] not supported! Please report to " + "developers!");
                System.err.println(illegalArgumentException.toString());
                System.exit(-1);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Internal Error: Request to set configuration option [" + string + "] not supported! Please report to " + "developers!");
                System.err.println(illegalAccessException.toString());
                System.exit(-1);
            }
        }
    }

    public void close() {
        try {
            this.writeFile();
        }
        catch (LogLoadException logLoadException) {
            System.err.println(logLoadException.toString());
            System.exit(-1);
        }
    }
}

