/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import projections.gui.U;

public class RangeHistory {
    public static final int MAX_ENTRIES = 10;
    private String filename;
    private int numEntries;
    private Vector rangeSet;
    Vector historyStringVector;

    public RangeHistory(String string) {
        this.filename = string + "ranges.hst";
        if (!new File(this.filename).exists()) {
            this.rangeSet = new Vector();
            this.historyStringVector = new Vector();
        } else {
            try {
                this.loadRanges();
                this.historyStringVector = new Vector();
                for (int i = 0; i < this.rangeSet.size() / 2; ++i) {
                    String string2 = U.t((Long)this.rangeSet.elementAt(i * 2)) + " to " + U.t((Long)this.rangeSet.elementAt(i * 2 + 1));
                    this.historyStringVector.add(string2);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error: " + iOException.toString());
            }
        }
    }

    private void loadRanges() throws IOException {
        String string;
        this.rangeSet = new Vector();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filename));
        this.numEntries = 0;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("ENTRY")) continue;
            if (this.numEntries >= 10) {
                throw new IOException("Range history overflow!");
            }
            this.rangeSet.add(Long.valueOf(stringTokenizer.nextToken()));
            this.rangeSet.add(Long.valueOf(stringTokenizer.nextToken()));
            ++this.numEntries;
        }
        bufferedReader.close();
    }

    public void save() throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.filename), true);
        for (int i = 0; i < this.numEntries; ++i) {
            printWriter.print("ENTRY ");
            printWriter.print((Long)this.rangeSet.elementAt(i * 2));
            printWriter.print(" ");
            printWriter.println((Long)this.rangeSet.elementAt(i * 2 + 1));
        }
    }

    public void add(long l, long l2) {
        if (this.numEntries == 10) {
            this.rangeSet.remove(10);
            this.rangeSet.remove(9);
            --this.numEntries;
        }
        this.rangeSet.add(0, new Long(l2));
        this.rangeSet.add(0, new Long(l));
        ++this.numEntries;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.numEntries) {
            System.err.println("Internal Error: Attempt to remove invalid index " + n + ". Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        this.rangeSet.remove(n * 2);
        this.rangeSet.remove(n * 2);
        --this.numEntries;
    }

    public Vector getHistoryStrings() {
        return this.historyStringVector;
    }

    public long getStartValue(int n) {
        if (n < 0 || n >= this.numEntries) {
            System.err.println("Internal Error: Requested history index " + n + " is invalid. Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        return (Long)this.rangeSet.elementAt(n * 2);
    }

    public long getEndValue(int n) {
        if (n < 0 || n >= this.numEntries) {
            System.err.println("Internal Error: Requested history index " + n + " is invalid. Max number of " + "histories is " + this.numEntries + ". Please report to developers!");
            System.exit(-1);
        }
        return (Long)this.rangeSet.elementAt(n * 2 + 1);
    }
}

