/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.swing.ProgressMonitor;
import projections.analysis.AccumulatedSummaryReader;
import projections.analysis.IntervalUtils;
import projections.analysis.ProjDefs;
import projections.analysis.StsReader;
import projections.gui.Analysis;
import projections.misc.SummaryFormatException;

public class SumAnalyzer
extends ProjDefs {
    public static final int NUM_MODES = 2;
    public static final int ACC_MODE = 0;
    public static final int NORMAL_MODE = 1;
    private int[][][][] dataArray;
    private StreamTokenizer tokenizer;
    private long[][] ChareTime;
    private int[][] NumEntryMsgs;
    private int[][] MaxEntryTime;
    private int PhaseCount;
    private long IntervalSize;
    private int IntervalCount;
    private long TotalTime;
    private long[][][] PhaseChareTime;
    private int[][][] PhaseNumEntryMsgs;
    private int[][] ProcessorUtilization;
    private int mode = 1;
    private AccumulatedSummaryReader accumulatedReader;

    public SumAnalyzer(StsReader stsReader, int n) {
        this.mode = n;
        this.accumulatedReader = new AccumulatedSummaryReader(Analysis.getSumAccumulatedName(), "5.0");
        this.TotalTime = (long)this.accumulatedReader.totalTime;
        this.IntervalCount = (int)this.accumulatedReader.numIntervals;
        this.IntervalSize = (long)this.accumulatedReader.intervalSize;
    }

    public SumAnalyzer() throws IOException, SummaryFormatException {
        int n;
        int n2;
        BufferedReader bufferedReader;
        FileReader fileReader;
        int n3;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        this.IntervalCount = 0;
        this.TotalTime = 0L;
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Determining max intervals", "", 0, n4);
        for (n3 = 0; n3 < n4; ++n3) {
            if (!progressMonitor.isCanceled()) {
                progressMonitor.setNote(n3 + " of " + n4);
                progressMonitor.setProgress(n3);
            } else {
                System.err.println("Fatal error - Projections cannot function without proper number of summary intervals!");
                System.exit(-1);
            }
            fileReader = new FileReader(Analysis.getSumName(n3));
            bufferedReader = new BufferedReader(fileReader);
            this.tokenizer = new StreamTokenizer(bufferedReader);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            n6 = (int)this.nextNumber("Version Number");
            n2 = (int)this.nextNumber("processor number");
            n4 = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            n = (int)this.nextNumber("count");
            this.checkNextString("ep");
            int n7 = (int)this.nextNumber("ep");
            this.checkNextString("interval");
            double d = this.nextScientific("intervalsize");
            long l = (long)Math.floor(d * 1000000.0);
            double d2 = 1.0;
            if (l != this.IntervalSize) {
                if (this.IntervalSize == 0L) {
                    this.IntervalSize = l;
                } else {
                    d2 = (double)l / ((double)this.IntervalSize * 1.0);
                    if (l < this.IntervalSize) {
                        this.IntervalSize = l;
                    }
                }
            }
            if (d2 < 1.0) {
                this.IntervalCount = (int)((double)this.IntervalCount / d2);
            }
            if ((double)this.IntervalCount < (double)n * d2) {
                this.IntervalCount = (int)((double)n * d2);
            }
            this.tokenizer = null;
            fileReader.close();
        }
        progressMonitor.close();
        progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading summary data", "", 0, n4);
        for (n3 = 0; n3 < n4; ++n3) {
            int n8;
            int n9;
            int n10;
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            progressMonitor.setNote(n3 + " of " + n4);
            progressMonitor.setProgress(n3);
            fileReader = new FileReader(Analysis.getSumName(n3));
            bufferedReader = new BufferedReader(fileReader);
            this.tokenizer = new StreamTokenizer(bufferedReader);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            n6 = (int)this.nextNumber("Version Number");
            n2 = (int)this.nextNumber("processor number");
            n4 = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            n = (int)this.nextNumber("count");
            this.checkNextString("ep");
            n5 = (int)this.nextNumber("number of entry methods");
            this.checkNextString("interval");
            double d = this.nextScientific("processor usage sample interval");
            long l = (long)Math.floor(d * 1000000.0);
            if (this.TotalTime < (long)n * l) {
                this.TotalTime = (long)n * l;
            }
            int n11 = (int)(l / this.IntervalSize);
            if (n6 > 2) {
                this.checkNextString("phases");
                this.PhaseCount = (int)this.nextNumber("phases");
            } else {
                this.PhaseCount = 1;
            }
            if (10 != this.tokenizer.nextToken()) {
                throw new SummaryFormatException("extra garbage at end of line 1");
            }
            if (n3 == 0) {
                this.ProcessorUtilization = new int[n4][];
                this.ChareTime = new long[n4][n5];
                this.NumEntryMsgs = new int[n4][n5];
                this.MaxEntryTime = new int[n4][n5];
            }
            this.ProcessorUtilization[n3] = new int[this.IntervalCount];
            int n12 = 0;
            boolean bl = false;
            int n13 = 0;
            int n14 = 0;
            while ((n10 = this.tokenizer.nextToken()) != 10) {
                if (n10 == -2) {
                    n13 = (int)this.tokenizer.nval;
                    for (n9 = 0; n9 < n11; ++n9) {
                        this.ProcessorUtilization[n3][n12++] = n13;
                    }
                    n10 = this.tokenizer.nextToken();
                    if (n10 == 43) {
                        n10 = this.tokenizer.nextToken();
                        if (n10 != -2) {
                            System.out.println("Unrecorgnized syntax at end of line 2");
                        }
                        if ((n14 = (int)this.tokenizer.nval) > n) {
                            System.err.println("[" + n3 + "] Token read = [" + n13 + "+" + n14 + "] is impossible as the " + "count is larger than the " + "total count of " + n);
                            System.exit(-1);
                        }
                        for (n9 = 1; n9 < n14; ++n9) {
                            for (n8 = 0; n8 < n11; ++n8) {
                                this.ProcessorUtilization[n3][n12++] = n13;
                            }
                        }
                    } else {
                        this.tokenizer.pushBack();
                    }
                }
                if (n12 <= n * n11) continue;
                System.err.println("[" + n3 + "] Corrupted data: " + "Number of datapoints read exceeds " + "file recorded value of " + n + "adjusted by factor " + n11);
                System.err.print("The violating token is [" + n13);
                if (n14 > 1) {
                    System.err.println("+" + n14 + "]");
                } else {
                    System.err.println("]");
                }
                System.exit(-1);
            }
            if (n * n11 != n12) {
                System.err.println("numIntervals not agree" + n * n11 + "v.s. " + n12 + "!");
            }
            int n15 = 0;
            n10 = this.tokenizer.nextToken();
            if (-3 != n10) {
                this.tokenizer.pushBack();
            }
            while (-2 == (n10 = this.tokenizer.nextToken()) && n5 > n15) {
                this.ChareTime[n3][n15++] = (int)this.tokenizer.nval;
            }
            if (10 != n10) {
                throw new SummaryFormatException("extra garbage at end of line 3");
            }
            n10 = this.tokenizer.nextToken();
            if (-3 != n10) {
                this.tokenizer.pushBack();
            }
            for (n15 = 0; -2 == (n10 = this.tokenizer.nextToken()) && n5 > n15; ++n15) {
                this.NumEntryMsgs[n3][n15] = (int)this.tokenizer.nval;
            }
            if (10 != n10) {
                throw new SummaryFormatException("extra garbage at end of line 4");
            }
            if ((double)n6 > 3.0) {
                n10 = this.tokenizer.nextToken();
                if (-3 != n10) {
                    this.tokenizer.pushBack();
                }
                for (n15 = 0; -2 == (n10 = this.tokenizer.nextToken()) && n5 > n15; ++n15) {
                    this.MaxEntryTime[n3][n15] = (int)this.tokenizer.nval;
                }
                if (10 != n10) {
                    throw new SummaryFormatException("extra garbage at end of line 5");
                }
            }
            if (-3 != (n10 = this.tokenizer.nextToken())) {
                this.tokenizer.pushBack();
            }
            n9 = (int)this.nextNumber("Number of Marked Events");
            for (n8 = 0; n8 < n9; ++n8) {
                this.nextNumber("Number of Marked Events");
                this.nextNumber("Number of Marked Events");
            }
            if (this.PhaseCount > 1) {
                if (n3 == 0) {
                    this.PhaseChareTime = new long[this.PhaseCount][n4][n5];
                    this.PhaseNumEntryMsgs = new int[this.PhaseCount][n4][n5];
                }
                for (n8 = 0; n8 < this.PhaseCount; ++n8) {
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    for (n15 = 0; -2 == (n10 = this.tokenizer.nextToken()) && n5 > n15; ++n15) {
                        this.PhaseNumEntryMsgs[n8][n3][n15] = (int)this.tokenizer.nval;
                    }
                    if (10 != n10) {
                        throw new SummaryFormatException("extra garbage at end of line 3");
                    }
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    for (n15 = 0; -2 == (n10 = this.tokenizer.nextToken()) && n5 > n15; ++n15) {
                        this.PhaseChareTime[n8][n3][n15] = (int)this.tokenizer.nval;
                    }
                    if (10 == n10) continue;
                    throw new SummaryFormatException("extra garbage at end of line 4");
                }
            }
            this.tokenizer = null;
            fileReader.close();
        }
        progressMonitor.close();
        Analysis.setTotalTime(this.TotalTime);
    }

    private void checkNextString(String string) throws IOException, SummaryFormatException {
        String string2 = this.nextString(string);
        if (!string.equals(string2)) {
            throw new SummaryFormatException("Expected " + string + " got " + string2);
        }
    }

    public long getIntervalSize() {
        return this.IntervalSize;
    }

    public long[][] GetChareTime() {
        return this.ChareTime;
    }

    public int[][] GetNumEntryMsgs() {
        return this.NumEntryMsgs;
    }

    public long[][] GetPhaseChareTime(int n) {
        return this.PhaseChareTime[n];
    }

    public int GetPhaseCount() {
        return this.PhaseCount;
    }

    public int[][] GetPhaseNumEntryMsgs(int n) {
        return this.PhaseNumEntryMsgs[n];
    }

    public int[][] GetSystemUsageData(int n, int n2, long l) throws IOException, SummaryFormatException {
        int n3;
        int n4;
        int n5 = this.ProcessorUtilization.length;
        int n6 = n2 - n + 1;
        int[][] nArray = new int[n5][n6];
        if (l == this.IntervalSize) {
            for (int i = 0; i < n5; ++i) {
                for (int j = n; j < n2 && j < this.ProcessorUtilization[i].length; ++j) {
                    nArray[i][j - n] = this.ProcessorUtilization[i][j];
                }
            }
            return nArray;
        }
        int n7 = (int)((long)n * l / this.IntervalSize);
        double[][] dArray = new double[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = n7; n3 < this.ProcessorUtilization[n4].length && n3 < n7 + n6; ++n3) {
                if (this.ProcessorUtilization[n4][n3] <= 0) continue;
                IntervalUtils.fillIntervals(dArray[n4], l, n, (long)n3 * this.IntervalSize, (long)(n3 + 1) * this.IntervalSize, IntervalUtils.utilToTime(this.ProcessorUtilization[n4][n3], (double)this.IntervalSize), false);
            }
        }
        for (n4 = 0; n4 < dArray.length; ++n4) {
            for (n3 = 0; n3 < dArray[n4].length; ++n3) {
                dArray[n4][n3] = IntervalUtils.timeToUtil(dArray[n4][n3], (double)l);
                nArray[n4][n3] = (int)dArray[n4][n3];
            }
        }
        return nArray;
    }

    public double[] getSummaryAverageData() {
        if (this.mode == 1) {
            int n;
            int n2 = this.ProcessorUtilization.length;
            double[] dArray = new double[this.IntervalCount];
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < this.IntervalCount; ++i) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] + (double)this.ProcessorUtilization[n][i];
                }
            }
            n = 0;
            while (n < this.IntervalCount) {
                int n4 = n++;
                dArray[n4] = dArray[n4] / ((double)n2 * 1.0);
            }
            return dArray;
        }
        if (this.mode == 0) {
            try {
                this.accumulatedReader.loadIntervalData(0L, this.IntervalCount - 1);
            }
            catch (IOException iOException) {
                System.err.println("Exception caught!");
                System.exit(-1);
            }
            double[] dArray = this.accumulatedReader.getUtilData();
            return dArray;
        }
        return null;
    }

    public long GetTotalTime() {
        return this.TotalTime;
    }

    private double nextNumber(String string) throws IOException, SummaryFormatException {
        if (-2 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read " + string);
        }
        return this.tokenizer.nval;
    }

    private double nextScientific(String string) throws IOException, SummaryFormatException {
        int n;
        double d = this.nextNumber(string + " mantissa");
        String string2 = this.nextString(string + " exponent");
        char c = string2.charAt(0);
        if (c != 'e' && c != 'd' && c != 'E' && c != 'D') {
            throw new SummaryFormatException("Couldn't find exponent in " + string2);
        }
        if ((string2 = string2.substring(1)).equals("")) {
            this.tokenizer.nextToken();
            n = (int)this.nextNumber("exponent");
        } else {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SummaryFormatException("Couldn't parse exponent " + string2);
            }
        }
        return d * Math.pow(10.0, n);
    }

    private String nextString(String string) throws IOException, SummaryFormatException {
        if (-3 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read string " + string);
        }
        return this.tokenizer.sval;
    }
}

