/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.IntervalCapableReader;
import projections.analysis.ParseTokenizer;
import projections.analysis.ProjectionsFormatException;
import projections.analysis.ProjectionsReader;
import projections.analysis.RLEBlock;

public class SumDetailReader
extends ProjectionsReader
implements IntervalCapableReader {
    public static final int NUM_TAGS = 2;
    public static final int TOTAL_TIME = 0;
    public static final int NUM_MSGS = 1;
    public double versionNum;
    public int myPE;
    public int numPE;
    public int numIntervals;
    public int numEPs;
    public double intervalSize;
    private Vector[][] rawData;
    private double version;
    private BufferedReader reader;
    private ParseTokenizer tokenizer;
    private int tokenType;

    public SumDetailReader(String string, double d) throws IOException {
        super(string, String.valueOf(d));
    }

    protected boolean checkAvailable() {
        File file = new File(this.sourceString);
        return file.canRead();
    }

    protected void readStaticData() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.sourceString));
        this.tokenizer = new ParseTokenizer(this.reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.checkNextString("ver");
        this.versionNum = this.tokenizer.nextNumber("Version Number");
        this.tokenizer.checkNextString("cpu");
        this.myPE = (int)this.tokenizer.nextNumber("processor number");
        this.numPE = (int)this.tokenizer.nextNumber("number of processors");
        this.tokenizer.checkNextString("numIntervals");
        this.numIntervals = (int)this.tokenizer.nextNumber("numIntervals");
        this.tokenizer.checkNextString("numEPs");
        this.numEPs = (int)this.tokenizer.nextNumber("number of entry methods");
        this.tokenizer.checkNextString("intervalSize");
        this.intervalSize = this.tokenizer.nextScientific("processor usage sample interval");
        if (10 != this.tokenizer.nextToken()) {
            throw new ProjectionsFormatException(this.expectedVersion, "extra garbage at end of header line");
        }
        this.reader.close();
        this.reader = null;
    }

    protected void read() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.sourceString));
        this.tokenizer = new ParseTokenizer(this.reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.skipLine();
        this.rawData = new Vector[2][this.numEPs];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.numEPs; ++j) {
                this.rawData[i][j] = new Vector();
            }
        }
        while (-1 != this.tokenizer.nextToken()) {
            if (this.tokenizer.ttype != -3) {
                throw new IOException("Bad Sumdetail format-label expected");
            }
            String string = this.tokenizer.sval;
            if (string.equals("ExeTimePerEPperInterval")) {
                this.buildTable(0);
                continue;
            }
            if (!string.equals("EPCallTimePerInterval")) continue;
            this.buildTable(1);
        }
        this.reader.close();
        this.reader = null;
    }

    public void reset() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildTable(int n) throws IOException {
        int n2 = 0;
        int n3 = this.numIntervals;
        double d = 0.0;
        int n4 = 1;
        block3: while (10 != this.tokenizer.nextToken()) {
            switch (this.tokenizer.ttype) {
                case -2: {
                    Object object;
                    d = this.tokenizer.nval;
                    n4 = 1;
                    if (-3 == this.tokenizer.nextToken()) {
                        object = this.tokenizer.sval;
                        if (!((String)object).startsWith("+")) throw new IOException("Bad SumDetail Format - invalid data in run-length encoded block.");
                        n4 = Integer.parseInt(((String)object).substring(1));
                    } else {
                        this.tokenizer.pushBack();
                    }
                    while (n4 > n3) {
                        object = new RLEBlock();
                        ((RLEBlock)object).value = d;
                        ((RLEBlock)object).count = n3;
                        this.rawData[n][n2++].add(object);
                        n4 -= n3;
                        n3 = this.numIntervals;
                    }
                    if (n4 < n3) {
                        object = new RLEBlock();
                        ((RLEBlock)object).value = d;
                        ((RLEBlock)object).count = n4;
                        this.rawData[n][n2].add(object);
                        n3 -= n4;
                        continue block3;
                    }
                    if (n4 != n3) continue block3;
                    object = new RLEBlock();
                    ((RLEBlock)object).value = d;
                    ((RLEBlock)object).count = n4;
                    this.rawData[n][n2++].add(object);
                    n3 = this.numIntervals;
                    continue block3;
                }
            }
            throw new IOException("Bad SumDetail Format - number expected.");
        }
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    public void loadIntervalData(double d, long l, long l2) throws IOException {
    }

    public void loadIntervalData(long l, long l2) throws IOException {
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public Vector[] getData(int n) {
        return this.rawData[n];
    }
}

