/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.IOException;
import projections.analysis.AmpiFunctionData;
import projections.analysis.CallStackManager;
import projections.analysis.GenericLogReader;
import projections.analysis.LogEntry;
import projections.analysis.ProjDefs;
import projections.gui.Analysis;
import projections.misc.LogEntryData;

public class UsageCalc
extends ProjDefs {
    private long beginTime;
    private long endTime;
    private long startTime;
    private int pnum;
    private int dataLen;
    private long packtime;
    private long packstarttime;
    private long unpacktime;
    private long unpackstarttime;
    private int numUserEntries;
    private double version;
    private int countflag = 0;
    private int curEntry = -1;
    private long prevTime = 0L;
    private boolean deltaEncoded = false;
    private int tokenExpected = 2;

    private void intervalCalc(float[][] fArray, int n, int n2, long l) {
        if (n != 1) {
            if (l <= this.beginTime + 1L) {
                l = this.beginTime;
                this.countflag = 0;
            } else if (this.countflag != 2) {
                this.countflag = 1;
            }
            if (l > this.endTime) {
                l = this.endTime;
                this.countflag = 2;
            } else if (this.countflag != 0) {
                this.countflag = 1;
            }
        } else if (this.countflag != 1) {
            l = 0L;
        }
        switch (n) {
            case 2: {
                this.packtime = 0L;
                this.unpacktime = 0L;
                this.curEntry = n2;
                this.startTime = l;
                break;
            }
            case 3: {
                if (this.curEntry == -1) break;
                float[] fArray2 = fArray[0];
                int n3 = this.curEntry;
                fArray2[n3] = fArray2[n3] + (float)(l - this.startTime - this.packtime - this.unpacktime);
                break;
            }
            case 1: {
                if (this.curEntry == -1) break;
                float[] fArray3 = fArray[1];
                int n4 = this.curEntry;
                fArray3[n4] = fArray3[n4] + (float)l;
                break;
            }
            case 21: {
                break;
            }
            case 14: {
                this.startTime = l;
                break;
            }
            case 15: {
                float[] fArray4 = fArray[0];
                int n5 = this.numUserEntries + 2;
                fArray4[n5] = fArray4[n5] + (float)(l - this.startTime);
                break;
            }
            case 16: {
                this.packstarttime = l;
                break;
            }
            case 17: {
                this.packtime += l - this.packstarttime;
                float[] fArray5 = fArray[0];
                int n6 = this.numUserEntries;
                fArray5[n6] = fArray5[n6] + (float)(l - this.packstarttime);
                break;
            }
            case 18: {
                this.unpackstarttime = l;
                break;
            }
            case 19: {
                this.unpacktime += l - this.unpackstarttime;
                float[] fArray6 = fArray[0];
                int n7 = this.numUserEntries + 1;
                fArray6[n7] = fArray6[n7] + (float)(l - this.unpackstarttime);
                break;
            }
        }
    }

    public float[] ampiUsage(int n, long l, long l2, double d) {
        int n2 = Analysis.getNumFunctionEvents();
        long[] lArray = new long[n2 + 1];
        float[] fArray = new float[n2 + 1];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = 0L;
        }
        GenericLogReader genericLogReader = new GenericLogReader(n, d);
        LogEntryData logEntryData = new LogEntryData();
        int n3 = -1;
        AmpiFunctionData ampiFunctionData = null;
        long l3 = 0L;
        boolean bl = false;
        CallStackManager callStackManager = new CallStackManager();
        try {
            do {
                genericLogReader.nextEvent(logEntryData);
                l3 = logEntryData.time;
            } while (logEntryData.type != 2 || logEntryData.entry == -1 || logEntryData.time < l);
            while (l3 < l2) {
                switch (logEntryData.type) {
                    case 2: {
                        if (bl) break;
                        bl = true;
                        ampiFunctionData = (AmpiFunctionData)callStackManager.read(logEntryData.id[0], logEntryData.id[1], logEntryData.id[2]);
                        if (ampiFunctionData == null) break;
                        ampiFunctionData.setLastBeginTime(l3);
                        break;
                    }
                    case 3: {
                        if (!bl) break;
                        bl = false;
                        ampiFunctionData = (AmpiFunctionData)callStackManager.read(logEntryData.id[0], logEntryData.id[1], logEntryData.id[2]);
                        if (ampiFunctionData == null) break;
                        ampiFunctionData.incrAccExecTimeNow(l3);
                        break;
                    }
                    case 22: {
                        ampiFunctionData = (AmpiFunctionData)callStackManager.read(logEntryData.id[0], logEntryData.id[1], logEntryData.id[2]);
                        if (ampiFunctionData != null) {
                            ampiFunctionData.incrAccExecTimeNow(l3);
                        }
                        AmpiFunctionData ampiFunctionData2 = LogEntry.adapt((LogEntryData)logEntryData).ampiData;
                        ampiFunctionData2.setLastBeginTime(l3);
                        callStackManager.push(ampiFunctionData2, logEntryData.id[0], logEntryData.id[1], logEntryData.id[2]);
                        break;
                    }
                    case 23: {
                        AmpiFunctionData ampiFunctionData3 = (AmpiFunctionData)callStackManager.pop(logEntryData.id[0], logEntryData.id[1], logEntryData.id[2]);
                        ampiFunctionData3.incrAccExecTimeNow(l3);
                        int n4 = logEntryData.entry;
                        lArray[n4] = lArray[n4] + ampiFunctionData3.getAccExecTime();
                        ampiFunctionData = (AmpiFunctionData)callStackManager.read(logEntryData.id[0], logEntryData.id[1], logEntryData.id[2]);
                        if (ampiFunctionData == null) break;
                        ampiFunctionData.setLastBeginTime(l3);
                        break;
                    }
                }
                genericLogReader.nextEvent(logEntryData);
                l3 = logEntryData.time;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            System.out.println("Exception while reading log file " + this.pnum);
        }
        float f = 0.0f;
        for (int i = 1; i < n2; ++i) {
            fArray[i] = (float)(100.0 * (double)lArray[i]) / (float)(l2 - l);
            f += fArray[i];
        }
        if (f > 100.0f) {
            System.out.println("ERROR: accTime > 100%");
            return null;
        }
        fArray[n2] = 100.0f - f;
        return fArray;
    }

    public float[][] usage(int n, long l, long l2, double d) {
        this.version = d;
        this.beginTime = l;
        this.endTime = l2;
        this.pnum = n;
        this.numUserEntries = Analysis.getNumUserEntries();
        this.dataLen = this.numUserEntries + 4;
        float[][] fArray = new float[2][this.dataLen];
        for (int i = 0; i < this.dataLen; ++i) {
            fArray[0][i] = 0.0f;
            fArray[1][i] = 0.0f;
        }
        GenericLogReader genericLogReader = new GenericLogReader(n, this.version);
        LogEntryData logEntryData = new LogEntryData();
        this.curEntry = -1;
        this.startTime = 0L;
        long l3 = 0L;
        boolean bl = false;
        try {
            block18: while (l3 < this.endTime) {
                genericLogReader.nextEvent(logEntryData);
                l3 = logEntryData.time;
                switch (logEntryData.type) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        this.intervalCalc(fArray, logEntryData.type, 0, l3);
                        continue block18;
                    }
                    case 2: {
                        if (bl) continue block18;
                        this.intervalCalc(fArray, logEntryData.type, logEntryData.entry, l3);
                        bl = true;
                        continue block18;
                    }
                    case 3: {
                        if (!bl) continue block18;
                        this.intervalCalc(fArray, logEntryData.type, logEntryData.entry, l3);
                        bl = false;
                        continue block18;
                    }
                    case 11: {
                        continue block18;
                    }
                    case 12: {
                        continue block18;
                    }
                    case 10: {
                        continue block18;
                    }
                    case 1: {
                        this.intervalCalc(fArray, logEntryData.type, 0, logEntryData.sendTime);
                        continue block18;
                    }
                    case 21: {
                        continue block18;
                    }
                    case 13: 
                    case 100: {
                        continue block18;
                    }
                    case 4: 
                    case 5: {
                        continue block18;
                    }
                    case 8: 
                    case 9: {
                        continue block18;
                    }
                    case 7: {
                        continue block18;
                    }
                }
                if (!this.deltaEncoded) continue;
                System.out.println("Warning: Unknown Event! This can mess up delta encoding!");
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            System.out.println("Exception while reading log file " + this.pnum);
        }
        float f = 0.0f;
        for (int i = 0; i < this.dataLen; ++i) {
            fArray[0][i] = fArray[0][i] - fArray[1][i];
            fArray[0][i] = (float)(100.0 * (double)fArray[0][i]) / (float)(this.endTime - this.beginTime);
            fArray[1][i] = (float)(100.0 * (double)fArray[1][i]) / (float)(this.endTime - this.beginTime);
        }
        return fArray;
    }
}

