/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.analysis.UsageCalc;
import projections.gui.AmpiProfileData;
import projections.gui.Analysis;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.JFloatTextField;
import projections.gui.MainWindow;
import projections.gui.PieChartWindow;
import projections.gui.ProfileGraph;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class AmpiProfileWindow
extends ProjectionsWindow
implements ActionListener,
ColorSelectable,
ChangeListener {
    private static final int NUM_SYS_EPS = 3;
    private AmpiProfileWindow thisWindow = this;
    private AmpiProfileData data;
    private boolean colorsSet = false;
    private Color[] colors = null;
    private float[][] dataSource = null;
    private int[][] colorMap = null;
    private String[][] nameMap = null;
    private String[] procNames = null;
    private float[][] accTime = null;
    private float[] sDataSrc = null;
    private int[] sColorMap = null;
    private String[] sNameMap = null;
    private JTabbedPane tabPane;
    private ProfileGraph displayCanvas;
    private JScrollPane displayPanel;
    private int displayPanelTabIndex;
    private ProfileGraph ampiDisplayCanvas;
    private JScrollPane ampiDisplayPanel;
    private int ampiDisplayPanelTabIndex;
    private JButton btnIncX;
    private JButton btnDecX;
    private JButton btnResX;
    private JButton btnIncY;
    private JButton btnDecY;
    private JButton btnResY;
    private JFloatTextField txtScaleX;
    private JFloatTextField txtScaleY;
    private float thresh = 0.01f;
    private PieChartWindow pieChartWindow;
    private float[] avgData;
    private EntrySelectionDialog entryDialog;
    private boolean ampiTraceOn = false;

    public AmpiProfileWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        if (Analysis.getNumFunctionEvents() > 0) {
            this.ampiTraceOn = true;
        }
        this.setBackground(Color.lightGray);
        this.setTitle("Projections AMPI Usage Profile - " + Analysis.getFilename() + ".sts");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
    }

    void windowInit() {
        this.data = new AmpiProfileData(this);
        this.data.plist = Analysis.getValidProcessorList();
        this.data.pstring = Analysis.getValidProcessorString();
        this.data.begintime = 0L;
        this.data.endtime = Analysis.getTotalTime();
    }

    private void CreateMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Select Processors", "Print Profile", null, "Close"}, null, this));
        if (this.ampiTraceOn) {
            jMenuBar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors", "Usage Table"}, null, this));
        }
        jMenuBar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(jMenuBar);
    }

    private void CreateLayout() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.displayCanvas = new ProfileGraph();
        this.displayPanel = new JScrollPane(this.displayCanvas);
        if (this.ampiTraceOn) {
            this.ampiDisplayCanvas = new ProfileGraph();
            this.ampiDisplayPanel = new JScrollPane(this.ampiDisplayCanvas);
            this.tabPane = new JTabbedPane();
            this.tabPane.add("Per Processor", this.displayPanel);
            this.tabPane.add("Per Function", this.ampiDisplayPanel);
            this.displayPanelTabIndex = this.tabPane.indexOfComponent(this.displayPanel);
            this.ampiDisplayPanelTabIndex = this.tabPane.indexOfComponent(this.ampiDisplayPanel);
            this.tabPane.addChangeListener(this);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "x-scale"));
        jPanel2.setLayout(gridBagLayout);
        this.btnDecX = new JButton("<<");
        JLabel jLabel = new JLabel("X-Axis Scale: ", 0);
        this.txtScaleX = new JFloatTextField(1.0f, 5);
        this.btnIncX = new JButton(">>");
        this.btnResX = new JButton("Reset");
        this.btnDecX.addActionListener(this);
        this.txtScaleX.addActionListener(this);
        this.btnIncX.addActionListener(this);
        this.btnResX.addActionListener(this);
        Util.gblAdd(jPanel2, this.btnDecX, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, jLabel, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, this.txtScaleX, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel2, this.btnIncX, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel2, this.btnResX, gridBagConstraints, 4, 0, 1, 1, 0, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "y-scale"));
        jPanel3.setLayout(gridBagLayout);
        this.btnDecY = new JButton("<<");
        JLabel jLabel2 = new JLabel("Y-Axis Scale: ", 0);
        this.txtScaleY = new JFloatTextField(1.0f, 5);
        this.btnIncY = new JButton(">>");
        this.btnResY = new JButton("Reset");
        this.btnDecY.addActionListener(this);
        this.txtScaleY.addActionListener(this);
        this.btnIncY.addActionListener(this);
        this.btnResY.addActionListener(this);
        Util.gblAdd(jPanel3, this.btnDecY, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, jLabel2, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, this.txtScaleY, gridBagConstraints, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel3, this.btnIncY, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(jPanel3, this.btnResY, gridBagConstraints, 4, 0, 1, 1, 0, 0);
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        if (this.ampiTraceOn) {
            Util.gblAdd(container, this.tabPane, gridBagConstraints, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        } else {
            Util.gblAdd(container, this.displayPanel, gridBagConstraints, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        }
        Util.gblAdd(container, jPanel2, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
        Util.gblAdd(container, jPanel3, gridBagConstraints, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = !Analysis.hasLogData() && !Analysis.hasSumDetailData() ? new RangeDialog(this, "AMPI Usage Profile", true) : new RangeDialog(this, "AMPI Usage Profile");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            Thread thread = new Thread(){

                public void run() {
                    AmpiProfileWindow.this.readAmpiUsageData();
                    if (AmpiProfileWindow.this.ampiTraceOn) {
                        AmpiProfileWindow.this.setDisplayProfileData();
                        AmpiProfileWindow.this.setAmpiDisplayProfileData();
                    }
                    AmpiProfileWindow.this.setLocationRelativeTo(AmpiProfileWindow.this.parentWindow);
                    AmpiProfileWindow.this.setVisible(true);
                }
            };
            thread.start();
        }
    }

    public void getDialogData() {
        this.data.plist = this.dialog.getValidProcessors();
        this.data.pstring = this.dialog.getValidProcessorString();
        this.data.begintime = this.dialog.getStartTime();
        this.data.endtime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.data.plist);
        this.dialog.setStartTime(this.data.begintime);
        this.dialog.setEndTime(this.data.endtime);
        super.setDialogData();
    }

    public void showWindow() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        float f = this.txtScaleX.getValue();
        float f2 = this.txtScaleY.getValue();
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.btnDecX) {
                f3 = (float)((int)(f * 4.0f) - 1) / 4.0f;
                if ((double)f3 < 1.0) {
                    f3 = 1.0f;
                }
            } else if (jButton == this.btnIncX) {
                f3 = (float)((int)(f * 4.0f) + 1) / 4.0f;
            } else if (jButton == this.btnResX) {
                f3 = 1.0f;
            } else if (jButton == this.btnDecY) {
                f4 = (float)((int)(f2 * 4.0f) - 1) / 4.0f;
                if ((double)f4 < 1.0) {
                    f4 = 1.0f;
                }
            } else if (jButton == this.btnIncY) {
                f4 = (float)((int)(f2 * 4.0f) + 1) / 4.0f;
            } else if (jButton == this.btnResY) {
                f4 = 1.0f;
            }
            if (f3 != f && (double)f3 > 0.0) {
                this.txtScaleX.setText("" + f3);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(f3);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(f3);
                    }
                } else {
                    this.displayCanvas.setScaleX(f3);
                }
            }
            if (f4 != f2 && (double)f4 > 0.0) {
                this.txtScaleY.setText("" + f4);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(f4);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(f4);
                    }
                } else {
                    this.displayCanvas.setScaleY(f4);
                }
            }
        } else if (actionEvent.getSource() instanceof JFloatTextField) {
            JFloatTextField jFloatTextField = (JFloatTextField)actionEvent.getSource();
            if (jFloatTextField == this.txtScaleX) {
                f3 = f;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(f3);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(f3);
                    }
                } else {
                    this.displayCanvas.setScaleX(f3);
                }
            } else if (jFloatTextField == this.txtScaleY) {
                f4 = f2;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(f4);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(f4);
                    }
                } else {
                    this.displayCanvas.setScaleY(f4);
                }
            }
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Select Processors")) {
                this.showDialog();
            } else if (string.equals("Change Colors")) {
                this.showChangeColorDialog();
            } else if (string.equals("Usage Table")) {
                this.showUsageTable();
            } else if (string.equals("Usage Profile")) {
                this.showAMPIUsageProfile();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tabPane) {
            if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                this.txtScaleX.setText(this.displayCanvas.getScaleX() + "");
                this.txtScaleY.setText(this.displayCanvas.getScaleY() + "");
            } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                this.txtScaleX.setText(this.ampiDisplayCanvas.getScaleX() + "");
                this.txtScaleY.setText(this.ampiDisplayCanvas.getScaleY() + "");
            }
        }
    }

    public void applyDialogColors() {
        int n = Analysis.getNumFunctionEvents();
        System.out.println(this.colors[n]);
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    public void showChangeColorDialog() {
        int n = Analysis.getNumFunctionEvents();
        if (this.entryDialog == null) {
            String[] stringArray = new String[]{"Functions"};
            boolean[][] blArray = new boolean[1][n + 1];
            for (int i = 1; i < n + 1; ++i) {
                blArray[0][i] = true;
            }
            boolean[][] blArray2 = new boolean[1][n + 1];
            for (int i = 1; i < n; ++i) {
                blArray2[0][i] = true;
            }
            String[] stringArray2 = new String[n + 1];
            for (int i = 1; i < n; ++i) {
                stringArray2[i] = Analysis.getFunctionName(i);
            }
            stringArray2[n] = "OTHER";
            Color[][] colorArray = new Color[][]{this.colors};
            this.entryDialog = new EntrySelectionDialog(this, this, stringArray, blArray2, colorArray, blArray, stringArray2);
        }
        this.entryDialog.showDialog();
    }

    private void showUsageTable() {
        if (this.dataSource == null) {
            return;
        }
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Entry Points Usage Percent Table");
        jFrame.setDefaultCloseOperation(2);
        Object[] objectArray = new String[]{"Proc#", "Entry Name", "Usage Percent (%)"};
        int n = 0;
        for (int i = 1; i < this.dataSource.length; ++i) {
            n += this.dataSource[i].length;
        }
        Object[][] objectArray2 = new Object[n][];
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        int n2 = 0;
        for (int i = 1; i < this.dataSource.length; ++i) {
            for (int j = 0; j < this.dataSource[i].length; ++j) {
                objectArray2[n2] = new Object[3];
                objectArray2[n2][0] = this.procNames[i];
                objectArray2[n2][1] = this.nameMap[i][j];
                objectArray2[n2][2] = decimalFormat.format(this.dataSource[i][j]) + "%";
                ++n2;
            }
        }
        JTable jTable = new JTable(objectArray2, objectArray);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setLocationRelativeTo(this.parentWindow);
        jFrame.setSize(500, 250);
        jFrame.setVisible(true);
    }

    private void showAMPIUsageProfile() {
        Serializable serializable;
        Cloneable cloneable;
        JFrame jFrame = new JFrame();
        jFrame.setTitle("AMPI Function Profile Table");
        jFrame.setDefaultCloseOperation(2);
        Object[] objectArray = new String[]{"Processor#", "Function Name", "Source File Name", "Line#", "%/Total", "%/Process"};
        int n = -1;
        this.data.plist.reset();
        Vector[] vectorArray = new Vector[this.data.plist.size()];
        int n2 = 0;
        int n3 = 0;
        while (this.data.plist.hasMoreElements()) {
            n = this.data.plist.nextElement();
            vectorArray[n2] = new Vector();
            Analysis.createAMPIUsage(n, this.data.begintime, this.data.endtime, vectorArray[n2]);
            cloneable = vectorArray[n2];
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                AmpiProcessProfile ampiProcessProfile = (AmpiProcessProfile)((Vector)cloneable).get(i);
                n3 += ampiProcessProfile.getFinalCallFuncStack().size();
            }
            ++n2;
        }
        cloneable = new DecimalFormat();
        ((DecimalFormat)cloneable).setMaximumFractionDigits(3);
        long l = this.data.endtime - this.data.begintime;
        Object[][] objectArray2 = new Object[n3][];
        n = -1;
        this.data.plist.reset();
        n2 = 0;
        int n4 = 0;
        while (this.data.plist.hasMoreElements()) {
            n = this.data.plist.nextElement();
            serializable = vectorArray[n2++];
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                AmpiProcessProfile ampiProcessProfile = (AmpiProcessProfile)((Vector)serializable).get(i);
                long l2 = ampiProcessProfile.getAccExecTime();
                Stack stack = ampiProcessProfile.getFinalCallFuncStack();
                Enumeration enumeration = stack.elements();
                while (enumeration.hasMoreElements()) {
                    AmpiFunctionData ampiFunctionData = (AmpiFunctionData)enumeration.nextElement();
                    objectArray2[n4] = new Object[objectArray.length];
                    objectArray2[n4][0] = "" + n;
                    objectArray2[n4][1] = Analysis.getFunctionName(ampiFunctionData.FunctionID);
                    objectArray2[n4][2] = ampiFunctionData.sourceFileName;
                    objectArray2[n4][3] = "" + ampiFunctionData.LineNo;
                    objectArray2[n4][4] = ((NumberFormat)cloneable).format((double)ampiFunctionData.getAccExecTime() / (double)l * 100.0) + "%";
                    objectArray2[n4][5] = ((NumberFormat)cloneable).format((double)ampiFunctionData.getAccExecTime() / (double)l2 * 100.0) + "%";
                    ++n4;
                }
            }
        }
        serializable = new JTable(objectArray2, objectArray);
        JScrollPane jScrollPane = new JScrollPane((Component)serializable);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setLocationRelativeTo(this);
        jFrame.setSize(500, 250);
        jFrame.setVisible(true);
    }

    private void readAmpiUsageData() {
        int n = this.data.plist.size();
        this.accTime = new float[n][];
        int n2 = 0;
        int n3 = 0;
        UsageCalc usageCalc = new UsageCalc();
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Computing Usage Values", "", 0, this.data.numPs);
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            n3 = this.data.plist.nextElement();
            if (progressMonitor.isCanceled()) break;
            progressMonitor.setNote("[PE: " + n3 + " ] Computing Average.");
            progressMonitor.setProgress(n2);
            this.accTime[n2] = usageCalc.ampiUsage(n3, this.data.begintime, this.data.endtime, Analysis.getVersion());
            ++n2;
        }
        progressMonitor.close();
    }

    private void setAmpiDisplayProfileData() {
        int n;
        int n2 = -1;
        int n3 = this.data.plist.size();
        int n4 = Analysis.getNumFunctionEvents();
        String[] stringArray = new String[n4 - 1];
        Object var5_5 = null;
        boolean bl = false;
        float[][] fArrayArray = new float[n4 - 1][];
        String[][] stringArray2 = new String[n4 - 1][];
        double d = 1.0 / (double)n3;
        long l = this.data.endtime - this.data.begintime;
        long l2 = l * (long)this.data.numPs;
        for (n = 1; n < n4; ++n) {
            fArrayArray[n - 1] = new float[1];
            for (int i = 0; i < n3; ++i) {
                float[] fArray = fArrayArray[n - 1];
                fArray[0] = (float)((double)fArray[0] + (double)this.accTime[i][n] * d);
            }
            stringArray[n - 1] = Analysis.getFunctionName(n);
            stringArray2[n - 1] = new String[1];
            stringArray2[n - 1][0] = stringArray[n - 1];
        }
        n = n4 - 1;
        Color[] colorArray = ColorManager.createColorMap(n);
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            nArrayArray[i] = new int[1];
            nArrayArray[i][0] = i;
        }
        String[] stringArray3 = new String[]{"Profile of Usage per Functions in AMPI programs " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.ampiDisplayCanvas.setGraphTiltes(stringArray3);
        this.ampiDisplayCanvas.setXAxis("", "", stringArray);
        this.ampiDisplayCanvas.setYAxis("Usage Percent % (over processor)");
        this.ampiDisplayCanvas.setDisplayDataSource(fArrayArray, nArrayArray, colorArray, stringArray2);
        this.ampiDisplayCanvas.repaint();
    }

    private void setDisplayProfileData() {
        this.createDisplayDataSource();
        String[] stringArray = new String[]{"Profile of Usage for Processors " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.displayCanvas.setGraphTiltes(stringArray);
        String[] stringArray2 = new String[this.data.plist.size() + 1];
        stringArray2[0] = "Avg";
        this.data.plist.reset();
        int n = 1;
        while (this.data.plist.hasMoreElements()) {
            stringArray2[n++] = "" + this.data.plist.nextElement();
        }
        this.procNames = stringArray2;
        this.displayCanvas.setXAxis("", "", stringArray2);
        this.displayCanvas.setYAxis("Usage Percent %");
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    private void createDisplayDataSource() {
        int n;
        int n2;
        this.data.numPs = n2 = this.data.plist.size();
        int n3 = Analysis.getNumFunctionEvents();
        this.dataSource = new float[n2 + 1][];
        this.colorMap = new int[n2 + 1][];
        this.nameMap = new String[n2 + 1][];
        long l = this.data.endtime - this.data.begintime;
        this.avgData = new float[n3 + 1];
        for (int i = 0; i < n3 + 1; ++i) {
            this.avgData[i] = 0.0f;
        }
        double d = 1.0 / (double)this.data.plist.size();
        int n4 = 0;
        int n5 = -1;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Computing Usage Values", "", 0, this.data.numPs);
        n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < this.avgData.length; ++n) {
                int n6 = n;
                this.avgData[n6] = this.avgData[n6] + (float)((double)this.accTime[i][n] * d);
            }
        }
        if (!this.colorsSet) {
            Color[] colorArray = ColorManager.createColorMap(n3);
            this.colors = new Color[n3 + 1];
            for (n = 1; n < n3; ++n) {
                this.colors[n] = colorArray[n];
            }
            this.colors[n3] = Color.white;
            this.colorsSet = true;
        }
        this.createSingleProcSource(this.avgData, -1);
        this.dataSource[0] = this.sDataSrc;
        this.colorMap[0] = this.sColorMap;
        this.nameMap[0] = this.sNameMap;
        n4 = 0;
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            n5 = this.data.plist.nextElement();
            if (progressMonitor.isCanceled()) break;
            progressMonitor.setNote("[PE: " + n5 + " ] Reading Entry Point Usage.");
            progressMonitor.setProgress(n4);
            this.createSingleProcSource(this.accTime[n4], n5);
            this.dataSource[++n4] = this.sDataSrc;
            this.colorMap[n4] = this.sColorMap;
            this.nameMap[n4] = this.sNameMap;
        }
        progressMonitor.close();
    }

    public void createSingleProcSource(float[] fArray, int n) {
        int n2 = Analysis.getNumFunctionEvents() - 1;
        float[] fArray2 = new float[n2 + 1];
        int[] nArray = new int[n2 + 1];
        String[] stringArray = new String[n2 + 1];
        this.sDataSrc = fArray2;
        this.sColorMap = nArray;
        this.sNameMap = stringArray;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(5);
        decimalFormat.setMinimumFractionDigits(5);
        String[] stringArray2 = Analysis.getFunctionNames();
        for (int i = 0; i < n2 + 1; ++i) {
            float f = fArray[i + 1];
            if (f <= 0.0f) continue;
            fArray2[i] = f;
            nArray[i] = i + 1;
            stringArray[i] = i == n2 ? "OTHER" : Analysis.getFunctionName(i + 1);
        }
    }

    public void MakePOArray(long l, long l2) {
    }

    private void setScales() {
    }

    private void setSizes() {
    }

    public int getHSBValue() {
        return 0;
    }

    public int getVSBValue() {
        return 0;
    }
}

