/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.gui.Analysis;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.U;
import projections.gui.Util;

public class AmpiTimeProfileWindow
extends GenericGraphWindow
implements ActionListener,
ColorSelectable {
    private AmpiTimeProfileWindow thisWindow = null;
    private EntrySelectionDialog entryDialog = null;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JButton epSelection;
    private JButton setRanges;
    private JButton saveColors;
    private JButton loadColors;
    int startInterval;
    int endInterval;
    long intervalSize;
    OrderedIntList processorList;
    Vector[] processProfiles = null;
    private int numFunctions;
    private String[] typeLabelNames = new String[]{"Ampi Functions"};
    private boolean[][] stateArray;
    private boolean[][] existsArray;
    private Color[][] colorArray;
    private String[] funcNames;
    private double[][] graphData = null;
    private double[][] outputData = null;
    private Color[] outColors = null;

    public AmpiTimeProfileWindow(MainWindow mainWindow, Integer n) {
        super("Projections Time Profile Graph--AMPI - " + Analysis.getFilename() + ".sts", mainWindow, n);
        this.setGraphSpecificData();
        this.createLayout();
        this.thisWindow = this;
    }

    private void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(gridBagLayout);
        this.epSelection = new JButton("Select Functions");
        this.epSelection.addActionListener(this);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.saveColors = new JButton("Save Function Colors");
        this.saveColors.addActionListener(this);
        this.loadColors = new JButton("Load Function Colors");
        this.loadColors.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        Util.gblAdd(this.controlPanel, this.epSelection, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.saveColors, gridBagConstraints, 2, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.loadColors, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        JPanel jPanel = this.getMainPanel();
        Util.gblAdd(this.mainPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.mainPanel, this.controlPanel, gridBagConstraints, 0, 1, 1, 0, 0, 0);
    }

    public JPanel getAmpiMainPanel() {
        return this.mainPanel;
    }

    public void setGraphSpecificData() {
        this.setXAxis("Time in us", "");
        this.setYAxis("Function execution time", "us");
    }

    public void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        this.startInterval = (int)intervalRangeDialog.getStartInterval();
        this.endInterval = (int)intervalRangeDialog.getEndInterval();
        this.processorList = intervalRangeDialog.getValidProcessors();
        this.processProfiles = new Vector[this.processorList.size()];
        super.getDialogData();
    }

    public void setDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        intervalRangeDialog.setIntervalSize(this.intervalSize);
        intervalRangeDialog.setValidProcessors(this.processorList);
        super.setDialogData();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
        }
    }

    public void showWindow() {
    }

    public void createAMPITimeProfileData(int n, int n2) {
        this.processProfiles[n2] = new Vector();
        Analysis.createAMPITimeProfile(n, 0L, Analysis.getTotalTime(), this.processProfiles[n2]);
    }

    public void getRangeVals(long l, long l2, int n, int n2, long l3, OrderedIntList orderedIntList) {
        this.startTime = l;
        this.endTime = l2;
        this.startInterval = n;
        this.endInterval = n2;
        this.intervalSize = l3;
        this.processorList = orderedIntList.copyOf();
        this.processProfiles = new Vector[this.processorList.size()];
    }

    public void getRangeVals() {
    }

    private void fillGraphData() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.processProfiles.length; ++n3) {
            Vector vector = this.processProfiles[n3];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                AmpiProcessProfile ampiProcessProfile = (AmpiProcessProfile)vector.get(n2);
                Stack stack = ampiProcessProfile.getFinalCallFuncStack();
                n4 += stack.size();
            }
        }
        this.numFunctions = n4;
        this.outColors = ColorManager.createColorMap(n4);
        this.funcNames = new String[n4];
        this.colorArray = new Color[1][n4];
        this.stateArray = new boolean[1][n4];
        this.existsArray = new boolean[1][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.colorArray[0][n3] = this.outColors[n3];
            this.stateArray[0][n3] = true;
            this.existsArray[0][n3] = false;
        }
        n3 = this.endInterval - this.startInterval + 1;
        this.outputData = new double[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                this.outputData[i][n2] = 0.0;
            }
        }
        n4 = 0;
        long l = (long)this.startInterval * this.intervalSize;
        long l2 = (long)this.endInterval * this.intervalSize;
        for (n = 0; n < this.processProfiles.length; ++n) {
            Vector vector = this.processProfiles[n];
            for (int i = 0; i < vector.size(); ++i) {
                AmpiProcessProfile ampiProcessProfile = (AmpiProcessProfile)vector.get(i);
                Stack stack = ampiProcessProfile.getFinalCallFuncStack();
                for (int j = 0; j < stack.size(); ++j) {
                    AmpiFunctionData ampiFunctionData = (AmpiFunctionData)stack.get(j);
                    this.funcNames[n4] = ampiFunctionData.getFunctionName();
                    if (!this.stateArray[0][n4]) continue;
                    for (int k = 0; k < ampiFunctionData.execIntervalCnt(); ++k) {
                        long l3;
                        AmpiFunctionData.AmpiFuncExecInterval ampiFuncExecInterval = ampiFunctionData.getIntervalAt(k);
                        long l4 = ampiFuncExecInterval.startTimestamp > l ? ampiFuncExecInterval.startTimestamp : l;
                        long l5 = l3 = ampiFuncExecInterval.endTimestamp < l2 ? ampiFuncExecInterval.endTimestamp : l2;
                        if (l3 <= l4) continue;
                        this.existsArray[0][n4] = true;
                        int n5 = (int)((l4 - l) / this.intervalSize);
                        int n6 = (int)((l3 - l) / this.intervalSize);
                        this.outputData[n5][n4] = (double)((long)(n5 + 1) * this.intervalSize + l - l4) / (double)this.intervalSize;
                        this.outputData[n6][n4] = (double)(l3 - (long)n6 * this.intervalSize - l) / (double)this.intervalSize;
                        for (int i2 = n5 + 1; i2 < n6; ++i2) {
                            this.outputData[i2][n4] = 1.0;
                        }
                    }
                    ++n4;
                }
            }
        }
        this.graphData = new double[this.outputData.length][];
        for (n = 0; n < this.outputData.length; ++n) {
            this.graphData[n] = new double[this.outputData[n].length];
            for (int i = 0; i < this.outputData[n].length; ++i) {
                this.graphData[n][i] = this.outputData[n][i];
            }
        }
    }

    public void applyDialogColors() {
        int n;
        for (n = 0; n < this.numFunctions; ++n) {
            this.outColors[n] = this.colorArray[0][n];
        }
        for (n = 0; n < this.outputData.length; ++n) {
            for (int i = 0; i < this.numFunctions; ++i) {
                this.outputData[n][i] = this.stateArray[0][i] ? this.graphData[n][i] : 0.0;
            }
        }
        this.setOutputGraphData(false);
    }

    public void setOutputGraphData(boolean bl) {
        if (bl) {
            this.fillGraphData();
        }
        this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
        this.setYAxis("AMPI function Execution Time (intervals)", "");
        this.setDataSource("Time Profile Graph", this.outputData, this.outColors, this.thisWindow);
        super.refreshGraph();
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int n3 = 0;
        String string = null;
        for (int i = 0; i < this.numFunctions; ++i) {
            if (!this.stateArray[0][i] || n3++ != n2) continue;
            string = this.funcNames[i];
            break;
        }
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[]{string, "Execution Time = " + (long)(this.outputData[n][n2] * (double)this.intervalSize / 1000.0) + "ms"};
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.epSelection) {
                if (this.entryDialog == null) {
                    this.entryDialog = new EntrySelectionDialog(this, this, this.typeLabelNames, this.stateArray, this.colorArray, this.existsArray, this.funcNames);
                }
                this.entryDialog.showDialog();
            } else if (jButton == this.setRanges) {
                this.showDialog();
                this.processorList.reset();
                int n = 0;
                while (this.processorList.hasMoreElements()) {
                    int n2 = this.processorList.nextElement();
                    this.createAMPITimeProfileData(n2, n++);
                }
                this.setOutputGraphData(true);
            } else if (jButton == this.saveColors) {
                Analysis.saveColors();
            } else if (jButton == this.loadColors) {
                try {
                    ColorManager.loadActivityColors(0, this.colorArray[0]);
                    this.setOutputGraphData(false);
                }
                catch (IOException iOException) {
                    System.err.println("Failed to load colors!!");
                }
            }
        }
    }
}

