/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.IntervalData;
import projections.analysis.LogLoader;
import projections.analysis.LogReader;
import projections.analysis.PoseDopReader;
import projections.analysis.ProjectionsConfigurationReader;
import projections.analysis.StsReader;
import projections.analysis.SumAnalyzer;
import projections.analysis.SumDetailReader;
import projections.analysis.UsageCalc;
import projections.gui.ColorManager;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.misc.EntryNotFoundException;
import projections.misc.FileUtils;
import projections.misc.LogLoadException;
import projections.misc.SummaryFormatException;

public class Analysis {
    public static ProjectionsConfigurationReader rcReader;
    public static Component guiRoot;
    private static StsReader sts;
    public static LogLoader logLoader;
    private static SumAnalyzer sumAnalyzer;
    private static SumDetailReader[] summaryDetails;
    private static PoseDopReader dopReader;
    private static IntervalData intervalData;
    private static String baseName;
    private static String logDirectory;
    private static long totalTime;
    private static long poseTotalTime;
    private static long poseTotalVirtualTime;
    private static int[][][] systemUsageData;
    private static int[][][][] systemMsgsData;
    private static int[][][][] userEntryData;
    private static int[] bgData;
    private static long logReaderIntervalSize;
    private static long jStartTime;
    private static long jEndTime;
    private static boolean jTimeAvailable;
    public static Color background;
    public static Color foreground;
    private static Color[] entryColors;
    private static Color[] userEventColors;
    private static Color[] functionColors;
    private static Color[][] activityColors;
    private static Color[] grayColors;
    private static Color[] grayUserEventColors;
    private static Color[] activeColorMap;
    private static Color[] activeUserColorMap;

    public static void initAnalysis(String string, Component component) throws IOException {
        Object object;
        guiRoot = component;
        try {
            baseName = FileUtils.getBaseName(string);
            logDirectory = FileUtils.dirFromFile(string);
            sts = new StsReader(string);
            rcReader = new ProjectionsConfigurationReader(string);
            FileUtils.detectFiles(sts, logDirectory, baseName);
            object = Analysis.getLogDirectory() + File.separator + "savedcolors.prj";
            ColorManager.setDefaultLocation((String)object);
            if (new File((String)object).exists()) {
                activityColors = ColorManager.initializeColors((String)object);
                if (activityColors == null) {
                    activityColors = ColorManager.initializeColors();
                }
            } else {
                activityColors = ColorManager.initializeColors();
            }
            entryColors = activityColors[0];
            userEventColors = activityColors[1];
            functionColors = activityColors[2];
            grayColors = ColorManager.createGrayscaleColorMap(sts.getEntryCount());
            grayUserEventColors = ColorManager.createGrayscaleColorMap(sts.getNumUserDefinedEvents());
            activeColorMap = entryColors;
            activeUserColorMap = userEventColors;
        }
        catch (LogLoadException logLoadException) {
            throw new IOException(logLoadException.toString());
        }
        if (Analysis.hasSumAccumulatedFile()) {
            sumAnalyzer = null;
            sumAnalyzer = new SumAnalyzer(sts, 0);
            Analysis.setTotalTime(sumAnalyzer.GetTotalTime());
        }
        if (Analysis.hasSumFiles()) {
            try {
                sumAnalyzer = null;
                sumAnalyzer = new SumAnalyzer();
                Analysis.setTotalTime(sumAnalyzer.GetTotalTime());
            }
            catch (SummaryFormatException summaryFormatException) {
                System.err.println(summaryFormatException.toString());
            }
        }
        if (Analysis.hasSumDetailFiles()) {
            if (intervalData == null) {
                intervalData = new IntervalData();
            }
            Analysis.setTotalTime((long)((double)intervalData.getNumIntervals() * intervalData.getIntervalSize() * 1000000.0));
        }
        if (Analysis.hasLogFiles()) {
            logLoader = new LogLoader();
            if (ProjectionsConfigurationReader.RC_GLOBAL_END_TIME == -1L) {
                Analysis.setTotalTime(logLoader.determineEndTime(Analysis.getValidProcessorList(0)));
                rcReader.setValue("RC_GLOBAL_END_TIME", new Long(Analysis.getTotalTime()));
            } else {
                Analysis.setTotalTime(ProjectionsConfigurationReader.RC_GLOBAL_END_TIME);
            }
        }
        if (Analysis.hasPoseDopFiles()) {
            dopReader = new PoseDopReader();
            object = new SwingWorker(){

                public Object construct() {
                    poseTotalTime = dopReader.getTotalRealTime();
                    poseTotalVirtualTime = dopReader.getTotalVirtualTime();
                    return null;
                }

                public void finished() {
                }
            };
            ((SwingWorker)object).start();
        }
    }

    public static void createAMPIUsage(int n, long l, long l2, Vector vector) {
        try {
            if (Analysis.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                logLoader.createAMPIUsageProfile(n, l, l2, vector);
            } else {
                System.err.println("createAMPIUsage: No log files available!");
            }
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LOG LOAD EXCEPTION");
        }
    }

    public static void createAMPITimeProfile(int n, long l, long l2, Vector vector) {
        try {
            if (Analysis.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                logLoader.createAMPIFuncTimeProfile(n, l, l2, vector);
            } else {
                System.err.println("createAMPIUsage: No log files available!");
            }
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LOG LOAD EXCEPTION");
        }
    }

    public static int getNumPhases() {
        if (sumAnalyzer != null) {
            return sumAnalyzer.GetPhaseCount();
        }
        return 0;
    }

    public static int[][] getSystemMsgsData(int n, int n2) {
        return systemMsgsData[n][n2];
    }

    public static int[][] getSystemUsageData(int n) {
        return systemUsageData[n];
    }

    public static long getTotalTime() {
        return totalTime;
    }

    public static void setTotalTime(long l) {
        totalTime = l;
    }

    public static long getPoseTotalTime() {
        return poseTotalTime;
    }

    public static long getPoseTotalVirtualTime() {
        return poseTotalVirtualTime;
    }

    public static PoseDopReader getPoseDopReader() {
        return dopReader;
    }

    public static long getLogReaderIntervalSize() {
        return logReaderIntervalSize;
    }

    public static double[] getSummaryAverageData() {
        return sumAnalyzer.getSummaryAverageData();
    }

    public static long getSummaryIntervalSize() {
        return sumAnalyzer.getIntervalSize();
    }

    public static Color getEntryColor(int n) {
        if (n < sts.getEntryCount()) {
            return activeColorMap[n];
        }
        return null;
    }

    public static void setEntryColor(int n, Color color) {
        if (n < sts.getEntryCount()) {
            Analysis.activeColorMap[n] = color;
        } else {
            System.err.println("Warning: entry point index " + n + " not found. Cannot set color");
        }
    }

    public static float[][] GetUsageData(int n, long l, long l2, OrderedIntList orderedIntList) {
        long[][] lArray;
        if (Analysis.hasLogFiles()) {
            UsageCalc usageCalc = new UsageCalc();
            return usageCalc.usage(n, l, l2, Analysis.getVersion());
        }
        int n2 = sts.getEntryCount();
        if (sumAnalyzer.GetPhaseCount() > 1) {
            orderedIntList.reset();
            lArray = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
            if (orderedIntList.hasMoreElements()) {
                while (orderedIntList.hasMoreElements() && n > -1) {
                    long[][] lArray2 = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
                    for (int i = 0; i < n2; ++i) {
                        long[] lArray3 = lArray[n];
                        int n3 = i;
                        lArray3[n3] = lArray3[n3] + lArray2[n][i];
                    }
                }
            }
        } else {
            lArray = sumAnalyzer.GetChareTime();
        }
        float[][] fArray = new float[2][n2 + 4];
        double d = 100.0 / (double)Analysis.getTotalTime();
        for (int i = 0; i < n2; ++i) {
            fArray[0][i] = (float)(d * (double)lArray[n][i]);
            fArray[1][i] = 0.0f;
        }
        return fArray;
    }

    public static int[][] getUserEntryData(int n, int n2) {
        return userEntryData[n][n2];
    }

    public static boolean hasSystemMsgsData(int n, int n2) {
        if (systemMsgsData == null) {
            return false;
        }
        return null != systemMsgsData[n][n2];
    }

    public static boolean hasUserEntryData(int n, int n2) {
        if (userEntryData == null) {
            return false;
        }
        if (userEntryData[n][n2] == null) {
            return false;
        }
        for (int i = 0; i < Analysis.getNumProcessors(); ++i) {
            if (userEntryData[n][n2][i] == null) continue;
            return true;
        }
        return false;
    }

    public static int[] getBGData() {
        return bgData;
    }

    public static void LoadGraphData(long l, int n, int n2, boolean bl, OrderedIntList orderedIntList) {
        if (Analysis.hasLogFiles()) {
            LogReader logReader = new LogReader();
            logReader.read(l, n, n2, bl, orderedIntList);
            systemUsageData = logReader.getSystemUsageData();
            systemMsgsData = logReader.getSystemMsgs();
            userEntryData = logReader.getUserEntries();
            logReaderIntervalSize = logReader.getIntervalSize();
        } else if (Analysis.hasSumDetailFiles()) {
            IntervalData intervalData = new IntervalData();
            intervalData.loadIntervalData(l, n, n2, bl, orderedIntList);
            systemUsageData = intervalData.getSystemUsageData();
            systemMsgsData = intervalData.getSystemMsgs();
            userEntryData = intervalData.getUserEntries();
        } else if (Analysis.hasSumFiles()) {
            Analysis.loadSummaryData(l, n, n2);
        } else {
            System.err.println("Error: No data Files found!!");
        }
    }

    public static void loadSummaryData(long l, int n, int n2) {
        systemUsageData = new int[3][][];
        try {
            Analysis.systemUsageData[1] = sumAnalyzer.GetSystemUsageData(n, n2, l);
        }
        catch (SummaryFormatException summaryFormatException) {
            System.err.println("Caught SummaryFormatException");
        }
        catch (IOException iOException) {
            System.err.println("Caught IOException");
        }
    }

    public static void loadSummaryData(int n, int n2) {
        Analysis.loadSummaryData(sumAnalyzer.getIntervalSize(), n, n2);
    }

    public static void loadSummaryData() {
        if (Analysis.hasSumFiles()) {
            int n = (int)sumAnalyzer.getIntervalSize();
            int n2 = (int)(Analysis.getTotalTime() / (long)n);
            Analysis.loadSummaryData(n, 0, n2 - 1);
        } else if (Analysis.hasSumAccumulatedFile()) {
            // empty if block
        }
    }

    public static double[][] getSumDetailData(int n, int n2) {
        return intervalData.getData(n, n2);
    }

    public static long searchTimeline(int n, int n2, int n3) throws EntryNotFoundException {
        try {
            if (Analysis.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                return logLoader.searchtimeline(n2, n3, n);
            }
            System.err.println("No log files!");
            return -1L;
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LogLoadException");
            return -1L;
        }
    }

    public static double getVersion() {
        if (sts == null) {
            return MainWindow.CUR_VERSION;
        }
        return sts.getVersion();
    }

    public static boolean hasSummaryData() {
        return Analysis.hasSumFiles() || Analysis.hasSumAccumulatedFile();
    }

    public static boolean hasLogData() {
        return Analysis.hasLogFiles();
    }

    public static boolean hasSumDetailData() {
        return Analysis.hasSumDetailFiles();
    }

    public static boolean hasPoseDopData() {
        return Analysis.hasPoseDopFiles();
    }

    public static String getLogDirectory() {
        return logDirectory;
    }

    public static String getFilename() {
        return baseName;
    }

    public static int stringToActivity(String string) {
        if (string.equals("PROJECTIONS")) {
            return 0;
        }
        if (string.equals("USER_EVENTS")) {
            return 1;
        }
        if (string.equals("FUNCTIONS")) {
            return 2;
        }
        if (string.equals("POSE_DOP")) {
            return 3;
        }
        return -1;
    }

    public static int getNumActivity(int n) {
        switch (n) {
            case 0: {
                return Analysis.getNumUserEntries();
            }
            case 1: {
                return Analysis.getNumUserDefinedEvents();
            }
            case 2: {
                return Analysis.getNumFunctionEvents();
            }
        }
        return 0;
    }

    public static String getActivityNameByID(int n, int n2) {
        switch (n) {
            case 0: {
                return Analysis.getEntryName(n2);
            }
            case 1: {
                return Analysis.getUserEventName(n2);
            }
            case 2: {
                return Analysis.getFunctionName(n2);
            }
        }
        return "";
    }

    public static String getActivityNameByIndex(int n, int n2) {
        switch (n) {
            case 0: {
                return Analysis.getEntryName(n2);
            }
            case 1: {
                String[] stringArray = Analysis.getUserEventNames();
                return stringArray[n2];
            }
            case 2: {
                String[] stringArray = Analysis.getFunctionNames();
                return stringArray[n2];
            }
        }
        return "";
    }

    public static int getNumProcessors() {
        return sts.getProcessorCount();
    }

    public static int getNumUserEntries() {
        return sts.getEntryCount();
    }

    public static String[][] getEntryNames() {
        return sts.getEntryNames();
    }

    public static String getEntryName(int n) {
        return sts.getEntryNames()[n][0];
    }

    public static String getEntryChareName(int n) {
        return sts.getEntryNames()[n][1];
    }

    public static int getNumUserDefinedEvents() {
        return sts.getNumUserDefinedEvents();
    }

    public static int getUserDefinedEventIndex(int n) {
        return sts.getUserEventIndex(n);
    }

    public static String getUserEventName(int n) {
        return sts.getUserEventName(n);
    }

    public static String[] getUserEventNames() {
        return sts.getUserEventNames();
    }

    public static int getNumPerfCounts() {
        return sts.getNumPerfCounts();
    }

    public static String[] getPerfCountNames() {
        return sts.getPerfCountNames();
    }

    public static int getNumFunctionEvents() {
        return sts.getNumFunctionEvents();
    }

    public static Color getFunctionColor(int n) {
        return functionColors[sts.getFunctionEventIndex(n)];
    }

    public static Color[] getFunctionColors() {
        return functionColors;
    }

    public static void saveColors() {
        ColorManager.saveColors(activityColors);
    }

    public static String getFunctionName(int n) {
        return sts.getFunctionEventDescriptor(n);
    }

    public static String[] getFunctionNames() {
        return sts.getFunctionEventDescriptors();
    }

    public static int getNumIntervals() {
        if (intervalData == null) {
            System.err.println("No interval based data. Call to getNumIntervals is invalid.");
            return -1;
        }
        return intervalData.getNumIntervals();
    }

    public static double getIntervalSize() {
        if (intervalData == null) {
            System.err.println("No interval based data. Call to getIntervalSize is invalid.");
            return -1.0;
        }
        return intervalData.getIntervalSize();
    }

    public static Color getUserEventColor(int n) {
        if (sts != null) {
            return userEventColors[sts.getUserEventIndex(n)];
        }
        return null;
    }

    public static double[][] getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3) {
        return intervalData.getDataSummedAcrossProcessors(n, orderedIntList, n2, n3);
    }

    public static Vector getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3, OrderedIntList orderedIntList2) {
        return intervalData.getDataSummedAcrossProcessors(n, orderedIntList, n2, n3, orderedIntList2);
    }

    public static Color[] getColorMap(int n) {
        return activityColors[n];
    }

    public static Color[] getColorMap() {
        return activeColorMap;
    }

    public static void setFullColor() {
        activeColorMap = entryColors;
        activeUserColorMap = userEventColors;
    }

    public static void setGrayscale() {
        activeColorMap = grayColors;
        activeUserColorMap = grayUserEventColors;
    }

    public static void setJTimeAvailable(boolean bl) {
        jTimeAvailable = bl;
    }

    public static boolean checkJTimeAvailable() {
        return jTimeAvailable;
    }

    public static void setJTime(long l, long l2) {
        jStartTime = l;
        jEndTime = l2;
    }

    public static long getJStart() {
        return jStartTime;
    }

    public static long getJEnd() {
        return jEndTime;
    }

    public static boolean hasPapi() {
        return sts.hasPapi();
    }

    public static String getValidProcessorString(int n) {
        return FileUtils.getValidProcessorString(n);
    }

    public static OrderedIntList getValidProcessorList(int n) {
        return FileUtils.getValidProcessorList(n);
    }

    public static String getValidProcessorString() {
        if (Analysis.hasLogFiles()) {
            return Analysis.getValidProcessorString(0);
        }
        if (Analysis.hasSumFiles()) {
            return Analysis.getValidProcessorString(1);
        }
        if (Analysis.hasSumDetailFiles()) {
            return Analysis.getValidProcessorString(2);
        }
        if (Analysis.hasPoseDopFiles()) {
            return Analysis.getValidProcessorString(3);
        }
        return "";
    }

    public static OrderedIntList getValidProcessorList() {
        if (Analysis.hasLogFiles()) {
            return Analysis.getValidProcessorList(0);
        }
        if (Analysis.hasSumFiles()) {
            return Analysis.getValidProcessorList(1);
        }
        if (Analysis.hasSumDetailFiles()) {
            return Analysis.getValidProcessorList(2);
        }
        if (Analysis.hasPoseDopFiles()) {
            return Analysis.getValidProcessorList(3);
        }
        return null;
    }

    public static String getLogName(int n) {
        return FileUtils.getFileName(baseName, n, 0);
    }

    public static String getSumName(int n) {
        return FileUtils.getFileName(baseName, n, 1);
    }

    public static String getSumAccumulatedName() {
        return FileUtils.getSumAccumulatedName(baseName);
    }

    public static String getSumDetailName(int n) {
        return FileUtils.getFileName(baseName, n, 2);
    }

    public static String getPoseDopName(int n) {
        return FileUtils.getFileName(baseName, n, 3);
    }

    public static void closeRC() {
        if (rcReader != null) {
            rcReader.close();
        }
    }

    private static boolean hasLogFiles() {
        return FileUtils.hasLogFiles();
    }

    private static boolean hasSumFiles() {
        return FileUtils.hasSumFiles();
    }

    private static boolean hasSumAccumulatedFile() {
        return FileUtils.hasSumAccumulatedFile();
    }

    private static boolean hasSumDetailFiles() {
        return FileUtils.hasSumDetailFiles();
    }

    private static boolean hasPoseDopFiles() {
        return FileUtils.hasPoseDopFiles();
    }

    static {
        totalTime = 0L;
        poseTotalTime = 0L;
        poseTotalVirtualTime = 0L;
        logReaderIntervalSize = -1L;
        background = Color.black;
        foreground = Color.white;
        activityColors = new Color[4][];
    }
}

