/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import projections.gui.Analysis;

public class ColorManager {
    private static String filename = null;

    public static void setDefaultLocation(String string) {
        filename = string;
    }

    public static Color[][] initializeColors() {
        Color[][] colorArray = new Color[4][];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = ColorManager.createColorMap(Analysis.getNumActivity(i));
        }
        return colorArray;
    }

    public static Color[][] initializeColors(String string) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
        Color[][] colorArray = new Color[4][];
        String[] stringArray = null;
        Color[][] colorArray2 = null;
        int n = 0;
        try {
            int n2;
            stringArray = (String[])objectInputStream.readObject();
            colorArray2 = (Color[][])objectInputStream.readObject();
            if (stringArray.length != colorArray2.length) {
                System.err.println("WARNING: Color file corrupted. Number of names do not match number of sets of colors.");
                return null;
            }
            for (n2 = 0; n2 < colorArray2.length; ++n2) {
                n = Analysis.stringToActivity(stringArray[n2]);
                if (n == -1) continue;
                colorArray[n] = colorArray2[n2];
            }
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                if (colorArray[n2] != null) continue;
                colorArray[n2] = ColorManager.createColorMap(Analysis.getNumActivity(n2));
            }
        }
        catch (ClassCastException classCastException) {
            objectInputStream.close();
            int n3 = 0;
            colorArray[n3] = new Color[Analysis.getNumActivity(n3)];
            ColorManager.loadActivityColors(n3, colorArray[n3]);
            for (int i = 0; i < colorArray.length; ++i) {
                if (colorArray[i] != null) continue;
                colorArray[i] = ColorManager.createColorMap(Analysis.getNumActivity(i));
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: Failed to read saved color object");
            System.err.println(exception);
            return null;
        }
        objectInputStream.close();
        return colorArray;
    }

    public static void loadActivityColors(int n, Color[] colorArray) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(filename));
        Color[][] colorArray2 = null;
        try {
            colorArray2 = (Color[][])objectInputStream.readObject();
        }
        catch (ClassCastException classCastException) {
            colorArray2[n] = ColorManager.loadActivityColorsFallback(n);
        }
        catch (Exception exception) {
            System.err.println("WARNING: Failed to read saved color object");
            System.err.println(exception);
        }
        objectInputStream.close();
        if (n >= 0 && n < 4) {
            if (colorArray.length == colorArray2[n].length) {
                for (int i = 0; i < colorArray.length; ++i) {
                    colorArray[i] = colorArray2[n][i];
                }
            } else {
                System.err.println("WARNING: Current color array length of " + colorArray.length + " does not match " + "stored color array length of " + colorArray2[n].length + ". Load " + "request rejected.");
            }
        } else {
            System.err.println("WARNING - Internal Error: Activity type " + n + " unknown when requesting load " + "colors. Please inform developers");
        }
    }

    public static Color[] loadActivityColorsFallback(int n) throws IOException {
        Color[] colorArray = null;
        if (n == 0) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(filename));
            try {
                colorArray = (Color[])objectInputStream.readObject();
            }
            catch (ClassCastException classCastException) {
                System.err.println("WARNING: Unexpected object format when attempting to read color file");
                System.err.println(classCastException);
                return null;
            }
            catch (Exception exception) {
                System.err.println("WARNING: Failed to read saved color object");
                System.err.println(exception);
                return null;
            }
            objectInputStream.close();
        } else {
            colorArray = ColorManager.createColorMap(Analysis.getNumActivity(n));
        }
        return colorArray;
    }

    public static void saveColors(Color[][] colorArray) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(filename));
            objectOutputStream.writeObject(colorArray);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("WARNING: Failed to save color file to " + filename);
            System.err.println(exception);
        }
    }

    public static Color[] createGrayscaleColorMap(int n) {
        Color[] colorArray = new Color[n];
        float f = 1.0f;
        float f2 = 0.0f;
        float f3 = 0.9f;
        float f4 = (float)(0.8 / (double)n);
        for (int i = 0; i < n; ++i) {
            colorArray[i] = Color.getHSBColor(f, f2, f3);
            if (!((double)(f3 -= f4) < 0.1)) continue;
            f3 = 0.1f;
        }
        return colorArray;
    }

    public static Color[] createColorMap(int n) {
        Color[] colorArray = new Color[n];
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = (float)(1.0 / (double)n);
        for (int i = 0; i < n; ++i) {
            colorArray[i] = Color.getHSBColor(f, f2, f3);
            if (!((double)(f -= f4) < 0.0)) continue;
            f = 1.0f;
        }
        return colorArray;
    }

    public static Color[] createColorMap(int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        if (n2 > 0) {
            int n3 = 2;
            int n4 = 7;
            nArray2[n2 - 1] = 5;
            for (int i = n2 - 2; i >= 0; --i) {
                nArray2[i] = nArray2[i + 1] + n4;
                n4 += n3;
            }
        }
        return ColorManager.createColorMap(n, nArray, nArray2);
    }

    public static Color[] createColorMap(int n, int[] nArray, int[] nArray2) {
        Color[] colorArray = new Color[n];
        int n2 = nArray.length;
        if (n2 == 0) {
            return ColorManager.createColorMap(n);
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += nArray2[i];
        }
        double d = (double)nArray2[n2 - 1] / (double)n3;
        int n4 = n - n2;
        double d2 = 1.0 / (d * (double)n4 + 1.0);
        if (d2 < 0.67) {
            d2 = 0.67;
        }
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        for (int i = 0; i < n2; ++i) {
            colorArray[nArray[i]] = Color.getHSBColor((float)d3, (float)d4, (float)d5);
            d3 -= (double)nArray2[i] / (double)n3 * d2;
        }
        double d6 = d3 / (double)n4;
        for (int i = 0; i < n; ++i) {
            if (colorArray[i] != null) continue;
            colorArray[i] = Color.getHSBColor((float)d3, (float)d4, (float)d5);
            d3 -= d6;
        }
        return colorArray;
    }
}

