/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import projections.gui.Analysis;
import projections.gui.GraphData;
import projections.gui.Util;

public class GraphWAxisCanvas
extends Canvas {
    private GraphData data;
    private int width = 0;
    private int textheight = 0;
    private int labelwidth = 0;
    private int labelincrement = 0;
    private double deltay = 0.0;

    public GraphWAxisCanvas() {
        this.setBackground(Analysis.background);
        this.setForeground(Analysis.foreground);
    }

    public int getPreferredWidth() {
        Graphics graphics;
        if (this.width == 0 && (graphics = this.getGraphics()) != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.width = fontMetrics.stringWidth("100") + fontMetrics.stringWidth("%") + 20;
            graphics.dispose();
        }
        return this.width;
    }

    public void paint(Graphics graphics) {
        if (this.data == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height - this.data.offset2;
        graphics.setColor(Analysis.background);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.textheight == 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.textheight = fontMetrics.getHeight();
            this.labelwidth = fontMetrics.stringWidth("%");
        }
        graphics.setColor(Analysis.foreground);
        graphics.drawString("%", n - 5 - this.labelwidth, n2 / 2);
        graphics.drawLine(5, this.data.offset, 5, n2 - 1);
        for (int i = 0; i <= 100; ++i) {
            int n3 = n2 - (int)((double)i * this.deltay) - 1;
            if (i % this.labelincrement == 0) {
                graphics.drawLine(0, n3, 10, n3);
                graphics.drawString("" + i, 15, n3 += (int)(0.5 * (double)this.textheight));
                continue;
            }
            graphics.drawLine(3, n3, 7, n3);
        }
    }

    public void print(Graphics graphics) {
        ((Graphics2D)graphics).setBackground(Color.white);
        this.setForeground(Color.black);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.clearRect(0, 0, n, n2);
        this.paint(graphics);
        ((Graphics2D)graphics).setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.textheight == 0) {
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.textheight = fontMetrics.getHeight();
            this.labelwidth = fontMetrics.stringWidth("%");
            graphics.dispose();
        }
        this.deltay = (double)(n4 - this.data.offset - this.data.offset2) / 100.0;
        this.labelincrement = (int)Math.ceil((double)(this.textheight + 10) / this.deltay);
        this.labelincrement = Util.getBestIncrement(this.labelincrement);
        this.data.wscale = this.deltay;
        super.setBounds(n, n2, n3, n4);
    }

    public void setData(GraphData graphData) {
        this.data = graphData;
    }
}

