/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import projections.gui.JTimeTextField;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class IntervalRangeDialog
extends RangeDialog
implements ActionListener,
KeyListener,
FocusListener {
    JPanel sizePanel;
    JTimeTextField sizeField;
    JLabel numIntervalsLabel;
    JLabel validIntervalsLabel;
    JLabel startIntervalLabel;
    JLabel endIntervalLabel;
    public long intervalSize = -1L;
    private long numIntervals;
    private long validIntervals;
    private long startInterval;
    private long endInterval;

    public IntervalRangeDialog(ProjectionsWindow projectionsWindow, String string) {
        super(projectionsWindow, string);
        long l = 1000L;
        this.validIntervals = this.totalValidTime / l;
        if (this.totalValidTime % l != 0L) {
            ++this.validIntervals;
        }
        this.startInterval = this.startTime / l;
        this.endInterval = this.endTime / l;
        this.numIntervals = this.endInterval - this.startInterval + 1L;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bOK) {
                JTextField jTextField = this.checkConsistent();
                if (jTextField != null) {
                    jTextField.selectAll();
                    jTextField.requestFocus();
                    return;
                }
            } else if (jButton == this.bUpdate) {
                this.updateData(this.sizeField);
            }
        } else if (actionEvent.getSource() instanceof JTextField) {
            this.updateData((JTextField)actionEvent.getSource());
        }
        super.actionPerformed(actionEvent);
    }

    JPanel createMainLayout() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = super.createMainLayout();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.sizePanel = new JPanel();
        this.sizePanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Interval Size :", 2);
        this.sizeField = new JTimeTextField(1000L, 12);
        this.sizeField.addActionListener(this);
        this.sizeField.addKeyListener(this);
        this.sizeField.addFocusListener(this);
        long l = this.startTimeField.getValue() / this.sizeField.getValue();
        long l2 = this.endTimeField.getValue() / this.sizeField.getValue();
        this.validIntervalsLabel = new JLabel("Valid Total Number of Intervals : " + this.validIntervals, 2);
        this.numIntervalsLabel = new JLabel("Selected Number of Intervals : " + (l2 - l + 1L), 2);
        this.startIntervalLabel = new JLabel("Start Interval : " + l, 2);
        this.endIntervalLabel = new JLabel("End Interval : " + l2, 2);
        Util.gblAdd(this.sizePanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.sizeField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.numIntervalsLabel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.validIntervalsLabel, gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.startIntervalLabel, gridBagConstraints, 0, 3, 1, 1, 1, 1);
        Util.gblAdd(this.sizePanel, this.endIntervalLabel, gridBagConstraints, 1, 3, 1, 1, 1, 1);
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, this.sizePanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        return jPanel;
    }

    void updateData(JTextField jTextField) {
        if (jTextField instanceof JTimeTextField) {
            long l = this.sizeField.getValue();
            long l2 = this.startTimeField.getValue() / l;
            long l3 = this.endTimeField.getValue() / l;
            if (jTextField == this.sizeField) {
                long l4 = this.totalValidTime / l;
                if (this.totalValidTime % l != 0L) {
                    ++l4;
                }
                this.validIntervalsLabel.setText("Total Valid Number of Intervals : " + l4);
                this.numIntervalsLabel.setText("Selected Number of Intervals : " + (l3 - l2 + 1L));
                this.startIntervalLabel.setText("Start Interval : " + l2);
                this.endIntervalLabel.setText("End Interval : " + l3);
            } else if (jTextField == this.startTimeField) {
                this.startIntervalLabel.setText("Start Interval : " + l2);
                this.numIntervalsLabel.setText("Selected Number of Intervals : " + (l3 - l2 + 1L));
            } else if (jTextField == this.endTimeField) {
                this.endIntervalLabel.setText("End Interval : " + l3);
                this.numIntervalsLabel.setText("Selected Number of Intervals : " + (l3 - l2 + 1L));
            }
        }
        super.updateData(jTextField);
    }

    JTextField checkConsistent() {
        if (this.sizeField.getValue() <= 0L || this.sizeField.getValue() > this.totalTime) {
            return this.sizeField;
        }
        return super.checkConsistent();
    }

    public boolean isModified() {
        return this.intervalSize != this.sizeField.getValue() || super.isModified();
    }

    void setParameters() {
        this.intervalSize = this.sizeField.getValue();
        super.setParameters();
    }

    void updateFields() {
        this.sizeField.setValue(this.intervalSize);
        super.updateFields();
        this.updateDerived();
    }

    void updateDerived() {
        long l = this.sizeField.getValue();
        long l2 = this.startTimeField.getValue() / l;
        long l3 = this.endTimeField.getValue() / l;
        long l4 = this.totalValidTime / l;
        if (this.totalValidTime % l != 0L) {
            ++l4;
        }
        this.validIntervalsLabel.setText("Total Valid Number of Intervals : " + l4);
        this.numIntervalsLabel.setText("Selected Number of Intervals : " + (l3 - l2 + 1L));
        this.startIntervalLabel.setText("Start Interval : " + l2);
        this.endIntervalLabel.setText("End Interval : " + l3);
    }

    public long getIntervalSize() {
        return this.sizeField.getValue();
    }

    public void setIntervalSize(long l) {
        this.intervalSize = l;
    }

    public long getStartInterval() {
        return this.startTimeField.getValue() / this.sizeField.getValue();
    }

    public long getEndInterval() {
        return this.endTimeField.getValue() / this.sizeField.getValue();
    }
}

