/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class IntervalWindow
extends GenericGraphWindow
implements ActionListener,
ItemListener {
    public long thresholdTime;
    public long intervalSize;
    private double[][] dataSource;
    private boolean countSends = true;
    private boolean getNewData = false;
    private final int NO_OF_DATASOURCES = 3;
    private final int STRETCHED_EP = 0;
    private final int SEND_COUNT = 1;
    private final int MSG_LEN_COUNT = 2;

    void windowInit() {
        this.intervalSize = 1000L;
        super.windowInit();
    }

    public IntervalWindow(MainWindow mainWindow, Integer n) {
        super("Projections Interval Graph", mainWindow, n);
        this.setGraphSpecificData();
        this.createMenus();
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        this.showDialog();
        this.setVisible(true);
        this.refreshGraph();
    }

    void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            this.getNewData = true;
            this.refreshGraph();
        }
    }

    protected void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        super.getDialogData();
    }

    protected void showWindow() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText().equals("Set Range")) {
                this.showDialog();
            } else if (jMenuItem.getText().equals("Send Count vs Stretched EntryPoints")) {
                this.countSends = jMenuItem.isSelected();
                this.getNewData = false;
                this.refreshGraph();
            } else if (jMenuItem.getText().equals("Bytes Sent vs Stretched EntryPoints")) {
                this.countSends = !jMenuItem.isSelected();
                this.getNewData = false;
                this.refreshGraph();
            } else if (jMenuItem.getText().equals("Close")) {
                this.close();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JMenuItem jMenuItem = (JMenuItem)itemEvent.getSource();
        String string = "Item event detected. \n   Event source: " + jMenuItem.getText() + "\n    New state: " + (itemEvent.getStateChange() == 1 ? "selected" : "unselected");
        System.out.println(string);
    }

    public String[] getPopup(int n, int n2) {
        return null;
    }

    protected void createMenus() {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Send Count vs Stretched EntryPoints", true);
        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Bytes Sent vs Stretched EntryPoints", false);
        jRadioButtonMenuItem2.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Set Range", "Close"}, null, this));
        jMenuBar.add(Util.makeJMenu("Options", new Object[]{jRadioButtonMenuItem, jRadioButtonMenuItem2}, null, this));
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Time Interval", "");
        this.setYAxis("#", "");
    }

    protected void refreshGraph() {
        if (this.getNewData) {
            this.getNewData();
        }
        if (this.dataSource != null) {
            int n;
            String string;
            if (this.countSends) {
                string = "Stretched EntryPoints vs Send Messages";
                n = 1;
            } else {
                string = "Stretched EntryPoints vs Bytes Sent";
                n = 2;
            }
            double[][] dArray = new double[this.dataSource.length][2];
            for (int i = 0; i < this.dataSource.length; ++i) {
                dArray[i][0] = this.dataSource[i][0];
                dArray[i][1] = this.dataSource[i][n];
            }
            double d = (double)(this.endTime - this.startTime) / (double)(this.dataSource.length - 1);
            this.setXAxis("Time Interval (" + U.t(this.startTime) + " - " + U.t(this.endTime) + ")", "ms", this.startTime / 1000L, d / 1000.0);
            this.setDataSource(string, dArray);
            super.refreshGraph();
        }
    }

    private void getNewData() {
        int n;
        int n2;
        OrderedIntList orderedIntList = this.validPEs.copyOf();
        LogEntryData logEntryData = new LogEntryData();
        LogEntryData logEntryData2 = new LogEntryData();
        int n3 = (int)((this.endTime - this.startTime) / this.intervalSize) + 1;
        this.dataSource = new double[n3][3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 3; ++n) {
                this.dataSource[n2][n] = 0.0;
            }
        }
        block10: while (orderedIntList.hasMoreElements()) {
            n2 = orderedIntList.nextElement();
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n2), Analysis.getVersion());
            try {
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                while (true) {
                    genericLogReader.nextEvent(logEntryData);
                    if (logEntryData.time > this.endTime) continue block10;
                    switch (logEntryData.type) {
                        case 1: {
                            n = (int)((logEntryData.time - this.startTime) / this.intervalSize);
                            double[] dArray = this.dataSource[n];
                            dArray[1] = dArray[1] + 1.0;
                            double[] dArray2 = this.dataSource[n];
                            dArray2[2] = dArray2[2] + (double)logEntryData.msglen;
                            break;
                        }
                        case 2: {
                            logEntryData2 = logEntryData.copyOf();
                            break;
                        }
                        case 3: {
                            long l = logEntryData.time - logEntryData2.time;
                            if (l <= this.thresholdTime) break;
                            n = (int)((logEntryData2.time - this.startTime) / this.intervalSize);
                            double[] dArray = this.dataSource[n];
                            dArray[0] = dArray[0] + 1.0;
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                System.out.println("Exception at IntervalWindow::getData() " + iOException);
            }
        }
    }
}

