/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import javax.swing.JTextField;

public class JFloatTextField
extends JTextField {
    private String lastValue;
    private int lastCaretPosition;

    public JFloatTextField(float f, int n) {
        super("" + f, n);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!('0' <= c && c <= '9' || c == '.' || Character.isISOControl(c))) {
                    keyEvent.consume();
                } else {
                    JFloatTextField.this.lastCaretPosition = JFloatTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + f;
    }

    private void checkValue() {
        try {
            Float.valueOf(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException numberFormatException) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public boolean isValueValid() {
        try {
            Float.valueOf(this.getText().trim() + "0");
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public float getValue() {
        this.checkValue();
        try {
            return Float.valueOf(this.getText().trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return Float.valueOf(this.lastValue).floatValue();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.checkValue();
    }
}

