/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import javax.swing.JTextField;

public class JLongTextField
extends JTextField {
    private String lastValue;
    private int lastCaretPosition;

    public JLongTextField(long l, int n) {
        super("" + l, n);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!('0' <= c && c <= '9' || Character.isISOControl(c))) {
                    keyEvent.consume();
                } else {
                    JLongTextField.this.lastCaretPosition = JLongTextField.this.getCaretPosition();
                }
            }
        });
        this.lastValue = "" + l;
    }

    private void checkValue() {
        try {
            Long.parseLong(this.getText().trim() + "0");
            this.lastValue = this.getText();
        }
        catch (NumberFormatException numberFormatException) {
            this.setText(this.lastValue);
            this.setCaretPosition(this.lastCaretPosition);
        }
    }

    public long getValue() {
        this.checkValue();
        try {
            return Long.parseLong(this.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public void setValue(long l) {
        this.lastValue = this.getText();
        this.setText(String.valueOf(l));
        this.checkValue();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.checkValue();
    }
}

