/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import projections.analysis.ViewerEvent;
import projections.gui.Analysis;
import projections.gui.LogFileViewerDialog;
import projections.gui.LogFileViewerTextArea;
import projections.gui.MainWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.Util;
import projections.misc.LogLoadException;

public class LogFileViewerWindow
extends ProjectionsWindow
implements ActionListener {
    private LogFileViewerDialog dialog;
    private int logfilenum = -1;
    private int oldlogfilenum = -1;
    private LogFileViewerTextArea textArea;
    private Label lTitle;
    private Button bOpen;
    private Button bClose;
    private Panel titlePanel;

    void windowInit() {
    }

    public LogFileViewerWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        this.setBackground(Color.lightGray);
        this.setTitle("Projections Log File Viewer - " + Analysis.getFilename() + ".sts");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            if (menuItem.getLabel().equals("Open File")) {
                this.showDialog();
            } else if (menuItem.getLabel().equals("Close")) {
                this.close();
            }
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bOpen) {
                this.showDialog();
            } else if (button == this.bClose) {
                this.close();
            }
        }
    }

    public void CloseDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
        this.setCursor(new Cursor(3));
        if (this.logfilenum != this.oldlogfilenum) {
            this.textArea.setText(LogFileViewerWindow.getLogFileText(this.logfilenum));
        }
        this.setCursor(new Cursor(0));
    }

    private void CreateLayout() {
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.getContentPane().add(panel);
        this.textArea = new LogFileViewerTextArea();
        panel.setLayout(gridBagLayout);
        this.titlePanel = new Panel();
        this.titlePanel.setBackground(Color.black);
        this.lTitle = new Label("", 1);
        this.lTitle.setForeground(Color.white);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.add(this.lTitle);
        Util.gblAdd(panel, this.titlePanel, gridBagConstraints, 0, 0, 1, 1, 1, 0, 5, 5, 0, 5);
        Util.gblAdd(panel, this.textArea, gridBagConstraints, 0, 1, 1, 1, 1, 1, 0, 5, 5, 5);
        Panel panel2 = new Panel();
        this.bOpen = new Button("Open File");
        this.bClose = new Button("Close Window");
        this.bOpen.addActionListener(this);
        this.bClose.addActionListener(this);
        panel2.add(this.bOpen);
        panel2.add(this.bClose);
        Util.gblAdd(panel, panel2, gridBagConstraints, 0, 2, 1, 1, 1, 0, 0, 5, 5, 5);
    }

    private void CreateMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Open File", null, "Close"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"Index", "About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public void setLogFileNum(int n) {
        this.logfilenum = n;
        this.lTitle.setText("LOG FILE FOR PROCESSOR " + n);
        this.lTitle.invalidate();
        this.titlePanel.validate();
    }

    public void showDialog() {
        this.oldlogfilenum = this.logfilenum;
        if (this.dialog == null) {
            this.dialog = new LogFileViewerDialog(this);
        }
        this.dialog.setVisible(true);
    }

    public static String[][] getLogFileText(int n) {
        if (!Analysis.hasLogData()) {
            return null;
        }
        Vector vector = null;
        try {
            vector = Analysis.logLoader.view(n);
        }
        catch (LogLoadException logLoadException) {
            System.err.println("Failed to load Log files");
            return null;
        }
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        String[][] stringArray = new String[n2][2];
        block14: for (int i = 0; i < n2; ++i) {
            ViewerEvent viewerEvent = (ViewerEvent)vector.elementAt(i);
            stringArray[i][0] = "" + viewerEvent.Time;
            switch (viewerEvent.EventType) {
                case 1: {
                    stringArray[i][1] = "CREATE message to be sent to " + viewerEvent.Dest;
                    continue block14;
                }
                case 2: {
                    stringArray[i][1] = "BEGIN PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray2 = stringArray[i];
                    stringArray2[1] = stringArray2[1] + " from processor " + viewerEvent.SrcPe;
                    continue block14;
                }
                case 3: {
                    stringArray[i][1] = "END PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray3 = stringArray[i];
                    stringArray3[1] = stringArray3[1] + " from processor " + viewerEvent.SrcPe;
                    continue block14;
                }
                case 4: {
                    stringArray[i][1] = "ENQUEUEING message received from processor " + viewerEvent.SrcPe + " destined for " + viewerEvent.Dest;
                    continue block14;
                }
                case 14: {
                    stringArray[i][1] = "IDLE begin";
                    continue block14;
                }
                case 15: {
                    stringArray[i][1] = "IDLE end";
                    continue block14;
                }
                case 16: {
                    stringArray[i][1] = "BEGIN PACKING a message to be sent";
                    continue block14;
                }
                case 17: {
                    stringArray[i][1] = "FINISHED PACKING a message to be sent";
                    continue block14;
                }
                case 18: {
                    stringArray[i][1] = "BEGIN UNPACKING a received message";
                    continue block14;
                }
                case 19: {
                    stringArray[i][1] = "FINISHED UNPACKING a received message";
                    continue block14;
                }
                default: {
                    stringArray[i][1] = "!!!! ADD EVENT TYPE " + viewerEvent.EventType + " !!!";
                }
            }
        }
        return stringArray;
    }

    public void showWindow() {
    }

    public void getDialogData() {
    }
}

