/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import projections.analysis.IntervalUtils;
import projections.analysis.ProjMain;
import projections.gui.Analysis;
import projections.gui.BackGroundImagePanel;
import projections.gui.GraphWindow;
import projections.gui.InvalidFileDialog;
import projections.gui.MainFileFilter;
import projections.gui.MainMenuManager;
import projections.gui.MainRunStatusPanel;
import projections.gui.MainSummaryGraphPanel;
import projections.gui.MainTitlePanel;
import projections.gui.ProjectionsWindow;
import projections.gui.ScalePanel;
import projections.gui.ScaleSlider;
import projections.gui.ScreenInfo;
import projections.gui.StlPanel;
import projections.gui.SwingWorker;
import projections.gui.TimelineWindow;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.SummaryDataSource;
import projections.gui.graph.SummaryXAxis;
import projections.gui.graph.SummaryYAxis;

public class MainWindow
extends JFrame
implements ScalePanel.StatusDisplay {
    protected static final int NUM_WINDOWS = 17;
    protected static final int GRAPH_WIN = 0;
    protected static final int TIMELINE_WIN = 1;
    protected static final int PROFILE_WIN = 2;
    protected static final int COMM_WIN = 3;
    protected static final int COMM_TIME_WIN = 4;
    protected static final int CALL_TABLE_WIN = 5;
    protected static final int LOGVIEW_WIN = 6;
    protected static final int HIST_WIN = 7;
    protected static final int OVERVIEW_WIN = 8;
    protected static final int ANIMATION_WIN = 9;
    protected static final int TIME_PROF_WIN = 10;
    protected static final int USER_EVENTS_WIN = 11;
    protected static final int OUTLIER_WIN = 12;
    protected static final int MULTI_WIN = 13;
    protected static final int FUNCTION_WIN = 14;
    protected static final int POSE_WIN = 15;
    protected static final int AMPI_PROFILE_WIN = 16;
    public static final String[] windowMenuNames = new String[]{"Graphs", "Timelines", "Usage Profile", "Communication", "Communication vs Time", "Call Table", "View Log Files", "Histograms", "Overview", "Animation", "Time Profile Graph", "User Events", "Outlier Analysis", "Multirun Analysis", "Function Tool", "POSE Analysis", "AMPI Usage Profile"};
    public static final String[] windowClassNames = new String[]{"GraphWindow", "TimelineWindow", "ProfileWindow", "CommWindow", "CommTimeWindow", "CallTableWindow", "LogFileViewerWindow", "HistogramWindow", "StlWindow", "AnimationWindow", "TimeProfileWindow", "UserEventsWindow", "OutlierAnalysisWindow", "MultiRunWindow", "FunctionTool", "PoseAnalysisWindow", "AmpiProfileWindow"};
    public static final boolean[][] menuDataStates = new boolean[][]{new boolean[0], new boolean[0]};
    private static final int DEFAULT_NUM_RUNS = 1;
    public static double CUR_VERSION;
    public static boolean IGNORE_IDLE;
    public static boolean BLUEGENE;
    public static int[] BLUEGENE_SIZE;
    public static boolean PRINT_USAGE;
    public static PrintWriter dataDump;
    private MainWindow thisWindow = this;
    protected JFrame[][] childWindows;
    private GraphWindow graphWindow;
    private MainTitlePanel titlePanel;
    private BackGroundImagePanel background;
    private MainMenuManager menuManager;
    private MainSummaryGraphPanel summaryGraphPanel;
    private MainRunStatusPanel runStatusPanel;
    private SummaryDataSource sumDataSource;
    private SummaryXAxis sumXAxis;
    private SummaryYAxis sumYAxis;
    private GraphPanel graphPanel;
    private ScalePanel scalePanel;
    private StlPanel stl;
    private ScaleSlider hor;
    private ScaleSlider ver;
    private Label status;
    private ScalePanel.StatusDisplay sd;
    private Image bgimage;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;

    public MainWindow() {
        CUR_VERSION = ProjMain.CUR_VERSION;
        IGNORE_IDLE = ProjMain.IGNORE_IDLE;
        BLUEGENE = ProjMain.BLUEGENE;
        BLUEGENE_SIZE = ProjMain.BLUEGENE_SIZE;
        PRINT_USAGE = ProjMain.PRINT_USAGE;
        ScreenInfo.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProjMain.shutdown(0);
            }
        });
        this.setBackground(Color.lightGray);
        this.childWindows = new JFrame[17][1];
        this.menuManager = new MainMenuManager(this);
        this.createLayout();
    }

    private void createLayout() {
        try {
            URL uRL = this.getClass().getResource("/projections/images/bgimage");
            this.bgimage = Toolkit.getDefaultToolkit().getImage(uRL);
            this.background = new BackGroundImagePanel(this.bgimage, true);
        }
        catch (Exception exception) {
            System.out.println("Error loading background image.  Continuing.");
            this.background = new BackGroundImagePanel(null);
        }
        this.setContentPane(this.background);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.background.setLayout(this.gbl);
        this.titlePanel = new MainTitlePanel(this);
        this.runStatusPanel = new MainRunStatusPanel();
        this.summaryGraphPanel = new MainSummaryGraphPanel(this, this.runStatusPanel);
        Util.gblAdd(this.background, this.titlePanel, this.gbc, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0);
        Util.gblAdd(this.background, this.runStatusPanel, this.gbc, 0, 1, 1, 1, 1, 0, 0, 20, 0, 20);
        Util.gblAdd(this.background, this.summaryGraphPanel, this.gbc, 0, 2, 1, 1, 1, 1, 0, 20, 20, 20);
        this.background.setPreferredSize(new Dimension(ScreenInfo.screenWidth, ScreenInfo.screenHeight));
        this.pack();
    }

    public void changeBackground() {
        JColorChooser jColorChooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Background Color", Analysis.background);
        if (color != null) {
            Analysis.background = color;
            this.repaintAllWindows();
        }
    }

    public void changeForeground() {
        JColorChooser jColorChooser = new JColorChooser();
        Color color = JColorChooser.showDialog(this, "Foreground Color", Analysis.foreground);
        if (color != null) {
            Analysis.foreground = color;
            this.repaintAllWindows();
        }
    }

    public void setGrayscale() {
        Analysis.setGrayscale();
        this.repaintAllWindows();
    }

    public void setFullColor() {
        Analysis.setFullColor();
        this.repaintAllWindows();
    }

    private void repaintAllWindows() {
        for (int i = 0; i < 17; ++i) {
            if (this.childWindows[i][0] == null) continue;
            if (this.childWindows[i][0] instanceof GraphWindow) {
                ((GraphWindow)this.childWindows[i][0]).refreshDisplay();
                continue;
            }
            if (this.childWindows[i][0] instanceof TimelineWindow) {
                ((TimelineWindow)this.childWindows[i][0]).refreshDisplay();
                continue;
            }
            this.childWindows[i][0].repaint();
        }
        this.repaint();
    }

    public void showChildWindow(String string, int n) {
        try {
            if (this.childWindows[n][0] == null) {
                String string2 = this.getClass().getPackage().getName() + "." + string;
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(this.getClass(), Class.forName("java.lang.Integer"));
                this.childWindows[n][0] = (ProjectionsWindow)constructor.newInstance(this, new Integer(n));
            } else if (this.childWindows[n][0] instanceof ProjectionsWindow) {
                ((ProjectionsWindow)this.childWindows[n][0]).showDialog();
            } else {
                this.childWindows[n][0].show();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showOpenFileDialog() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(new MainFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.setTitle("Projections -" + jFileChooser.getSelectedFile());
            this.openFile(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void openFile(String string) {
        final String string2 = string;
        this.sumDataSource = null;
        this.sumXAxis = null;
        this.sumYAxis = null;
        this.graphPanel = null;
        this.hor = null;
        this.ver = null;
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Analysis.initAnalysis(string2, MainWindow.this.thisWindow);
                }
                catch (IOException iOException) {
                    InvalidFileDialog invalidFileDialog = new InvalidFileDialog(MainWindow.this.thisWindow);
                    invalidFileDialog.setVisible(true);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    stringIndexOutOfBoundsException.printStackTrace();
                    InvalidFileDialog invalidFileDialog = new InvalidFileDialog(MainWindow.this.thisWindow);
                    invalidFileDialog.setVisible(true);
                }
                if (Analysis.hasSummaryData() || Analysis.hasLogData()) {
                    // empty if block
                }
                return null;
            }

            public void finished() {
                MainWindow.this.setTitle("Projections - " + string2);
                if (Analysis.hasSummaryData()) {
                    Analysis.loadSummaryData();
                    double[] dArray = Analysis.getSummaryAverageData();
                    long l = Analysis.getSummaryIntervalSize();
                    long l2 = (long)IntervalUtils.getBestIntervalSize(l, dArray.length);
                    if (l2 != l) {
                        IntervalUtils.utilToTime(dArray, (double)l);
                        double[] dArray2 = IntervalUtils.rebin(dArray, (double)l, l2);
                        IntervalUtils.timeToUtil(dArray2, (double)l2);
                        try {
                            dataDump = new PrintWriter(new FileWriter(Analysis.getLogDirectory() + File.separator + "SummaryDump.out"));
                            dataDump.println("--- Summary Graph ---");
                            for (int i = 0; i < dArray2.length; ++i) {
                                dataDump.println(dArray2[i]);
                            }
                            dataDump.flush();
                        }
                        catch (IOException iOException) {
                            System.err.println("WARNING: Failed to handle dump file SummaryDump.out. Reason: ");
                            System.err.println(iOException);
                        }
                        MainWindow.this.sumDataSource = new SummaryDataSource(dArray2);
                        MainWindow.this.sumXAxis = new SummaryXAxis(dArray2.length, l2);
                    } else {
                        MainWindow.this.sumDataSource = new SummaryDataSource(dArray);
                        MainWindow.this.sumXAxis = new SummaryXAxis(dArray.length, Analysis.getSummaryIntervalSize());
                    }
                    MainWindow.this.sumYAxis = new SummaryYAxis();
                    MainWindow.this.graphPanel = new GraphPanel(new Graph(MainWindow.this.sumDataSource, MainWindow.this.sumXAxis, MainWindow.this.sumYAxis));
                    MainWindow.this.summaryGraphPanel.add("data", MainWindow.this.graphPanel, "run data");
                }
                if (Analysis.hasLogData()) {
                    MainWindow.this.menuManager.fileOpened();
                } else if (Analysis.hasSummaryData()) {
                    MainWindow.this.menuManager.summaryOnly();
                }
                if (Analysis.hasPoseDopData()) {
                    MainWindow.this.menuManager.addPose();
                }
            }
        };
        swingWorker.start();
    }

    public void closeChildWindow(int n) {
        this.childWindows[n][0] = null;
    }

    public void shutdown() {
        Analysis.closeRC();
    }

    public void closeCurrent() {
        this.closeAll();
    }

    public void closeAll() {
        this.summaryGraphPanel.removeAll();
        this.menuManager.lastFileClosed();
        Analysis.closeRC();
        this.setTitle("Projections");
    }

    public Color getGraphColor(int n) {
        if (this.graphWindow != null) {
            return this.graphWindow.getGraphColor(n);
        }
        return null;
    }

    public boolean GraphExists() {
        return this.graphWindow != null;
    }

    public void setStatus(String string) {
        this.status.setText(string);
    }

    static {
        dataDump = null;
    }
}

