/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextField;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import projections.gui.MultiRunWindow;
import projections.gui.Util;
import projections.misc.MultiRunData;

public class MultiRunControlPanel
extends JPanel {
    private ButtonGroup dataTypeModes;
    private JPanel dataTypePanel;
    private JRadioButton[] dataTypeButtons;
    private JButton displayTable;
    private JButton done;
    private Label cmdLineLabel;
    private TextField cmdLine;
    private MultiRunWindow mainWindow;

    public MultiRunControlPanel(MultiRunWindow multiRunWindow, int n) {
        this.mainWindow = multiRunWindow;
        this.setBackground(Color.lightGray);
        this.dataTypeModes = new ButtonGroup();
        this.dataTypePanel = new JPanel();
        this.dataTypeButtons = new JRadioButton[4];
        for (int i = 0; i < 4; ++i) {
            this.dataTypeButtons[i] = new JRadioButton(MultiRunData.getTypeName(i), i == n);
            this.dataTypeButtons[i].addItemListener(multiRunWindow);
            this.dataTypeModes.add(this.dataTypeButtons[i]);
            this.dataTypePanel.add(this.dataTypeButtons[i]);
        }
        this.dataTypePanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.displayTable = new JButton("Display Tables");
        this.displayTable.addActionListener(multiRunWindow);
        this.done = new JButton("Close Window");
        this.done.addActionListener(multiRunWindow);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        Util.gblAdd(this, this.dataTypePanel, gridBagConstraints, 0, 0, 1, 2, 1, 0, 1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        Util.gblAdd(this, this.displayTable, gridBagConstraints, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this, this.done, gridBagConstraints, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1);
    }

    public int getSelectedIdx(ItemSelectable itemSelectable) {
        JRadioButton jRadioButton = (JRadioButton)itemSelectable;
        for (int i = 0; i < 4; ++i) {
            if (jRadioButton != this.dataTypeButtons[i]) continue;
            return i;
        }
        return -1;
    }
}

