/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

public class OrderedIntList {
    private Link head;
    private Link tail;
    private Link pre;
    private int len;

    public boolean isEmpty() {
        return this.len == 0;
    }

    public OrderedIntList copyOf() {
        int n;
        OrderedIntList orderedIntList = new OrderedIntList();
        this.reset();
        while ((n = this.nextElement()) != -1) {
            orderedIntList.insert(n);
        }
        orderedIntList.reset();
        return orderedIntList;
    }

    public static OrderedIntList union(OrderedIntList orderedIntList, OrderedIntList orderedIntList2) {
        OrderedIntList orderedIntList3;
        OrderedIntList orderedIntList4;
        if (orderedIntList.size() <= orderedIntList2.size()) {
            orderedIntList4 = orderedIntList;
            orderedIntList3 = orderedIntList2;
        } else {
            orderedIntList4 = orderedIntList2;
            orderedIntList3 = orderedIntList;
        }
        OrderedIntList orderedIntList5 = orderedIntList3.copyOf();
        orderedIntList4.reset();
        while (orderedIntList4.hasMoreElements()) {
            orderedIntList5.insert(orderedIntList4.nextElement());
        }
        orderedIntList5.reset();
        return orderedIntList5;
    }

    public int currentElement() {
        Link link = this.nextLink();
        if (link == null) {
            return -1;
        }
        return link.data;
    }

    public boolean equals(OrderedIntList orderedIntList) {
        int n;
        if (orderedIntList == null) {
            return false;
        }
        if (this.size() != orderedIntList.size()) {
            return false;
        }
        this.reset();
        orderedIntList.reset();
        while ((n = this.nextElement()) != -1) {
            if (orderedIntList.nextElement() == n) continue;
            return false;
        }
        return true;
    }

    public boolean hasMoreElements() {
        return this.nextLink() != null;
    }

    public boolean contains(OrderedIntList orderedIntList) {
        int n;
        if (orderedIntList == null) {
            return true;
        }
        if (orderedIntList.size() > this.size()) {
            return false;
        }
        this.reset();
        orderedIntList.reset();
        while ((n = orderedIntList.nextElement()) != -1) {
            int n2;
            while (n != (n2 = this.nextElement())) {
                if (n2 != -1) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(int n) {
        int n2;
        this.reset();
        while ((n2 = this.nextElement()) != -1) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public void remove(int n) {
        this.reset();
        Link link = this.nextLink();
        while (link != null && link.data < n) {
            this.pre = link;
            link = this.nextLink();
        }
        if (link != null && link.data == n) {
            if (this.pre == null) {
                this.head = link.next;
            } else {
                this.pre.next = link.next;
            }
        }
    }

    public void insert(int n) {
        this.reset();
        Link link = this.nextLink();
        while (link != null && link.data < n) {
            this.pre = link;
            link = this.nextLink();
        }
        if (link == null) {
            Link link2 = new Link(n, link);
            if (this.head == null) {
                this.head = link2;
                this.tail = link2;
            } else {
                this.pre.next = link2;
                this.tail = link2;
            }
            ++this.len;
        } else if (link.data != n) {
            Link link3 = new Link(n, link);
            if (this.head == link) {
                this.head = link3;
            } else {
                this.pre.next = link3;
            }
            ++this.len;
        }
    }

    public String listToString() {
        this.reset();
        int n = this.nextElement();
        String string = "";
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        while (n != -1) {
            if (n4 == -1) {
                n4 = n;
                n = this.nextElement();
                continue;
            }
            if (n2 == -1) {
                n2 = n - n4;
                n3 = n;
                n = this.nextElement();
                continue;
            }
            while (n - n3 == n2) {
                n3 = n;
                n = this.nextElement();
            }
            if (n3 == n4 + n2) {
                if (!string.equals("")) {
                    string = string + ",";
                }
                string = string + new String("" + n4);
                n4 = n3;
                n2 = -1;
                continue;
            }
            if (!string.equals("")) {
                string = string + ",";
            }
            string = string + new String("" + n4 + "-" + n3);
            if (n2 > 1) {
                string = string + new String(":" + n2);
            }
            n3 = -1;
            n2 = -1;
            n4 = -1;
        }
        if (n4 != -1) {
            if (!string.equals("")) {
                string = string + ",";
            }
            string = string + new String("" + n4);
        }
        if (n3 != -1) {
            if (!string.equals("")) {
                string = string + ",";
            }
            string = string + new String("" + n3);
        }
        return string;
    }

    public int nextElement() {
        this.pre = this.pre == null ? this.head : this.pre.next;
        if (this.pre == null) {
            return -1;
        }
        return this.pre.data;
    }

    private Link nextLink() {
        if (this.pre == null) {
            return this.head;
        }
        return this.pre.next;
    }

    public void printList() {
        this.reset();
        while (this.hasMoreElements()) {
            System.out.println("" + this.nextElement());
        }
        this.reset();
    }

    public void removeAll() {
        this.len = 0;
        this.head = null;
        this.tail = null;
        this.pre = null;
    }

    public void reset() {
        this.pre = null;
    }

    public int size() {
        return this.len;
    }

    class Link {
        int data;
        Link next;

        Link(int n, Link link) {
            this.data = n;
            this.next = link;
        }
    }
}

