/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.analysis.ProjectionsConfigurationReader;
import projections.gui.Analysis;
import projections.gui.Clickable;
import projections.gui.ColorSelectable;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OutlierDialog;
import projections.gui.SwingWorker;
import projections.gui.TimelineWindow;
import projections.gui.U;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class OutlierAnalysisWindow
extends GenericGraphWindow
implements ActionListener,
ItemListener,
ColorSelectable,
Clickable {
    private OutlierAnalysisWindow thisWindow;
    private JPanel mainPanel;
    private int threshold;
    private int currentActivity;
    private int currentAttribute;
    public String[][] attributes = new String[][]{{"Execution Time by Activity", "Idle Time", "Msgs Sent by Activity", "Bytes Sent by Activity"}, {"Execution Time (us)", "Time (us)", "Number of Messages", "Number of Bytes"}, {"us", "us", "", ""}};
    LinkedList outlierList;
    private int numActivities;
    private int numSpecials;
    private double[][] graphData;
    private Color[] graphColors;
    private OrderedIntList outlierPEs;
    DecimalFormat df = new DecimalFormat();

    public OutlierAnalysisWindow(MainWindow mainWindow, Integer n) {
        super("Projections Outlier Analysis Tool - " + Analysis.getFilename() + ".sts", mainWindow, n);
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        if (ProjectionsConfigurationReader.RC_OUTLIER_FILTERED.booleanValue()) {
            this.currentActivity = 0;
            this.currentAttribute = 0;
            this.validPEs = Analysis.getValidProcessorList(0);
            this.outlierPEs = new OrderedIntList();
            this.startTime = 0L;
            this.endTime = Analysis.getTotalTime();
            this.threshold = Analysis.getNumProcessors() <= 256 ? (int)Math.ceil(0.1 * (double)Analysis.getNumProcessors()) : 20;
            this.loadOnlineData();
        } else {
            this.showDialog();
        }
    }

    private void createLayout() {
        this.mainPanel = this.getMainPanel();
        this.getContentPane().add(this.mainPanel);
    }

    protected void createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        jMenuBar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        jMenuBar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(jMenuBar);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new OutlierDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            if (this.dialog.isModified()) {
                this.thisWindow.setVisible(false);
                this.loadData();
            }
        }
    }

    public void getDialogData() {
        OutlierDialog outlierDialog = (OutlierDialog)this.dialog;
        this.threshold = outlierDialog.threshold;
        this.currentActivity = outlierDialog.currentActivity;
        this.currentAttribute = outlierDialog.currentAttribute;
        super.getDialogData();
    }

    private void loadData() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                OutlierAnalysisWindow.this.constructToolData();
                return null;
            }

            public void finished() {
                OutlierAnalysisWindow.this.setGraphSpecificData();
                OutlierAnalysisWindow.this.thisWindow.setVisible(true);
            }
        };
        swingWorker.start();
    }

    private void constructToolData() {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        int n4;
        this.numActivities = Analysis.getNumActivity(this.currentActivity);
        Color[] colorArray = Analysis.getColorMap(this.currentActivity);
        this.numSpecials = 0;
        if (this.currentAttribute <= 1) {
            this.numSpecials = 1;
            this.graphColors = new Color[this.numActivities + this.numSpecials];
            for (n4 = 0; n4 < this.numActivities; ++n4) {
                this.graphColors[n4] = colorArray[n4];
            }
            this.graphColors[this.numActivities] = Color.white;
        } else {
            this.graphColors = colorArray;
        }
        double[][] dArray = new double[this.validPEs.size()][this.numActivities + this.numSpecials];
        n4 = 0;
        int n5 = 0;
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading log files", "", 0, this.validPEs.size());
        progressMonitor.setNote("Reading");
        progressMonitor.setProgress(0);
        this.validPEs.reset();
        while (this.validPEs.hasMoreElements()) {
            n4 = this.validPEs.nextElement();
            progressMonitor.setProgress(n5);
            progressMonitor.setNote("[PE: " + n4 + " ] Reading Data.");
            if (progressMonitor.isCanceled()) {
                return;
            }
            object3 = new GenericLogReader(n4, Analysis.getVersion());
            try {
                int n6;
                if (this.currentActivity == 1) {
                    object2 = new LogEntryData();
                    object = new LogEntryData();
                    object2.time = 0L;
                    while (object2.time < this.startTime) {
                        ((GenericLogReader)object3).nextEventOfType(100, (LogEntryData)object2);
                        ((GenericLogReader)object3).nextEventOfType(100, (LogEntryData)object);
                    }
                    n6 = 0;
                    do {
                        n6 = Analysis.getUserDefinedEventIndex(object2.userEventID);
                        double[] dArray2 = dArray[n5];
                        int n7 = n6;
                        dArray2[n7] = dArray2[n7] + (double)(object.time - object2.time);
                        ((GenericLogReader)object3).nextEventOfType(100, (LogEntryData)object2);
                        ((GenericLogReader)object3).nextEventOfType(100, (LogEntryData)object);
                    } while (object.time <= this.endTime);
                } else {
                    LogEntryData logEntryData;
                    object2 = new LogEntryData();
                    object2.time = 0L;
                    boolean bl = true;
                    n6 = 0;
                    n3 = 0;
                    long l = this.startTime;
                    ((GenericLogReader)object3).nextEventOnOrAfter(this.startTime, (LogEntryData)object2);
                    while (object2.time <= this.endTime) {
                        logEntryData = ((GenericLogReader)object3).getLastBE();
                        switch (object2.type) {
                            case 1: {
                                if (bl && logEntryData != null && logEntryData.type == 2) {
                                    l = this.startTime;
                                    n6 = 1;
                                }
                                if (n6 == 0) break;
                                n2 = object2.entry;
                                if (this.currentAttribute == 2) {
                                    double[] dArray3 = dArray[n5];
                                    int n8 = n2;
                                    dArray3[n8] = dArray3[n8] + 1.0;
                                    break;
                                }
                                if (this.currentAttribute != 3) break;
                                double[] dArray4 = dArray[n5];
                                int n9 = n2;
                                dArray4[n9] = dArray4[n9] + (double)object2.msglen;
                                break;
                            }
                            case 2: {
                                bl = false;
                                if (n6 == 0) {
                                    n6 = 1;
                                }
                                if (this.currentAttribute > 1) break;
                                l = object2.time;
                                break;
                            }
                            case 3: {
                                if (bl) {
                                    n6 = 1;
                                    l = this.startTime;
                                }
                                bl = false;
                                if (n6 == 0) break;
                                n6 = 0;
                                if (this.currentAttribute > 1) break;
                                double[] dArray5 = dArray[n5];
                                int n10 = object2.entry;
                                dArray5[n10] = dArray5[n10] + (double)(object2.time - l);
                                break;
                            }
                            case 14: {
                                bl = false;
                                if (n3 == 0) {
                                    n3 = 1;
                                }
                                if (this.currentAttribute > 1) break;
                                l = object2.time;
                                break;
                            }
                            case 15: {
                                if (bl) {
                                    n3 = 1;
                                    l = this.startTime;
                                }
                                if (n3 == 0) break;
                                n3 = 0;
                                if (this.currentAttribute > 1) break;
                                double[] dArray6 = dArray[n5];
                                int n11 = this.numActivities;
                                dArray6[n11] = dArray6[n11] + (double)(object2.time - l);
                            }
                        }
                        ((GenericLogReader)object3).nextEvent((LogEntryData)object2);
                    }
                    logEntryData = ((GenericLogReader)object3).getLastBE();
                    block9 : switch (object2.type) {
                        case 3: {
                            if (this.currentAttribute > 1) break;
                            double[] dArray7 = dArray[n5];
                            int n12 = object2.entry;
                            dArray7[n12] = dArray7[n12] + (double)(this.endTime - l);
                            break;
                        }
                        case 15: {
                            if (this.currentAttribute > 1) break;
                            double[] dArray8 = dArray[n5];
                            int n13 = this.numActivities;
                            dArray8[n13] = dArray8[n13] + (double)(this.endTime - l);
                            break;
                        }
                        default: {
                            if (logEntryData == null) break;
                            l = logEntryData.time > this.startTime ? logEntryData.time : this.startTime;
                            switch (logEntryData.type) {
                                case 2: {
                                    if (this.currentAttribute > 1) break block9;
                                    double[] dArray9 = dArray[n5];
                                    int n14 = logEntryData.entry;
                                    dArray9[n14] = dArray9[n14] + (double)(this.endTime - l);
                                    break block9;
                                }
                                case 14: {
                                    if (this.currentAttribute != 1) break block9;
                                    double[] dArray10 = dArray[n5];
                                    int n15 = this.numActivities;
                                    dArray10[n15] = dArray10[n15] + (double)(this.endTime - l);
                                }
                            }
                        }
                    }
                    ((GenericLogReader)object3).close();
                }
            }
            catch (EOFException eOFException) {
                try {
                    ((GenericLogReader)object3).close();
                }
                catch (IOException iOException) {
                    System.err.println("Outlier Analysis: Error in closing file for processor " + n4);
                    System.err.println(iOException);
                }
            }
            catch (IOException iOException) {
                System.err.println("Outlier Analysis: Error in reading log data for processor " + n4);
                System.err.println(iOException);
            }
            ++n5;
        }
        progressMonitor.close();
        object3 = new double[this.numActivities + this.numSpecials];
        object2 = new double[this.validPEs.size()];
        object = new int[this.validPEs.size()];
        String[] stringArray = new String[this.validPEs.size()];
        this.validPEs.reset();
        for (n3 = 0; n3 < this.validPEs.size(); ++n3) {
            object[n3] = n3;
            stringArray[n3] = Integer.toString(this.validPEs.nextElement());
        }
        n3 = 0;
        while (n3 < this.numActivities + this.numSpecials) {
            for (int i = 0; i < this.validPEs.size(); ++i) {
                Object object4 = object3;
                int n16 = n3;
                object4[n16] = object4[n16] + dArray[i][n3];
            }
            Object object5 = object3;
            int n17 = n3++;
            object5[n17] = object5[n17] / (double)this.validPEs.size();
        }
        for (n3 = 0; n3 < this.validPEs.size(); ++n3) {
            if (this.currentAttribute == 1) {
                int n18 = n3;
                object2[n18] = object2[n18] - dArray[n3][this.numActivities];
                continue;
            }
            for (int i = 0; i < this.numActivities; ++i) {
                int n19 = n3;
                object2[n19] = object2[n19] + Math.abs(dArray[n3][i] - object3[i]) * object3[i];
            }
        }
        for (n3 = this.validPEs.size() - 1; n3 > 0; --n3) {
            for (int i = 0; i < n3; ++i) {
                if (!(object2[i + 1] < object2[i])) continue;
                double d = object2[i + 1];
                object2[i + 1] = object2[i];
                object2[i] = d;
                n2 = object[i + 1];
                object[i + 1] = object[i];
                object[i] = n2;
            }
        }
        n3 = this.validPEs.size() - this.threshold;
        this.graphData = new double[this.threshold + 3][this.numActivities + this.numSpecials];
        this.outlierList = new LinkedList();
        for (n = 0; n < this.threshold; ++n) {
            for (int i = 0; i < this.numActivities + this.numSpecials; ++i) {
                this.graphData[n + 3][i] = dArray[object[n + n3]][i];
            }
            this.outlierList.add(stringArray[object[n + n3]]);
        }
        this.graphData[0] = (double[])object3;
        for (n = 0; n < this.numActivities + this.numSpecials; ++n) {
            int n20;
            for (n20 = 0; n20 < n3; ++n20) {
                double[] dArray11 = this.graphData[1];
                int n21 = n;
                dArray11[n21] = dArray11[n21] + dArray[object[n20]][n];
            }
            if (n3 != 0) {
                double[] dArray12 = this.graphData[1];
                int n22 = n;
                dArray12[n22] = dArray12[n22] / (double)n3;
            }
            for (n20 = n3; n20 < this.validPEs.size(); ++n20) {
                double[] dArray13 = this.graphData[2];
                int n23 = n;
                dArray13[n23] = dArray13[n23] + dArray[object[n20]][n];
            }
            if (this.threshold == 0) continue;
            double[] dArray14 = this.graphData[2];
            int n24 = n;
            dArray14[n24] = dArray14[n24] / (double)this.threshold;
        }
        this.outlierList.addFirst("Out.");
        this.outlierList.addFirst("Non.");
        this.outlierList.addFirst("Avg");
    }

    private void loadOnlineData() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                OutlierAnalysisWindow.this.readOutlierStats();
                return null;
            }

            public void finished() {
                OutlierAnalysisWindow.this.setGraphSpecificData();
                OutlierAnalysisWindow.this.thisWindow.setVisible(true);
            }
        };
        swingWorker.start();
    }

    private void readOutlierStats() {
        this.numActivities = Analysis.getNumActivity(this.currentActivity);
        Color[] colorArray = Analysis.getColorMap(this.currentActivity);
        this.numSpecials = 1;
        this.graphColors = new Color[this.numActivities + this.numSpecials];
        for (int i = 0; i < this.numActivities; ++i) {
            this.graphColors[i] = colorArray[i];
        }
        this.graphColors[this.numActivities] = Color.white;
        this.graphData = new double[this.threshold + 3][this.numActivities + this.numSpecials];
        String string = Analysis.getLogDirectory() + File.separator + Analysis.getFilename() + ".outlier";
        try {
            int n;
            int n2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            for (n2 = 0; n2 < this.numActivities + this.numSpecials; ++n2) {
                this.graphData[0][n2] = Double.parseDouble(stringTokenizer.nextToken());
            }
            string2 = bufferedReader.readLine();
            stringTokenizer = new StringTokenizer(string2);
            n2 = 0;
            if (this.validPEs.size() > this.threshold) {
                n2 = this.validPEs.size() - this.threshold;
            }
            int n3 = 0;
            ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading log files", "", 0, this.threshold);
            progressMonitor.setNote("Reading");
            progressMonitor.setProgress(0);
            for (n = 0; n < n2; ++n) {
                stringTokenizer.nextToken();
            }
            this.outlierList = new LinkedList();
            this.outlierList.add("Avg");
            this.outlierList.add("Non.");
            this.outlierList.add("Out.");
            for (n = 0; n < this.threshold; ++n) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                this.outlierList.add(n3 + "");
                progressMonitor.setProgress(n);
                progressMonitor.setNote("[PE: " + n3 + " ] Reading Data. (" + n + " of " + this.threshold + ")");
                if (progressMonitor.isCanceled()) {
                    return;
                }
                this.readOnlineOutlierProcessor(n3, n + 3);
            }
            progressMonitor.close();
        }
        catch (IOException iOException) {
            System.err.println("Error: Projections failed to read outlier data file [" + string + "].");
            System.err.println(iOException.toString());
            System.exit(-1);
        }
        int n = 0;
        while (n < this.numActivities + this.numSpecials) {
            for (int i = 0; i < this.threshold; ++i) {
                double[] dArray = this.graphData[2];
                int n4 = n;
                dArray[n4] = dArray[n4] + this.graphData[i + 3][n];
            }
            this.graphData[1][n] = this.graphData[0][n] * (double)Analysis.getNumProcessors() - this.graphData[2][n];
            double[] dArray = this.graphData[1];
            int n5 = n;
            dArray[n5] = dArray[n5] / (double)(Analysis.getNumProcessors() - this.threshold);
            double[] dArray2 = this.graphData[2];
            int n6 = n++;
            dArray2[n6] = dArray2[n6] / (double)this.threshold;
        }
    }

    private void readOnlineOutlierProcessor(int n, int n2) {
        GenericLogReader genericLogReader = new GenericLogReader(n, Analysis.getVersion());
        try {
            LogEntryData logEntryData = new LogEntryData();
            logEntryData.time = 0L;
            boolean bl = false;
            boolean bl2 = false;
            long l = 0L;
            genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
            while (logEntryData.time <= this.endTime) {
                if (logEntryData.type == 2) {
                    if (!bl) {
                        bl = true;
                    }
                    l = logEntryData.time;
                } else if (logEntryData.type == 3) {
                    if (bl) {
                        bl = false;
                        double[] dArray = this.graphData[n2];
                        int n3 = logEntryData.entry;
                        dArray[n3] = dArray[n3] + (double)(logEntryData.time - l);
                    }
                } else if (logEntryData.type == 14) {
                    if (!bl2) {
                        bl2 = true;
                    }
                    l = logEntryData.time;
                } else if (logEntryData.type == 15 && bl2) {
                    bl2 = false;
                    double[] dArray = this.graphData[n2];
                    int n4 = this.numActivities;
                    dArray[n4] = dArray[n4] + (double)(logEntryData.time - l);
                }
                genericLogReader.nextEvent(logEntryData);
            }
            genericLogReader.close();
        }
        catch (EOFException eOFException) {
            try {
                genericLogReader.close();
            }
            catch (IOException iOException) {
                System.err.println("Outlier Analysis: Error in closing file for processor " + n);
                System.err.println(iOException);
            }
        }
        catch (IOException iOException) {
            System.err.println("Outlier Analysis: Error in reading log data for processor " + n);
            System.err.println(iOException);
        }
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Outliers", this.outlierList);
        this.setYAxis(this.attributes[1][this.currentAttribute], this.attributes[2][this.currentAttribute]);
        this.setDataSource("Outliers: " + this.attributes[0][this.currentAttribute] + " (Threshold = " + this.threshold + " processors)", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public void showWindow() {
    }

    public void applyDialogColors() {
        this.setDataSource("Outliers", this.graphData, this.graphColors, this);
        this.refreshGraph();
    }

    public String[] getPopup(int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        if (n < 0 || n2 < 0) {
            return null;
        }
        String[] stringArray = new String[]{n == 0 ? "Global Average" : (n == 1 ? "Non Outlier Average" : (n == 2 ? "Outlier Average" : "Outlier Processor " + (String)this.outlierList.get(n))), n2 == this.numActivities ? "Activity: Idle Time" : "Activity: " + Analysis.getActivityNameByIndex(this.currentActivity, n2), this.currentActivity >= 2 ? decimalFormat.format(this.graphData[n][n2]) + "" : U.t((long)this.graphData[n][n2])};
        return stringArray;
    }

    public void toolClickResponse(MouseEvent mouseEvent, int n, int n2) {
        if (n >= 3) {
            if (this.parentWindow.childWindows[1][0] != null) {
                final int n3 = n;
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        ((TimelineWindow)OutlierAnalysisWindow.this.parentWindow.childWindows[1][0]).addProcessor(Integer.parseInt((String)OutlierAnalysisWindow.this.outlierList.get(n3)));
                        return null;
                    }

                    public void finished() {
                    }
                };
                swingWorker.start();
            } else {
                System.err.println("You wanted to load processor " + (String)this.outlierList.get(n) + "'s data onto Timeline. However," + "the ability to open a new " + "timeline window from Outlier Analysis " + "is not supported yet!");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }
}

