/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import projections.gui.Analysis;
import projections.gui.JIntTextField;
import projections.gui.OutlierAnalysisWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;
import projections.guiUtils.ActivityManager;

public class OutlierDialog
extends RangeDialog {
    protected JPanel outlierPanel;
    protected JComboBox attributeList;
    protected JComboBox activityList;
    protected JIntTextField thresholdField;
    private JTextArea errorText;
    protected int currentAttribute = 0;
    protected int currentActivity = 0;
    protected int threshold = Analysis.getNumProcessors() <= 256 ? (int)Math.ceil(0.1 * (double)Analysis.getNumProcessors()) : 20;
    private int lastAttribute = -1;
    private int lastActivity = -1;

    public OutlierDialog(OutlierAnalysisWindow outlierAnalysisWindow, String string) {
        super(outlierAnalysisWindow, string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bOK) {
                if (this.activityList.getSelectedIndex() >= 0 && this.attributeList.getSelectedIndex() >= 0) {
                    if (this.activityList.getSelectedIndex() == 3 || this.activityList.getSelectedIndex() == 2 || this.activityList.getSelectedIndex() == 1 && this.attributeList.getSelectedIndex() >= 1) {
                        this.errorText.setText("ERROR: Attribute " + ((OutlierAnalysisWindow)this.parentWindow).attributes[0][this.attributeList.getSelectedIndex()] + " is incompatible with Activity " + ActivityManager.NAMES[this.activityList.getSelectedIndex()]);
                        return;
                    }
                } else {
                    this.errorText.setText("ERROR: no valid Attribute or Activity selection!");
                    return;
                }
                JTextField jTextField = this.checkConsistent();
                if (jTextField != null) {
                    jTextField.selectAll();
                    jTextField.requestFocus();
                    return;
                }
            } else if (jButton == this.bUpdate) {
                this.updateData(this.thresholdField);
            }
        } else if (actionEvent.getSource() instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (jComboBox == this.attributeList) {
                this.currentAttribute = jComboBox.getSelectedIndex();
            } else if (jComboBox == this.activityList) {
                this.currentActivity = jComboBox.getSelectedIndex();
            }
        }
        super.actionPerformed(actionEvent);
    }

    JPanel createMainLayout() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = super.createMainLayout();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.outlierPanel = new JPanel();
        this.outlierPanel.setLayout(gridBagLayout);
        this.attributeList = new JComboBox<String>(((OutlierAnalysisWindow)this.parentWindow).attributes[0]);
        this.attributeList.setSelectedIndex(this.currentAttribute);
        JLabel jLabel = new JLabel("Attribute: ", 4);
        this.attributeList.addActionListener(this);
        this.activityList = new JComboBox<String>(ActivityManager.NAMES);
        this.activityList.setSelectedIndex(this.currentActivity);
        JLabel jLabel2 = new JLabel("Activity: ", 4);
        this.activityList.addActionListener(this);
        JLabel jLabel3 = new JLabel("Outlier Threshold: ", 4);
        this.thresholdField = new JIntTextField(this.threshold, 8);
        JLabel jLabel4 = new JLabel("Processors", 2);
        this.thresholdField.addActionListener(this);
        this.errorText = new JTextArea();
        this.errorText.setRows(3);
        this.errorText.setEnabled(false);
        this.errorText.setLineWrap(true);
        this.errorText.setForeground(Color.red);
        JScrollPane jScrollPane = new JScrollPane(this.errorText, 20, 31);
        Util.gblAdd(this.outlierPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.attributeList, gridBagConstraints, 1, 0, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.activityList, gridBagConstraints, 1, 1, 2, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, jLabel3, gridBagConstraints, 0, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, this.thresholdField, gridBagConstraints, 1, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, jLabel4, gridBagConstraints, 2, 2, 1, 1, 0, 1);
        Util.gblAdd(this.outlierPanel, jScrollPane, gridBagConstraints, 0, 3, 3, 3, 0, 1);
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, this.outlierPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        return jPanel;
    }

    void updateData(JTextField jTextField) {
        if (jTextField instanceof JIntTextField && jTextField == this.thresholdField) {
            this.threshold = this.thresholdField.getValue();
        }
        super.updateData(jTextField);
    }

    JTextField checkConsistent() {
        if (this.thresholdField.getValue() < 0 || this.thresholdField.getValue() > this.processorsField.getValue(Analysis.getNumProcessors()).size()) {
            return this.thresholdField;
        }
        return super.checkConsistent();
    }

    public boolean isModified() {
        return this.threshold != this.thresholdField.getValue() || this.currentActivity != this.lastActivity || this.currentAttribute != this.lastAttribute || super.isModified();
    }

    void setParameters() {
        this.lastActivity = this.activityList.getSelectedIndex();
        this.lastAttribute = this.attributeList.getSelectedIndex();
        super.setParameters();
    }

    void updateFields() {
        super.updateFields();
    }

    void updateDerived() {
    }
}

