/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.Analysis;
import projections.gui.Bubble;
import projections.gui.MainWindow;

public class PieChartWindow
extends Frame {
    private MainWindow mainWindow;
    private MyPanel displayPanel;
    private float[] data;
    private int dataLen;
    private float thresh;
    private int[][] arc;
    private int numArcs;
    private Color[] colors;
    private int leftBuf;
    private int rightBuf;
    private int topBuf;
    private int bottomBuf;
    private String[][] names;
    private int diameter;
    private int centerX;
    private int centerY;
    private int numEntries;
    private int outOfRadius;
    private int hasChanged;
    private int currX;
    private int currY;
    private int dist;
    private int degree;
    private int currArcIndex;
    private Bubble bubble;
    private String[] bString;

    public PieChartWindow(MainWindow mainWindow, float[] fArray, int n, float f, Color[] colorArray) {
        this.mainWindow = mainWindow;
        this.data = fArray;
        this.dataLen = n;
        this.thresh = f;
        this.colors = colorArray;
        this.bString = new String[3];
        this.bString[0] = " ";
        this.bString[1] = " ";
        this.bString[2] = "AVERAGE";
        this.bubble = null;
        this.currArcIndex = -1;
        this.bottomBuf = 25;
        this.topBuf = 25;
        this.rightBuf = 25;
        this.leftBuf = 25;
        this.arc = null;
        this.outOfRadius = 1;
        this.names = Analysis.getEntryNames();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PieChartWindow.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PieChartWindow.this.setCursor(new Cursor(3));
                PieChartWindow.this.setSizes();
                PieChartWindow.this.setCursor(new Cursor(0));
            }
        });
        this.setTitle("Projections Pie Chart");
        this.createLayout();
        this.pack();
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.mainWindow.closeChildWindow(0);
        this.dispose();
    }

    public void setSizes() {
        int n = this.displayPanel.getSize().width;
        int n2 = this.displayPanel.getSize().height;
        this.diameter = n < n2 ? n - this.leftBuf - this.rightBuf : n2 - this.topBuf - this.bottomBuf;
        this.centerX = this.leftBuf + this.diameter / 2;
        this.centerY = this.topBuf + this.diameter / 2;
    }

    private void createLayout() {
        this.displayPanel = new MyPanel(this);
        this.displayPanel.setLayout(null);
        this.displayPanel.setBackground(Color.black);
        this.add(this.displayPanel);
    }

    static /* synthetic */ int[][] access$402(PieChartWindow pieChartWindow, int[][] nArray) {
        pieChartWindow.arc = nArray;
        return nArray;
    }

    public class MyPanel
    extends Panel
    implements MouseMotionListener {
        private PieChartWindow pcw;

        public MyPanel(PieChartWindow pieChartWindow2) {
            this.addMouseMotionListener(this);
            this.pcw = pieChartWindow2;
        }

        public void paint(Graphics graphics) {
            int n;
            int n2 = 0;
            PieChartWindow.this.numArcs = 0;
            int n3 = 0;
            for (n = 0; n < PieChartWindow.this.dataLen - 1; ++n) {
                if (!(PieChartWindow.this.data[n] >= PieChartWindow.this.thresh)) continue;
                PieChartWindow.this.numArcs++;
            }
            PieChartWindow.access$402(PieChartWindow.this, new int[PieChartWindow.this.numArcs][]);
            for (n = 0; n < PieChartWindow.this.numArcs; ++n) {
                ((PieChartWindow)PieChartWindow.this).arc[n] = new int[3];
            }
            for (n = 0; n < PieChartWindow.this.dataLen - 1; ++n) {
                if (PieChartWindow.this.data[n] < PieChartWindow.this.thresh) continue;
                graphics.setColor(PieChartWindow.this.colors[n]);
                graphics.fillArc(PieChartWindow.this.leftBuf, PieChartWindow.this.topBuf, PieChartWindow.this.diameter, PieChartWindow.this.diameter, n2, (int)((double)PieChartWindow.this.data[n] * 3.6));
                ((PieChartWindow)PieChartWindow.this).arc[n3][0] = n2;
                ((PieChartWindow)PieChartWindow.this).arc[n3][1] = n2 += (int)((double)PieChartWindow.this.data[n] * 3.6);
                ((PieChartWindow)PieChartWindow.this).arc[n3][2] = n;
                ++n3;
            }
            graphics.setColor(Color.gray);
            graphics.drawOval(PieChartWindow.this.leftBuf, PieChartWindow.this.topBuf, PieChartWindow.this.diameter, PieChartWindow.this.diameter);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PieChartWindow.this.currX = mouseEvent.getX();
            PieChartWindow.this.currY = mouseEvent.getY();
            double d = Math.abs((double)(PieChartWindow.this.currX - PieChartWindow.this.centerX));
            double d2 = Math.abs((double)(PieChartWindow.this.currY - PieChartWindow.this.centerY));
            PieChartWindow.this.dist = (int)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
            if (PieChartWindow.this.dist <= PieChartWindow.this.diameter / 2) {
                int n;
                if (PieChartWindow.this.outOfRadius == 1) {
                    PieChartWindow.this.hasChanged = 1;
                    PieChartWindow.this.outOfRadius = 0;
                }
                PieChartWindow.this.degree = (int)Math.toDegrees(Math.atan(d2 / d));
                if (PieChartWindow.this.currX < PieChartWindow.this.centerX && PieChartWindow.this.currY <= PieChartWindow.this.centerY) {
                    PieChartWindow.this.degree = 180 - PieChartWindow.this.degree;
                } else if (PieChartWindow.this.currX < PieChartWindow.this.centerX && PieChartWindow.this.currY > PieChartWindow.this.centerY) {
                    PieChartWindow.this.degree += 180;
                } else if (PieChartWindow.this.currX > PieChartWindow.this.centerX && PieChartWindow.this.currY >= PieChartWindow.this.centerY) {
                    PieChartWindow.this.degree = 360 - PieChartWindow.this.degree;
                }
                boolean bl = false;
                for (n = 0; n < PieChartWindow.this.numArcs; ++n) {
                    if (PieChartWindow.this.degree < PieChartWindow.this.arc[n][0] || PieChartWindow.this.degree >= PieChartWindow.this.arc[n][1]) continue;
                    bl = true;
                    if (PieChartWindow.this.currArcIndex != PieChartWindow.this.arc[n][2]) {
                        PieChartWindow.this.hasChanged = 1;
                        PieChartWindow.this.currArcIndex = PieChartWindow.this.arc[n][2];
                        break;
                    }
                    if (PieChartWindow.this.bubble == null) break;
                    PieChartWindow.this.bubble.setLocation(PieChartWindow.this.currX + 20 + this.pcw.getBounds().x, PieChartWindow.this.currY + 40 + this.pcw.getBounds().y);
                    break;
                }
                if (!bl) {
                    if (PieChartWindow.this.bubble != null) {
                        PieChartWindow.this.bubble.setVisible(false);
                        PieChartWindow.this.bubble.dispose();
                        PieChartWindow.this.bubble = null;
                    }
                    PieChartWindow.this.hasChanged = 0;
                    PieChartWindow.this.currArcIndex = -1;
                }
                if (PieChartWindow.this.hasChanged == 1) {
                    if (PieChartWindow.this.bubble != null) {
                        PieChartWindow.this.bubble.setVisible(false);
                        PieChartWindow.this.bubble.dispose();
                        PieChartWindow.this.bubble = null;
                    }
                    PieChartWindow.this.numEntries = Analysis.getNumUserEntries();
                    PieChartWindow.this.degree = (int)Math.toRadians(PieChartWindow.this.degree);
                    n = PieChartWindow.this.currX + 20 + this.pcw.getBounds().x;
                    int n2 = PieChartWindow.this.currY + 40 + this.pcw.getBounds().y;
                    if (PieChartWindow.this.currArcIndex < PieChartWindow.this.numEntries) {
                        ((PieChartWindow)PieChartWindow.this).bString[0] = PieChartWindow.this.names[PieChartWindow.this.currArcIndex][1] + "::" + PieChartWindow.this.names[PieChartWindow.this.currArcIndex][0];
                    } else if (PieChartWindow.this.currArcIndex == PieChartWindow.this.numEntries) {
                        ((PieChartWindow)PieChartWindow.this).bString[0] = "PACKING";
                    } else if (PieChartWindow.this.currArcIndex == PieChartWindow.this.numEntries + 1) {
                        ((PieChartWindow)PieChartWindow.this).bString[0] = "UNPACKING";
                    } else if (PieChartWindow.this.currArcIndex == PieChartWindow.this.numEntries + 2) {
                        ((PieChartWindow)PieChartWindow.this).bString[0] = "IDLE";
                    }
                    ((PieChartWindow)PieChartWindow.this).bString[1] = "usage: " + PieChartWindow.this.data[PieChartWindow.this.currArcIndex] + "%";
                    Rectangle rectangle = PieChartWindow.this.displayPanel.getGraphicsConfiguration().getBounds();
                    PieChartWindow.this.bubble = new Bubble(PieChartWindow.this.displayPanel, PieChartWindow.this.bString);
                    PieChartWindow.this.bubble.setLocation(new Point(n, n2));
                    PieChartWindow.this.bubble.show();
                    PieChartWindow.this.hasChanged = 0;
                }
            } else {
                PieChartWindow.this.outOfRadius = 1;
                if (PieChartWindow.this.bubble != null) {
                    PieChartWindow.this.bubble.setVisible(false);
                    PieChartWindow.this.bubble.dispose();
                    PieChartWindow.this.bubble = null;
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        public Dimension getPreferredSize() {
            return new Dimension(500, 500);
        }
    }
}

