/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import projections.analysis.PoseDopReader;
import projections.gui.Analysis;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.PoseRTDopDisplayPanel;
import projections.gui.PoseRangeDialog;
import projections.gui.PoseVTDopDisplayPanel;
import projections.gui.ProjectionsWindow;
import projections.gui.SwingWorker;
import projections.gui.Util;

public class PoseAnalysisWindow
extends ProjectionsWindow
implements ActionListener {
    private PoseAnalysisWindow thisWindow;
    private JPanel mainPanel = new JPanel();
    private JPanel controlPanel;
    private JButton setRanges;
    private JTabbedPane subToolsPanel;
    private PoseRTDopDisplayPanel realTimeDopDisplayPanel;
    private PoseVTDopDisplayPanel virtTimeDopDisplayPanel;
    private PoseRangeDialog dialog;
    long realStartTime;
    long realEndTime;
    int realStartInterval;
    int realEndInterval;
    long realIntervalSize;
    long virtStartTime;
    long virtEndTime;
    int virtStartInterval;
    int virtEndInterval;
    long virtIntervalSize;
    OrderedIntList processorList;
    private PoseDopReader reader;
    private int[][] dopRealData;
    private int[] dopVirtData;
    private boolean startFlag;

    void windowInit() {
        this.realStartTime = 0L;
        this.realEndTime = Analysis.getPoseTotalTime();
        this.realIntervalSize = 1000L;
        this.realStartInterval = 0;
        this.realEndInterval = this.realEndTime % this.realIntervalSize == 0L ? (int)(this.realEndTime / this.realIntervalSize - 1L) : (int)(this.realEndTime / this.realIntervalSize);
        this.virtStartTime = 0L;
        this.virtEndTime = Analysis.getPoseTotalVirtualTime();
        this.virtIntervalSize = this.virtEndTime / 100L + 1L;
        this.virtStartInterval = 0;
        this.virtEndInterval = this.virtEndTime % this.virtIntervalSize == 0L ? (int)(this.virtEndTime / this.virtIntervalSize - 1L) : (int)(this.virtEndTime / this.virtIntervalSize);
        this.processorList = Analysis.getValidProcessorList(3);
    }

    public PoseAnalysisWindow(MainWindow mainWindow, Integer n) {
        super("POSE Analysis Tools", mainWindow, n);
        this.getContentPane().add(this.mainPanel);
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.startFlag = true;
        this.showDialog();
    }

    private void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.subToolsPanel = new JTabbedPane();
        this.realTimeDopDisplayPanel = new PoseRTDopDisplayPanel();
        this.virtTimeDopDisplayPanel = new PoseVTDopDisplayPanel();
        this.subToolsPanel.insertTab("DOP: Real", null, this.realTimeDopDisplayPanel, "Degrees of Parallelism in Real Time", 0);
        this.subToolsPanel.insertTab("DOP: Virtual", null, this.virtTimeDopDisplayPanel, "Degrees of Parallelism in Virtual Time", 0);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        Util.gblAdd(this.controlPanel, this.setRanges, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.mainPanel, this.subToolsPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        Util.gblAdd(this.mainPanel, this.controlPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new PoseRangeDialog(this, "Select Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (PoseAnalysisWindow.this.dialog.isModified()) {
                        PoseAnalysisWindow.this.reader = Analysis.getPoseDopReader();
                        PoseAnalysisWindow.this.realStartInterval = (int)(PoseAnalysisWindow.this.realStartTime / PoseAnalysisWindow.this.realIntervalSize);
                        PoseAnalysisWindow.this.realEndInterval = (int)(PoseAnalysisWindow.this.realEndTime / PoseAnalysisWindow.this.realIntervalSize);
                        PoseAnalysisWindow.this.virtStartInterval = (int)(PoseAnalysisWindow.this.virtStartTime / PoseAnalysisWindow.this.virtIntervalSize);
                        PoseAnalysisWindow.this.virtEndInterval = (int)(PoseAnalysisWindow.this.virtEndTime / PoseAnalysisWindow.this.virtIntervalSize);
                        PoseAnalysisWindow.this.reader.read(PoseAnalysisWindow.this.realIntervalSize, PoseAnalysisWindow.this.realStartInterval, PoseAnalysisWindow.this.realEndInterval, PoseAnalysisWindow.this.virtIntervalSize, PoseAnalysisWindow.this.virtStartInterval, PoseAnalysisWindow.this.virtEndInterval, PoseAnalysisWindow.this.processorList);
                    }
                    return null;
                }

                public void finished() {
                    PoseAnalysisWindow.access$202(PoseAnalysisWindow.this, PoseAnalysisWindow.this.reader.getRealTimeDopData());
                    PoseAnalysisWindow.this.realTimeDopDisplayPanel.setGraphData(PoseAnalysisWindow.this.dopRealData, PoseAnalysisWindow.this.realIntervalSize, PoseAnalysisWindow.this.realStartInterval, PoseAnalysisWindow.this.realEndInterval);
                    PoseAnalysisWindow.access$402(PoseAnalysisWindow.this, PoseAnalysisWindow.this.reader.getVirtualTimeDopData());
                    PoseAnalysisWindow.this.virtTimeDopDisplayPanel.setGraphData(PoseAnalysisWindow.this.dopVirtData, PoseAnalysisWindow.this.virtIntervalSize, PoseAnalysisWindow.this.virtStartInterval, PoseAnalysisWindow.this.virtEndInterval);
                    if (PoseAnalysisWindow.this.startFlag) {
                        PoseAnalysisWindow.this.thisWindow.setVisible(true);
                    }
                    if (PoseAnalysisWindow.this.startFlag) {
                        PoseAnalysisWindow.this.startFlag = false;
                    }
                    PoseAnalysisWindow.this.realTimeDopDisplayPanel.refreshGraph();
                    PoseAnalysisWindow.this.virtTimeDopDisplayPanel.refreshGraph();
                }
            };
            swingWorker.start();
        }
    }

    public void getDialogData() {
        PoseRangeDialog poseRangeDialog = this.dialog;
        this.realStartTime = poseRangeDialog.getRealStartTime();
        this.realEndTime = poseRangeDialog.getRealEndTime();
        this.realIntervalSize = poseRangeDialog.getRealIntervalSize();
        this.virtStartTime = poseRangeDialog.getVirtStartTime();
        this.virtEndTime = poseRangeDialog.getVirtEndTime();
        this.virtIntervalSize = poseRangeDialog.getVirtIntervalSize();
        this.processorList = poseRangeDialog.getValidProcessors();
    }

    public void setDialogData() {
        PoseRangeDialog poseRangeDialog = this.dialog;
        poseRangeDialog.setRealIntervalSize(this.realIntervalSize);
        poseRangeDialog.setRealStartTime(this.realStartTime);
        poseRangeDialog.setRealEndTime(this.realEndTime);
        poseRangeDialog.setVirtIntervalSize(this.virtIntervalSize);
        poseRangeDialog.setVirtStartTime(this.virtStartTime);
        poseRangeDialog.setVirtEndTime(this.virtEndTime);
        poseRangeDialog.setValidProcessors(this.processorList);
    }

    public void showWindow() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton;
        if (actionEvent.getSource() instanceof JButton && (jButton = (JButton)actionEvent.getSource()) == this.setRanges) {
            this.showDialog();
        }
    }

    static /* synthetic */ int[][] access$202(PoseAnalysisWindow poseAnalysisWindow, int[][] nArray) {
        poseAnalysisWindow.dopRealData = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$402(PoseAnalysisWindow poseAnalysisWindow, int[] nArray) {
        poseAnalysisWindow.dopVirtData = nArray;
        return nArray;
    }
}

