/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import projections.gui.Analysis;
import projections.gui.JLongTextField;
import projections.gui.JSelectField;
import projections.gui.JTimeTextField;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.U;
import projections.gui.Util;

public class PoseRangeDialog
extends JDialog
implements ActionListener,
KeyListener,
FocusListener {
    ProjectionsWindow parentWindow;
    private static final int DIALOG_OK = 0;
    private static final int DIALOG_CANCELLED = 1;
    protected JPanel processorsPanel;
    protected JTabbedPane timePanel;
    protected JPanel realTimePanel;
    protected JPanel virtTimePanel;
    protected JPanel buttonPanel;
    protected JPanel mainPanel;
    protected JButton bOK;
    protected JButton bUpdate;
    protected JButton bCancel;
    protected JSelectField processorsField;
    protected JTimeTextField realIntervalSizeField;
    protected JTimeTextField realStartTimeField;
    protected JTimeTextField realEndTimeField;
    protected JLongTextField virtIntervalSizeField;
    protected JLongTextField virtStartTimeField;
    protected JLongTextField virtEndTimeField;
    private JLabel realStartFieldLabel;
    private JLabel realEndFieldLabel;
    private JLabel realIntervalSizeFieldLabel;
    private JLabel virtStartFieldLabel;
    private JLabel virtEndFieldLabel;
    private JLabel virtIntervalSizeFieldLabel;
    private JLabel processorsFieldLabel;
    private JLabel totalSelectedRealTimeLabel;
    private JLabel validRealTimeLabel;
    private JLabel totalNumRealIntervalsLabel;
    private JLabel realStartIntervalLabel;
    private JLabel realEndIntervalLabel;
    private JLabel totalSelectedVirtTimeLabel;
    private JLabel validVirtTimeLabel;
    private JLabel totalNumVirtIntervalsLabel;
    private JLabel virtStartIntervalLabel;
    private JLabel virtEndIntervalLabel;
    private JLabel validProcessorsLabel;
    protected OrderedIntList validProcessors;
    protected long realIntervalSize;
    protected long realStartTime;
    protected long realEndTime;
    protected long virtIntervalSize;
    protected long virtStartTime;
    protected long virtEndTime;
    private String validProcessorsString;
    private long numRealIntervals;
    private long realStartInterval;
    private long realEndInterval;
    private long numVirtIntervals;
    private long virtStartInterval;
    private long virtEndInterval;
    private static final int NUM_TYPES = 2;
    private static final int REAL_TIME = 0;
    private static final int VIRT_TIME = 1;
    private DecimalFormat _format;
    private boolean layoutComplete = false;
    private int dialogState;

    public PoseRangeDialog(ProjectionsWindow projectionsWindow, String string) {
        super(projectionsWindow, string, true);
        this.parentWindow = projectionsWindow;
        this.validProcessors = Analysis.getValidProcessorList(3);
        this.validProcessorsString = this.validProcessors.listToString();
        this.realIntervalSize = 1000L;
        this.realStartTime = 0L;
        this.realEndTime = Analysis.getPoseTotalTime();
        this.realStartInterval = 0L;
        this.realEndInterval = this.realEndTime / this.realIntervalSize;
        this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
        this.virtStartTime = 0L;
        this.virtEndTime = Analysis.getPoseTotalVirtualTime();
        this.virtIntervalSize = this.virtEndTime / 100L + 1L;
        this.virtStartInterval = 0L;
        this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
        this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
        this._format = new DecimalFormat();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bOK) {
                JTextField jTextField = this.checkConsistent();
                if (jTextField != null) {
                    jTextField.selectAll();
                    jTextField.requestFocus();
                    return;
                }
                this.dialogState = 0;
                this.setVisible(false);
            } else {
                if (jButton == this.bUpdate) {
                    this.updateData(this.processorsField);
                    this.updateData(this.realStartTimeField);
                    this.updateData(this.realEndTimeField);
                    this.updateData(this.virtStartTimeField);
                    this.updateData(this.virtEndTimeField);
                    return;
                }
                if (jButton == this.bCancel) {
                    this.dialogState = 1;
                    this.setVisible(false);
                }
            }
        } else if (actionEvent.getSource() instanceof JTextField) {
            this.updateData((JTextField)actionEvent.getSource());
            this.bOK.setEnabled(true);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() instanceof JTextField) {
            this.updateData((JTextField)focusEvent.getComponent());
            this.bOK.setEnabled(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)keyEvent.getComponent();
            switch (n) {
                case 10: {
                    this.updateData(jTextField);
                    this.bOK.setEnabled(true);
                    break;
                }
                case 9: {
                    this.updateData(jTextField);
                    this.bOK.setEnabled(true);
                    break;
                }
                default: {
                    this.bOK.setEnabled(false);
                }
            }
        }
    }

    public void displayDialog() {
        if (!this.layoutComplete) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PoseRangeDialog.this.dialogState = 1;
                    PoseRangeDialog.this.setVisible(false);
                }
            });
            this.mainPanel = this.createMainLayout();
            this.buttonPanel = this.createButtonLayout();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel, "North");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.layoutComplete = true;
            this.pack();
            this.setResizable(false);
        } else {
            this.setParameters();
        }
        this.setVisible(true);
    }

    JPanel createMainLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.processorsPanel = new JPanel();
        this.processorsPanel.setLayout(gridBagLayout);
        this.validProcessorsLabel = new JLabel("Valid Processors = " + this.validProcessorsString, 2);
        this.processorsFieldLabel = new JLabel("Processors :", 2);
        this.processorsField = new JSelectField(this.validProcessorsString, 12);
        this.processorsField.addActionListener(this);
        Util.gblAdd(this.processorsPanel, this.validProcessorsLabel, gridBagConstraints, 0, 0, 2, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorsFieldLabel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.processorsPanel, this.processorsField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        this.timePanel = new JTabbedPane();
        this.timePanel.setBorder(new TitledBorder(new LineBorder(Color.black), "POSE TIME PARAMETER"));
        this.realTimePanel = new JPanel();
        this.realTimePanel.setLayout(gridBagLayout);
        this.realIntervalSizeFieldLabel = new JLabel("Size of Real Time Interval:", 2);
        this.realIntervalSizeField = new JTimeTextField(this.realIntervalSize, 12);
        this.realIntervalSizeField.addActionListener(this);
        this.realIntervalSizeField.addKeyListener(this);
        this.realIntervalSizeField.addFocusListener(this);
        this.realStartFieldLabel = new JLabel("Real Time Start:", 2);
        this.realStartTimeField = new JTimeTextField(this.realStartTime, 12);
        this.realStartTimeField.addActionListener(this);
        this.realStartTimeField.addKeyListener(this);
        this.realStartTimeField.addFocusListener(this);
        this.realEndFieldLabel = new JLabel("Real Time End:", 2);
        this.realEndTimeField = new JTimeTextField(this.realEndTime, 12);
        this.realEndTimeField.addActionListener(this);
        this.realEndTimeField.addKeyListener(this);
        this.realEndTimeField.addFocusListener(this);
        this.validRealTimeLabel = new JLabel("Valid Real Time Range: " + U.t(0L) + " to " + U.t(Analysis.getPoseTotalTime()));
        this.totalSelectedRealTimeLabel = new JLabel("Selected Total Time: " + U.t(this.realEndTime - this.realStartTime));
        this.realStartIntervalLabel = new JLabel("Start Interval: " + this.realStartInterval);
        this.realEndIntervalLabel = new JLabel("End Interval: " + this.realEndInterval);
        this.totalNumRealIntervalsLabel = new JLabel("Num Intervals: " + (this.realEndInterval - this.realStartInterval + 1L));
        Util.gblAdd(this.realTimePanel, this.realIntervalSizeFieldLabel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realIntervalSizeField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realStartFieldLabel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realStartTimeField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realEndFieldLabel, gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realEndTimeField, gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.validRealTimeLabel, gridBagConstraints, 0, 2, 4, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.totalSelectedRealTimeLabel, gridBagConstraints, 0, 3, 4, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realStartIntervalLabel, gridBagConstraints, 0, 4, 2, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.realEndIntervalLabel, gridBagConstraints, 1, 4, 2, 1, 1, 1);
        Util.gblAdd(this.realTimePanel, this.totalNumRealIntervalsLabel, gridBagConstraints, 0, 5, 4, 1, 1, 1);
        this.virtTimePanel = new JPanel();
        this.virtTimePanel.setLayout(gridBagLayout);
        this.virtIntervalSizeFieldLabel = new JLabel("Units in Virtual Time Interval:", 2);
        this.virtIntervalSizeField = new JLongTextField(this.virtIntervalSize, 12);
        this.virtIntervalSizeField.addActionListener(this);
        this.virtIntervalSizeField.addKeyListener(this);
        this.virtIntervalSizeField.addFocusListener(this);
        this.virtStartFieldLabel = new JLabel("Virtual Time Start:", 2);
        this.virtStartTimeField = new JLongTextField(this.virtStartTime, 12);
        this.virtStartTimeField.addActionListener(this);
        this.virtStartTimeField.addKeyListener(this);
        this.virtStartTimeField.addFocusListener(this);
        this.virtEndFieldLabel = new JLabel("Virtual Time End:", 2);
        this.virtEndTimeField = new JLongTextField(this.virtEndTime, 12);
        this.virtEndTimeField.addActionListener(this);
        this.virtEndTimeField.addKeyListener(this);
        this.virtEndTimeField.addFocusListener(this);
        this.validVirtTimeLabel = new JLabel("Valid Virtual Time Range: 0 to " + Analysis.getPoseTotalVirtualTime());
        this.totalSelectedVirtTimeLabel = new JLabel("Units of Selected Total Time: " + (this.virtEndTime - this.virtStartTime));
        this.virtStartIntervalLabel = new JLabel("Start Interval: " + this.virtStartInterval);
        this.virtEndIntervalLabel = new JLabel("End Interval: " + this.virtEndInterval);
        this.totalNumVirtIntervalsLabel = new JLabel("Num Intervals: " + (this.virtEndInterval - this.virtStartInterval + 1L));
        Util.gblAdd(this.virtTimePanel, this.virtIntervalSizeFieldLabel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtIntervalSizeField, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtStartFieldLabel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtStartTimeField, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtEndFieldLabel, gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtEndTimeField, gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.validVirtTimeLabel, gridBagConstraints, 0, 2, 4, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.totalSelectedVirtTimeLabel, gridBagConstraints, 0, 3, 4, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtStartIntervalLabel, gridBagConstraints, 0, 4, 2, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.virtEndIntervalLabel, gridBagConstraints, 1, 4, 2, 1, 1, 1);
        Util.gblAdd(this.virtTimePanel, this.totalNumVirtIntervalsLabel, gridBagConstraints, 0, 5, 4, 1, 1, 1);
        this.timePanel.addTab("Real Time", null, this.realTimePanel, "Real Time Parameters");
        this.timePanel.addTab("Virtual", null, this.virtTimePanel, "Virtual Time Parameters");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, this.processorsPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, this.timePanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        return jPanel;
    }

    JPanel createButtonLayout() {
        JPanel jPanel = new JPanel();
        this.bOK = new JButton("OK");
        this.bUpdate = new JButton("Update");
        this.bCancel = new JButton("Cancel");
        jPanel.add(this.bOK);
        jPanel.add(this.bUpdate);
        jPanel.add(this.bCancel);
        this.bOK.addActionListener(this);
        this.bUpdate.addActionListener(this);
        this.bCancel.addActionListener(this);
        return jPanel;
    }

    void updateData(JTextField jTextField) {
        if (jTextField instanceof JTimeTextField) {
            if (jTextField == this.realStartTimeField) {
                this.realStartTime = this.realStartTimeField.getValue();
                this.realStartInterval = this.realStartTime / this.realIntervalSize;
            } else if (jTextField == this.realEndTimeField) {
                this.realEndTime = this.realEndTimeField.getValue();
                this.realEndInterval = this.realEndTime / this.realIntervalSize;
            } else if (jTextField == this.realIntervalSizeField) {
                this.realIntervalSize = this.realIntervalSizeField.getValue();
            }
        } else if (jTextField instanceof JLongTextField) {
            if (jTextField == this.virtStartTimeField) {
                this.virtStartTime = this.virtStartTimeField.getValue();
            } else if (jTextField == this.virtEndTimeField) {
                this.virtEndTime = this.virtEndTimeField.getValue();
            } else if (jTextField == this.virtIntervalSizeField) {
                this.virtIntervalSize = this.virtIntervalSizeField.getValue();
            }
        }
        this.updateDerived(jTextField);
    }

    JTextField checkConsistent() {
        return null;
    }

    public boolean isModified() {
        return true;
    }

    void updateDerived(JTextField jTextField) {
        if (jTextField instanceof JTimeTextField) {
            if (jTextField == this.realStartTimeField) {
                this.realStartInterval = this.realStartTime / this.realIntervalSize;
                this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            } else if (jTextField == this.realEndTimeField) {
                this.realEndInterval = this.realEndTime / this.realIntervalSize;
                this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            } else if (jTextField == this.realIntervalSizeField) {
                this.realStartInterval = this.realStartTime / this.realIntervalSize;
                this.realEndInterval = this.realEndTime / this.realIntervalSize;
                this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            }
        } else if (jTextField instanceof JLongTextField) {
            if (jTextField == this.virtStartTimeField) {
                this.virtStartInterval = this.virtStartTime / this.virtIntervalSize;
                this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
            } else if (jTextField == this.virtEndTimeField) {
                this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
                this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
            } else if (jTextField == this.virtIntervalSizeField) {
                this.virtStartInterval = this.virtStartTime / this.virtIntervalSize;
                this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
                this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
            }
        } else if (jTextField == null) {
            this.realStartInterval = this.realStartTime / this.realIntervalSize;
            this.realEndInterval = this.realEndTime / this.realIntervalSize;
            this.numRealIntervals = this.realEndInterval - this.realStartInterval + 1L;
            this.virtStartInterval = this.virtStartTime / this.virtIntervalSize;
            this.virtEndInterval = this.virtEndTime / this.virtIntervalSize;
            this.numVirtIntervals = this.virtEndInterval - this.virtStartInterval + 1L;
        }
        this.totalSelectedRealTimeLabel.setText("Selected Total Time: " + U.t(this.realEndTime - this.realStartTime));
        this.realStartIntervalLabel.setText("Start Interval: " + this.realStartInterval);
        this.realEndIntervalLabel.setText("End Interval: " + this.realEndInterval);
        this.totalNumRealIntervalsLabel.setText("Num Intervals: " + (this.realEndInterval - this.realStartInterval + 1L));
        this.totalSelectedVirtTimeLabel.setText("Units of Selected Total Time: " + (this.virtEndTime - this.virtStartTime));
        this.virtStartIntervalLabel.setText("Start Interval: " + this.virtStartInterval);
        this.virtEndIntervalLabel.setText("End Interval: " + this.virtEndInterval);
        this.totalNumVirtIntervalsLabel.setText("Num Intervals: " + (this.virtEndInterval - this.virtStartInterval + 1L));
    }

    void setParameters() {
        this.realIntervalSize = this.realIntervalSizeField.getValue();
        this.realStartTime = this.realStartTimeField.getValue();
        this.realEndTime = this.realEndTimeField.getValue();
        this.virtIntervalSize = this.virtIntervalSizeField.getValue();
        this.virtStartTime = this.virtStartTimeField.getValue();
        this.virtEndTime = this.virtEndTimeField.getValue();
        this.updateDerived(null);
    }

    public boolean isCancelled() {
        return this.dialogState == 1;
    }

    public OrderedIntList getValidProcessors() {
        return this.validProcessors;
    }

    public void setValidProcessors(OrderedIntList orderedIntList) {
        this.validProcessors = orderedIntList;
        this.validProcessorsString = this.validProcessors.listToString();
    }

    public long getRealIntervalSize() {
        return this.realIntervalSize;
    }

    public void setRealIntervalSize(long l) {
        this.realIntervalSize = l;
    }

    public long getRealStartTime() {
        return this.realStartTime;
    }

    public void setRealStartTime(long l) {
        this.realStartTime = l;
    }

    public long getRealEndTime() {
        return this.realEndTime;
    }

    public void setRealEndTime(long l) {
        this.realEndTime = l;
    }

    public long getVirtIntervalSize() {
        return this.virtIntervalSize;
    }

    public void setVirtIntervalSize(long l) {
        this.virtIntervalSize = l;
    }

    public long getVirtStartTime() {
        return this.virtStartTime;
    }

    public void setVirtStartTime(long l) {
        this.virtStartTime = l;
    }

    public long getVirtEndTime() {
        return this.virtEndTime;
    }

    public void setVirtEndTime(long l) {
        this.virtEndTime = l;
    }
}

