/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import projections.gui.MainWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public abstract class ProjectionsWindow
extends JFrame
implements ActionListener {
    private Button[] window;
    protected int myWindowID;
    protected MainWindow parentWindow;
    protected RangeDialog dialog;

    abstract void windowInit();

    abstract void showDialog();

    abstract void showWindow();

    abstract void getDialogData();

    protected void setDialogData() {
        if (this.dialog != null) {
            this.dialog.updateFields();
        }
    }

    public ProjectionsWindow(String string, MainWindow mainWindow, Integer n) {
        this(string, mainWindow, (int)n);
    }

    public ProjectionsWindow(MainWindow mainWindow, Integer n) {
        this("", mainWindow, (int)n);
    }

    public ProjectionsWindow(String string, MainWindow mainWindow, int n) {
        this.myWindowID = n;
        this.parentWindow = mainWindow;
        this.setTitle(string);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProjectionsWindow.this.close();
            }
        });
        this.windowInit();
    }

    public void setLayout(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(gridBagLayout);
        Util.gblAdd(jPanel2, jPanel, gridBagConstraints, 0, 1, 1, 1, 1, 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            int n = 0;
            while (true) {
                if (n >= 17 || button == this.window[n]) break;
                ++n;
            }
        }
    }

    public void close() {
        this.dispose();
        this.parentWindow.closeChildWindow(this.myWindowID);
    }
}

