/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import javax.swing.ProgressMonitor;
import projections.gui.Analysis;
import projections.gui.ColorMap;
import projections.gui.OrderedIntList;
import projections.gui.ScalePanel;
import projections.gui.StlWindow;
import projections.gui.SwingWorker;
import projections.gui.U;

public class StlPanel
extends ScalePanel.Child {
    private int[][] entryData;
    private int[][] utilData;
    private int[][] idleData;
    private int[][] mergedData;
    private int[][] colors;
    private int intervalSize;
    private int nPe;
    private OrderedIntList validPEs;
    private long totalTime;
    private long startTime;
    private long endTime;
    private OrderedIntList oldPEList = new OrderedIntList();
    private long prevStartTime = -1L;
    private long prevEndTime = -1L;
    private ColorMap colorMap;
    private int mode = 0;
    private boolean newEPData = true;
    private StlWindow parentWindow = null;

    public StlPanel(StlWindow stlWindow) {
        this.parentWindow = stlWindow;
    }

    public String getPointInfo(double d, double d2) {
        int n = (int)d2;
        if (n < 0 || n >= this.nPe || d2 < 0.0) {
            return "";
        }
        long l = (long)d;
        if (l < 0L || l >= this.totalTime) {
            return "";
        }
        if (this.validPEs != null) {
            int n2 = 0;
            this.validPEs.reset();
            for (int i = 0; i <= n; ++i) {
                n2 = this.validPEs.nextElement();
            }
            int n3 = Analysis.getNumUserEntries();
            int n4 = (int)(l / (long)this.intervalSize);
            long l2 = l + this.startTime;
            if (this.mode == 0) {
                return "Processor " + n2 + ": Usage = " + this.utilData[n][n4] + "%" + " IDLE = " + this.idleData[n][n4] + "%" + " at " + U.t(l2) + " (" + l2 + " us). ";
            }
            if (n4 >= this.entryData[n].length) {
                return "";
            }
            if (this.entryData[n][n4] > 0) {
                return "Processor " + n2 + ": Usage = " + this.utilData[n][n4] + "%" + " at " + U.t(l2) + " (" + l2 + " us)." + " EP = " + Analysis.getEntryName(this.entryData[n][n4]);
            }
            return "Processor " + n2 + ": Usage = " + this.utilData[n][n4] + "%" + " at " + U.t(l2) + " (" + l2 + " us). ";
        }
        return "";
    }

    public void paint(ScalePanel.Child.RepaintRequest repaintRequest) {
        double d = repaintRequest.y(1.0) - repaintRequest.y(0.0);
        double d2 = repaintRequest.x(1.0) - repaintRequest.x(0.0);
        double d3 = 1.0 / d;
        double d4 = 1.0 / d2;
        double d5 = repaintRequest.xInv(0.0);
        double d6 = repaintRequest.xInv(repaintRequest.w - 1);
        double d7 = repaintRequest.yInv(0.0);
        double d8 = repaintRequest.yInv(repaintRequest.h - 1);
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        if (d5 >= (double)this.totalTime) {
            d5 = (double)this.totalTime - 0.001;
        }
        if (d6 < 0.0) {
            d6 = 0.0;
        }
        if (d6 >= (double)this.totalTime) {
            d6 = (double)this.totalTime - 0.001;
        }
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        if (d7 >= (double)this.nPe) {
            d7 = (double)this.nPe - 0.001;
        }
        if (d8 < 0.0) {
            d8 = 0.0;
        }
        if (d8 >= (double)this.nPe) {
            d8 = (double)this.nPe - 0.001;
        }
        int n = (int)Math.ceil(repaintRequest.x(d5));
        int n2 = (int)Math.floor(repaintRequest.x(d6));
        int n3 = (int)Math.ceil(repaintRequest.y(d7));
        int n4 = (int)Math.floor(repaintRequest.y(d8));
        int n5 = n2 - n;
        int n6 = n4 - n3;
        double d9 = repaintRequest.xInv(n) / (double)this.intervalSize;
        double d10 = d4 / (double)this.intervalSize;
        int n7 = n2 - n;
        if (this.validPEs != null && n5 > 0 && n6 > 0) {
            int n8;
            int[] nArray = new int[n5 * n6];
            int n9 = (int)Math.floor(d7);
            int n10 = (int)Math.ceil(d8);
            this.validPEs.reset();
            int n11 = 0;
            while ((n8 = this.validPEs.nextElement()) != -1) {
                if (n8 == -1) continue;
                int n12 = (int)Math.floor(repaintRequest.y(n11));
                int n13 = (int)Math.floor(repaintRequest.y(n11 + 1));
                if (n12 < n3) {
                    n12 = n3;
                }
                if (n13 > n4) {
                    n13 = n4;
                }
                if (n11 < this.colors.length) {
                    this.renderRow(this.colors[n11], d9, d10, nArray, n5, n12 - n3, n13 - n3, n - n, n2 - n);
                }
                ++n11;
            }
            Image image = this.createImage(new MemoryImageSource(n5, n6, nArray, 0, n5));
            repaintRequest.g.drawImage(image, n, n3, null);
        }
        repaintRequest.g.setColor(Color.black);
        repaintRequest.g.fillRect(0, 0, n, n4);
        repaintRequest.g.fillRect(n, 0, repaintRequest.w, n3);
        repaintRequest.g.fillRect(n2, n3, repaintRequest.w, n4);
        repaintRequest.g.fillRect(0, n4, repaintRequest.w, repaintRequest.h);
    }

    private void renderRow(int[] nArray, double d, double d2, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        int n6 = (int)(65536.0 * d);
        int n7 = (int)(65536.0 * d2);
        int n8 = n6 + n4 * n7;
        int n9 = 0;
        for (int i = n4; i < n5; ++i) {
            n9 = n8 >> 16;
            if (n9 < 0) {
                n9 = 0;
                continue;
            }
            if (n9 >= nArray.length) {
                n8 += n7;
                continue;
            }
            int n10 = nArray[n9];
            n8 += n7;
            int n11 = n2 * n + i;
            int n12 = n2;
            while (n12 < n3) {
                if (n11 < nArray2.length) {
                    nArray2[n11] = n10;
                }
                ++n12;
                n11 += n;
            }
        }
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    private void applyColorMap(int[][] nArray, boolean bl) {
        if (!bl) {
            int n = nArray.length;
            this.colors = new int[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i].length;
                this.colors[i] = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    if (nArray[i][j] > 255 || nArray[i][j] < 0) {
                        this.colors[i][j] = this.colorMap.apply(255);
                        System.err.println("[" + i + "] Warning: Invalid " + "value " + nArray[i][j] + " being " + "applied to the color map " + "at time interval " + j + "!");
                        continue;
                    }
                    this.colors[i][j] = this.colorMap.apply(nArray[i][j]);
                }
            }
        } else {
            int n = nArray.length;
            int n3 = nArray[n - 1].length;
            this.colors = new int[n][n3];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.colors[i][j] = nArray[i][j] > 0 ? Analysis.getEntryColor(nArray[i][j]).getRGB() : Color.black.getRGB();
                }
            }
        }
    }

    public void setMode(int n) {
        this.mode = n;
        int n2 = Analysis.getNumUserEntries();
        if (n == 0) {
            this.applyColorMap(this.mergedData, false);
            this.repaint();
        } else if (n == 1) {
            if (this.newEPData) {
                this.parentWindow.setVisible(false);
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        StlPanel.this.setEPData();
                        StlPanel.this.newEPData = false;
                        return null;
                    }

                    public void finished() {
                        StlPanel.this.parentWindow.setVisible(true);
                        StlPanel.this.applyColorMap(StlPanel.this.entryData, true);
                        StlPanel.this.repaint();
                    }
                };
                swingWorker.start();
            } else {
                this.applyColorMap(this.entryData, true);
                this.repaint();
            }
        }
    }

    public void resetMode() {
        this.mode = 0;
        this.newEPData = true;
    }

    public void setData(OrderedIntList orderedIntList, long l, long l2) {
        this.validPEs = orderedIntList;
        this.totalTime = l2 - l;
        this.startTime = l;
        this.endTime = l2;
        int n = this.totalTime < 7000L ? (int)((double)this.totalTime - 1.0) : 7000;
        double d = this.totalTime / (long)n;
        if (d < 5.0) {
            d = this.totalTime / (long)(n /= 5);
        }
        this.intervalSize = (int)d;
        int n2 = (int)(l / (long)this.intervalSize);
        int n3 = (int)(l2 / (long)this.intervalSize);
        this.nPe = orderedIntList.size();
        int n4 = Analysis.getNumUserEntries();
        if (l == this.prevStartTime && l2 == this.prevEndTime && this.oldPEList.equals(orderedIntList)) {
            this.newEPData = false;
            return;
        }
        this.prevStartTime = l;
        this.prevEndTime = l2;
        if (!this.oldPEList.equals(orderedIntList)) {
            this.oldPEList = orderedIntList.copyOf();
        }
        orderedIntList.reset();
        Analysis.LoadGraphData(this.intervalSize, n2, n3, false, orderedIntList);
        this.utilData = Analysis.getSystemUsageData(1);
        this.idleData = Analysis.getSystemUsageData(2);
        if (this.idleData == null) {
            this.idleData = new int[this.utilData.length][this.utilData[0].length];
        }
        this.mergedData = new int[this.utilData.length][this.utilData[0].length];
        for (int i = 0; i < this.utilData.length; ++i) {
            for (int j = 0; j < this.utilData[i].length; ++j) {
                if (this.utilData[i][j] == 0) {
                    if (this.idleData[i][j] > 0) {
                        this.mergedData[i][j] = 0;
                        continue;
                    }
                    this.mergedData[i][j] = 0;
                    continue;
                }
                this.mergedData[i][j] = this.utilData[i][j];
            }
        }
        this.applyColorMap(this.mergedData, false);
        orderedIntList.reset();
        this.repaint();
    }

    public void setEPData() {
        int n = this.totalTime < 7000L ? (int)((double)this.totalTime - 1.0) : 7000;
        double d = this.totalTime / (long)n;
        if (d < 5.0) {
            d = this.totalTime / (long)(n /= 5);
        }
        this.intervalSize = (int)d;
        int n2 = (int)(this.startTime / (long)this.intervalSize);
        int n3 = (int)(this.endTime / (long)this.intervalSize);
        this.nPe = this.validPEs.size();
        int n4 = Analysis.getNumUserEntries();
        if (Analysis.hasLogData()) {
            ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Building EP Data", "", 0, this.validPEs.size());
            progressMonitor.setNote("Building EP Data");
            progressMonitor.setProgress(0);
            OrderedIntList orderedIntList = new OrderedIntList();
            int[][] nArrayArray = new int[this.validPEs.size()][];
            int[][] nArray = new int[this.validPEs.size()][n];
            this.entryData = new int[this.validPEs.size()][n];
            int n5 = 0;
            int n6 = 0;
            this.validPEs.reset();
            while (this.validPEs.hasMoreElements()) {
                n6 = this.validPEs.nextElement();
                orderedIntList.insert(n6);
                progressMonitor.setProgress(n5);
                progressMonitor.setNote("[PE: " + n6 + " ( " + n5 + " of " + this.validPEs.size() + ") ] Acummulating Data");
                Analysis.LoadGraphData(this.intervalSize, n2, n3, true, orderedIntList);
                for (int i = 0; i < n4; ++i) {
                    nArrayArray[n5] = Analysis.getUserEntryData(i, 2)[0];
                    for (int j = 0; j < nArrayArray[n5].length && j < n; ++j) {
                        if (nArrayArray[n5][j] <= nArray[n5][j]) continue;
                        nArray[n5][j] = nArrayArray[n5][j];
                        this.entryData[n5][j] = i;
                    }
                }
                orderedIntList.removeAll();
                ++n5;
            }
            progressMonitor.close();
        }
    }
}

