/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ProgressMonitor;
import projections.gui.AmpiTimeProfileWindow;
import projections.gui.Analysis;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;

public class TimeProfileWindow
extends GenericGraphWindow
implements ActionListener,
ColorSelectable {
    private TimeProfileWindow thisWindow;
    private EntrySelectionDialog entryDialog;
    private JPanel mainPanel;
    private JPanel controlPanel;
    private JButton epSelection;
    private JButton setRanges;
    private JButton saveColors;
    private JButton loadColors;
    int startInterval;
    int endInterval;
    long intervalSize;
    OrderedIntList processorList;
    private int numEPs;
    private String[] typeLabelNames = new String[]{"Entry Points"};
    private boolean[][] stateArray;
    private boolean[][] existsArray;
    private Color[][] colorArray;
    private String[] entryNames;
    private double[][] graphData;
    private double[][] outputData;
    private Color[] outColors;
    private boolean startFlag;
    private JTabbedPane tabPane = null;
    private AmpiTimeProfileWindow ampiGraphPanel = null;
    private JPanel epPanel = null;
    private boolean ampiTraceOn = false;
    private int ampiPanelTabIndex;
    private int epPanelTabIndex;

    void windowInit() {
        super.windowInit();
        this.intervalSize = 1000L;
        this.startInterval = 0;
        this.endInterval = this.endTime % this.intervalSize == 0L ? (int)(this.endTime / this.intervalSize - 1L) : (int)(this.endTime / this.intervalSize);
        this.processorList = Analysis.getValidProcessorList();
    }

    public TimeProfileWindow(MainWindow mainWindow, Integer n) {
        super("Projections Time Profile Graph - " + Analysis.getFilename() + ".sts", mainWindow, n);
        this.setGraphSpecificData();
        this.numEPs = Analysis.getNumUserEntries();
        this.stateArray = new boolean[1][this.numEPs];
        this.existsArray = new boolean[1][this.numEPs];
        this.colorArray = new Color[1][];
        this.colorArray[0] = Analysis.getColorMap();
        this.entryNames = new String[this.numEPs];
        for (int i = 0; i < this.numEPs; ++i) {
            this.entryNames[i] = Analysis.getEntryName(i);
        }
        this.mainPanel = new JPanel();
        this.getContentPane().add(this.mainPanel);
        if (Analysis.getNumFunctionEvents() > 0) {
            this.ampiTraceOn = true;
        }
        if (this.ampiTraceOn) {
            this.tabPane = new JTabbedPane();
            this.ampiGraphPanel = new AmpiTimeProfileWindow(mainWindow, n);
        }
        this.createMenus();
        this.createLayout();
        this.pack();
        this.thisWindow = this;
        this.startFlag = true;
        this.thisWindow.setLocationRelativeTo(null);
        this.showDialog();
    }

    protected void createMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Util.makeJMenu("File", new Object[]{"Select Processors", null, "Close"}, null, this));
        jMenuBar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors"}, null, this));
        jMenuBar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(jMenuBar);
    }

    private void createLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        this.mainPanel.setLayout(gridBagLayout);
        this.epSelection = new JButton("Select Entry Points");
        this.epSelection.addActionListener(this);
        this.setRanges = new JButton("Select New Range");
        this.setRanges.addActionListener(this);
        this.saveColors = new JButton("Save Entry Colors");
        this.saveColors.addActionListener(this);
        this.loadColors = new JButton("Load Entry Colors");
        this.loadColors.addActionListener(this);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(gridBagLayout);
        Util.gblAdd(this.controlPanel, this.epSelection, gridBagConstraints, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.setRanges, gridBagConstraints, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.saveColors, gridBagConstraints, 2, 0, 1, 1, 0, 0);
        Util.gblAdd(this.controlPanel, this.loadColors, gridBagConstraints, 3, 0, 1, 1, 0, 0);
        if (this.ampiTraceOn) {
            this.epPanel = new JPanel();
            this.epPanel.setLayout(gridBagLayout);
            JPanel jPanel = this.getMainPanel();
            Util.gblAdd(this.epPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.epPanel, this.controlPanel, gridBagConstraints, 0, 1, 1, 0, 0, 0);
            JPanel jPanel2 = this.ampiGraphPanel.getAmpiMainPanel();
            this.tabPane.add("Entry Points", this.epPanel);
            this.tabPane.add("AMPI Functions", jPanel2);
            this.epPanelTabIndex = this.tabPane.indexOfComponent(this.epPanel);
            this.ampiPanelTabIndex = this.tabPane.indexOfComponent(jPanel2);
            this.mainPanel.setLayout(new GridLayout(1, 1));
            this.mainPanel.add(this.tabPane);
        } else {
            JPanel jPanel = this.getMainPanel();
            Util.gblAdd(this.mainPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
            Util.gblAdd(this.mainPanel, this.controlPanel, gridBagConstraints, 0, 1, 1, 0, 0, 0);
        }
    }

    public void setGraphSpecificData() {
        this.setXAxis("Time in us", "");
        this.setYAxis("Entry point execution time", "us");
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Select Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            if (this.ampiTraceOn) {
                this.ampiGraphPanel.getRangeVals(this.dialog.getStartTime(), this.dialog.getEndTime(), this.startInterval, this.endInterval, this.intervalSize, this.processorList);
            }
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (TimeProfileWindow.this.dialog.isModified()) {
                        int n = 0;
                        int n2 = 0;
                        int n3 = TimeProfileWindow.this.endInterval - TimeProfileWindow.this.startInterval + 1;
                        TimeProfileWindow.access$002(TimeProfileWindow.this, new double[n3][TimeProfileWindow.this.numEPs]);
                        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading log files", "", 0, TimeProfileWindow.this.processorList.size());
                        progressMonitor.setNote("Reading");
                        progressMonitor.setProgress(0);
                        while (TimeProfileWindow.this.processorList.hasMoreElements()) {
                            n = TimeProfileWindow.this.processorList.nextElement();
                            progressMonitor.setProgress(n2);
                            progressMonitor.setNote("[PE: " + n + " ] Reading Data.");
                            if (progressMonitor.isCanceled()) {
                                return null;
                            }
                            OrderedIntList orderedIntList = new OrderedIntList();
                            orderedIntList.insert(n);
                            Analysis.LoadGraphData(TimeProfileWindow.this.intervalSize, TimeProfileWindow.this.startInterval, TimeProfileWindow.this.endInterval, true, orderedIntList);
                            if (TimeProfileWindow.this.ampiTraceOn) {
                                TimeProfileWindow.this.ampiGraphPanel.createAMPITimeProfileData(n, n2);
                            }
                            TimeProfileWindow.this.fillGraphData();
                            ++n2;
                        }
                        progressMonitor.close();
                        if (TimeProfileWindow.this.startFlag) {
                            block1: for (int i = 0; i < TimeProfileWindow.this.numEPs; ++i) {
                                for (int j = 0; j < TimeProfileWindow.this.endInterval - TimeProfileWindow.this.startInterval + 1; ++j) {
                                    if (!(TimeProfileWindow.this.graphData[j][i] > 0.0)) continue;
                                    ((TimeProfileWindow)TimeProfileWindow.this).existsArray[0][i] = true;
                                    ((TimeProfileWindow)TimeProfileWindow.this).stateArray[0][i] = true;
                                    continue block1;
                                }
                            }
                        }
                        if (TimeProfileWindow.this.startFlag) {
                            TimeProfileWindow.this.startFlag = false;
                        }
                    }
                    return null;
                }

                public void finished() {
                    TimeProfileWindow.this.setOutputGraphData();
                    if (TimeProfileWindow.this.ampiTraceOn) {
                        TimeProfileWindow.this.ampiGraphPanel.setOutputGraphData(true);
                    }
                    TimeProfileWindow.this.thisWindow.setVisible(true);
                }
            };
            swingWorker.start();
        }
    }

    public void getDialogData() {
        IntervalRangeDialog intervalRangeDialog = (IntervalRangeDialog)this.dialog;
        this.intervalSize = intervalRangeDialog.getIntervalSize();
        this.startInterval = (int)intervalRangeDialog.getStartInterval();
        this.endInterval = (int)intervalRangeDialog.getEndInterval();
        this.processorList = intervalRangeDialog.getValidProcessors();
        super.getDialogData();
    }

    public void showWindow() {
    }

    private void fillGraphData() {
        for (int i = 0; i < this.numEPs; ++i) {
            int[][] nArray = Analysis.getUserEntryData(i, 2);
            for (int j = 0; j < this.graphData.length; ++j) {
                double[] dArray = this.graphData[j];
                int n = i;
                dArray[n] = dArray[n] + (double)nArray[0][j];
            }
        }
    }

    public void applyDialogColors() {
        this.setOutputGraphData();
    }

    private void setOutputGraphData() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.numEPs; ++n) {
            if (!this.stateArray[0][n]) continue;
            ++n2;
        }
        if (n2 != 0) {
            n = this.endInterval - this.startInterval + 1;
            this.outputData = new double[n][n2];
            this.outColors = new Color[n2];
            for (int i = 0; i < n; ++i) {
                int n3 = 0;
                for (int j = 0; j < this.numEPs; ++j) {
                    if (!this.stateArray[0][j]) continue;
                    this.outputData[i][n3] = this.graphData[i][j];
                    this.outColors[n3++] = this.colorArray[0][j];
                }
            }
            this.setXAxis("Time Interval (" + U.t(this.intervalSize) + ")", "", this.startInterval, 1.0);
            this.setYAxis("Entry point execution time", "us");
            this.setDataSource("Time Profile Graph", this.outputData, this.outColors, this.thisWindow);
            this.refreshGraph();
        }
    }

    public String[] getPopup(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int n3 = 0;
        String string = "";
        String string2 = "";
        for (int i = 0; i < this.numEPs; ++i) {
            if (!this.stateArray[0][i] || n3++ != n2) continue;
            string = Analysis.getEntryName(i);
            string2 = Analysis.getEntryChareName(i);
            break;
        }
        String[] stringArray = new String[]{"Time Interval: " + U.t((long)(n + this.startInterval) * this.intervalSize) + " to " + U.t((long)(n + this.startInterval + 1) * this.intervalSize), "Chare Name: " + string2, "Entry Method: " + string, "Execution Time = " + U.t((long)this.outputData[n][n2])};
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.epSelection) {
                if (this.entryDialog == null) {
                    this.entryDialog = new EntrySelectionDialog(this, this, this.typeLabelNames, this.stateArray, this.colorArray, this.existsArray, this.entryNames);
                }
                this.entryDialog.showDialog();
            } else if (jButton == this.setRanges) {
                this.showDialog();
            } else if (jButton == this.saveColors) {
                Analysis.saveColors();
            } else if (jButton == this.loadColors) {
                try {
                    ColorManager.loadActivityColors(0, this.colorArray[0]);
                    this.setOutputGraphData();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to load colors!!");
                }
            }
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Select Processors")) {
                this.showDialog();
            }
        }
    }

    static /* synthetic */ double[][] access$002(TimeProfileWindow timeProfileWindow, double[][] dArray) {
        timeProfileWindow.graphData = dArray;
        return dArray;
    }
}

