/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.Analysis;
import projections.gui.ColorPanel;
import projections.gui.ColorSelectWindow;
import projections.gui.ColorWindowFrame;
import projections.gui.LWPanel;
import projections.gui.TimelineData;
import projections.gui.Util;

public class TimelineColorWindow
extends ColorWindowFrame
implements ActionListener {
    private TimelineData data;
    private String[][] names;
    private ColorPanel[] cpEntry;
    private ColorPanel selectedCP;
    private Button bApply;
    private Button bClose;
    private Button bGraphColors;
    private ColorSelectWindow colorSelectWindow;

    public TimelineColorWindow(Frame frame, TimelineData timelineData) {
        super(frame);
        this.data = timelineData;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TimelineColorWindow.this.Close();
            }
        });
        this.setBackground(Color.lightGray);
        this.setTitle("Timeline Colors");
        this.setLocation(0, 0);
        this.CreateLayout();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bApply) {
                for (int i = 0; i < Analysis.getNumUserEntries(); ++i) {
                    if (this.cpEntry[i] == null) continue;
                    this.data.entryColor[i] = this.cpEntry[i].getColor();
                }
                this.data.displayCanvas.updateColors();
            } else if (button == this.bClose) {
                this.Close();
            } else if (button == this.bGraphColors && this.GraphExists()) {
                for (int i = 0; i < Analysis.getNumUserEntries(); ++i) {
                    if (this.cpEntry[i] == null) continue;
                    this.cpEntry[i].setColor(this.getGraphColor(i));
                }
            }
        } else if (actionEvent.getSource() instanceof ColorPanel) {
            this.selectedCP = (ColorPanel)actionEvent.getSource();
            String string = null;
            for (int i = 0; i < Analysis.getNumUserEntries(); ++i) {
                if (this.selectedCP != this.cpEntry[i]) continue;
                string = this.names[i][0];
            }
            JColorChooser jColorChooser = new JColorChooser();
            Color color = JColorChooser.showDialog(this, string, this.selectedCP.getColor());
            if (color != null) {
                this.selectedCP.setColor(color);
            }
        }
    }

    private void Close() {
        this.setVisible(false);
        this.data.timelineWindow.CloseColorWindow();
        this.dispose();
    }

    private void CreateLayout() {
        Component component;
        Panel panel = new Panel();
        this.add("Center", panel);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.names = Analysis.getEntryNames();
        this.cpEntry = new ColorPanel[Analysis.getNumUserEntries()];
        LWPanel lWPanel = new LWPanel();
        lWPanel.setLayout(gridBagLayout);
        int n = 0;
        String string = new String();
        for (int i = 0; i < Analysis.getNumUserEntries(); ++i) {
            if (this.data.entries[i] <= 0) continue;
            if (!string.equals(this.names[i][1])) {
                string = this.names[i][1];
                component = new Label(this.names[i][1], 0);
                Util.gblAdd(lWPanel, component, gridBagConstraints, 0, n++, 1, 1, 1, 0, 0, 5, 0, 5);
            }
            component = new Label(this.names[i][0], 2);
            Util.gblAdd(lWPanel, component, gridBagConstraints, 0, n, 1, 1, 1, 0, 0, 5, 0, 5);
            this.cpEntry[i] = new ColorPanel(this.data.entryColor[i]);
            Util.gblAdd(lWPanel, this.cpEntry[i], gridBagConstraints, 1, n++, 1, 1, 0, 0, 0, 5, 0, 5);
            this.cpEntry[i].addActionListener(this);
        }
        Util.gblAdd(lWPanel, new Label(""), gridBagConstraints, 0, n, 1, 1, 1, 1);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(lWPanel);
        component = new GrayLWPanel();
        ((Container)component).setLayout(gridBagLayout);
        Util.gblAdd((Container)component, scrollPane, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 5, 5);
        GrayLWPanel grayLWPanel = new GrayLWPanel();
        grayLWPanel.setLayout(new FlowLayout());
        this.bGraphColors = new Button("Use Graph colors");
        grayLWPanel.add(this.bGraphColors);
        if (this.GraphExists()) {
            this.bGraphColors.addActionListener(this);
        } else {
            this.bGraphColors.setForeground(Color.gray);
        }
        this.bApply = new Button("Apply");
        this.bApply.addActionListener(this);
        grayLWPanel.add(this.bApply);
        this.bClose = new Button("Close");
        this.bClose.addActionListener(this);
        grayLWPanel.add(this.bClose);
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, component, gridBagConstraints, 0, 0, 1, 1, 1, 1, 4, 4, 2, 4);
        Util.gblAdd(panel, grayLWPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 2, 4, 4, 4);
    }

    private Color getGraphColor(int n) {
        return this.data.timelineWindow.getGraphColor(n);
    }

    private boolean GraphExists() {
        return this.data.timelineWindow.GraphExists();
    }

    class GrayLWPanel
    extends LWPanel {
        GrayLWPanel() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            super.paint(graphics);
        }
    }
}

