/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import projections.analysis.PackTime;
import projections.analysis.TimelineEvent;
import projections.analysis.TimelineMessage;
import projections.analysis.UserEvent;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.gui.TimelineDisplayCanvas;
import projections.gui.TimelineLine;
import projections.gui.TimelineObject;
import projections.gui.TimelineWindow;
import projections.misc.LogLoadException;

public class TimelineData {
    int vpw;
    int vph;
    int tlw;
    int tlh;
    int lcw;
    int ath;
    int abh;
    int sbw;
    int sbh;
    int mpw;
    int mph;
    public int tluh;
    public int barheight;
    int numPs;
    float scale;
    public int offset;
    public OrderedIntList processorList;
    OrderedIntList oldplist = null;
    String oldpstring = null;
    public boolean colorbyObjectId;
    public double pixelIncrement;
    public int timeIncrement;
    int labelIncrement;
    int numIntervals;
    int[] entries;
    Color[] entryColor;
    public TimelineObject[][] tloArray;
    public Vector[] mesgVector;
    public Vector[] oldmesgVector;
    UserEvent[][] userEventsArray = null;
    TimelineDisplayCanvas displayCanvas;
    int xmin;
    int xmax;
    long xmintime;
    long xmaxtime;
    int xminpixel;
    int xmaxpixel;
    float[] processorUsage;
    float[] idleUsage;
    float[] packUsage;
    OrderedUsageList[] entryUsageList;
    public long beginTime;
    public long endTime;
    public long totalTime;
    long oldBT = -1L;
    long oldET = -1L;
    boolean showPacks = false;
    boolean showIdle = false;
    boolean showMsgs = true;
    public TimelineWindow timelineWindow;
    public Vector mesgCreateExecVector;

    public TimelineData(TimelineWindow timelineWindow) {
        this.timelineWindow = timelineWindow;
        this.displayCanvas = timelineWindow.displayCanvas;
        this.lcw = 100;
        this.sbw = 20;
        this.sbh = 20;
        this.barheight = 20;
        this.tluh = this.barheight + 20;
        this.numPs = 0;
        this.ath = 50;
        this.scale = 1.0f;
        this.processorUsage = null;
        this.entryUsageList = null;
        this.offset = 10;
        this.pixelIncrement = 5.0;
        this.timeIncrement = 100;
        this.labelIncrement = 5;
        this.numIntervals = 1;
        this.beginTime = 0L;
        this.endTime = this.totalTime = Analysis.getTotalTime();
        this.xmin = 0;
        this.xmax = this.numIntervals;
        this.xmintime = 0L;
        this.xmaxtime = 1L;
        this.xminpixel = 0;
        this.xmaxpixel = 1;
        this.mesgCreateExecVector = new Vector();
        this.tloArray = null;
        this.mesgVector = null;
        this.entries = new int[Analysis.getNumUserEntries()];
        this.entryColor = Analysis.getColorMap();
    }

    public void createTLOArray() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        TimelineObject[][] timelineObjectArray = this.tloArray;
        UserEvent[][] userEventArray = this.userEventsArray;
        this.oldmesgVector = this.mesgVector;
        this.mesgVector = new Vector[Analysis.getNumProcessors()];
        for (n6 = 0; n6 < Analysis.getNumProcessors(); ++n6) {
            this.mesgVector[n6] = null;
        }
        this.tloArray = new TimelineObject[this.processorList.size()][];
        this.userEventsArray = new UserEvent[this.processorList.size()][];
        if (timelineObjectArray != null && this.beginTime >= this.oldBT && this.endTime <= this.oldET) {
            int n7 = 0;
            n5 = 0;
            this.processorList.reset();
            this.oldplist.reset();
            n4 = this.processorList.nextElement();
            n6 = this.oldplist.nextElement();
            while (n4 != -1) {
                while (n6 != -1 && n6 < n4) {
                    n6 = this.oldplist.nextElement();
                    ++n7;
                }
                if (n6 == -1) break;
                if (n6 == n4) {
                    if (this.beginTime == this.oldBT && this.endTime == this.oldET) {
                        this.tloArray[n5] = timelineObjectArray[n7];
                        this.userEventsArray[n5] = userEventArray[n7];
                        this.mesgVector[n6] = this.oldmesgVector[n4];
                    } else {
                        n3 = timelineObjectArray[n7].length;
                        int n8 = 0;
                        n2 = 0;
                        int n9 = n3 - 1;
                        for (n = 0; n < n3 && timelineObjectArray[n7][n].getEndTime() < this.beginTime; ++n) {
                            ++n2;
                        }
                        for (n = n3 - 1; n >= 0 && timelineObjectArray[n7][n].getBeginTime() > this.endTime; --n) {
                            --n9;
                        }
                        n8 = n9 - n2 + 1;
                        this.tloArray[n5] = new TimelineObject[n8];
                        this.mesgVector[n4] = new Vector();
                        for (n = 0; n < n8; ++n) {
                            this.tloArray[n5][n] = timelineObjectArray[n7][n + n2];
                            this.tloArray[n5][n].setUsage();
                            this.tloArray[n5][n].setPackUsage();
                            for (int i = 0; i < this.tloArray[n5][n].messages.length; ++i) {
                                this.mesgVector[n4].addElement(this.tloArray[n5][n].messages[i]);
                            }
                        }
                        if (userEventArray != null && userEventArray[n7] != null) {
                            n3 = userEventArray[n7].length;
                            n8 = 0;
                            n2 = 0;
                            n9 = n3 - 1;
                            for (n = 0; n < n3 && userEventArray[n7][n].EndTime < this.beginTime; ++n) {
                                ++n2;
                            }
                            for (n = n3 - 1; n >= 0 && userEventArray[n7][n].BeginTime > this.endTime; --n) {
                                --n9;
                            }
                            n8 = n9 - n2 + 1;
                            this.userEventsArray[n5] = new UserEvent[n8];
                            for (n = 0; n < n8; ++n) {
                                this.userEventsArray[n5][n] = userEventArray[n7][n2 + n];
                            }
                        }
                    }
                }
                n4 = this.processorList.nextElement();
                ++n5;
            }
            timelineObjectArray = null;
            userEventArray = null;
        }
        this.processorList.reset();
        n4 = this.processorList.size();
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading timeline data", "", 0, n4);
        progressMonitor.setProgress(0);
        for (n5 = 0; n5 < n4 && !progressMonitor.isCanceled(); ++n5) {
            progressMonitor.setNote(n5 + " of " + n4);
            progressMonitor.setProgress(n5);
            n6 = this.processorList.nextElement();
            if (this.tloArray[n5] != null) continue;
            this.tloArray[n5] = this.getData(n6, n5);
        }
        progressMonitor.close();
        for (n5 = 0; n5 < Analysis.getNumUserEntries(); ++n5) {
            this.entries[n5] = 0;
        }
        this.processorUsage = new float[this.tloArray.length];
        this.entryUsageList = new OrderedUsageList[this.tloArray.length];
        float[] fArray = new float[Analysis.getNumUserEntries()];
        this.idleUsage = new float[this.tloArray.length];
        this.packUsage = new float[this.tloArray.length];
        for (n = 0; n < this.tloArray.length; ++n) {
            this.processorUsage[n] = 0.0f;
            this.idleUsage[n] = 0.0f;
            this.packUsage[n] = 0.0f;
            for (n3 = 0; n3 < Analysis.getNumUserEntries(); ++n3) {
                fArray[n3] = 0.0f;
            }
            for (n3 = 0; n3 < this.tloArray[n].length; ++n3) {
                float f = this.tloArray[n][n3].getUsage();
                n2 = this.tloArray[n][n3].getEntry();
                if (n2 >= 0) {
                    int n10 = n2;
                    this.entries[n10] = this.entries[n10] + 1;
                    int n11 = n;
                    this.processorUsage[n11] = this.processorUsage[n11] + f;
                    int n12 = n;
                    this.packUsage[n12] = this.packUsage[n12] + this.tloArray[n][n3].getPackUsage();
                    int n13 = n2;
                    fArray[n13] = fArray[n13] + this.tloArray[n][n3].getNetUsage();
                    continue;
                }
                int n14 = n;
                this.idleUsage[n14] = this.idleUsage[n14] + f;
            }
            this.entryUsageList[n] = new OrderedUsageList();
            for (n3 = 0; n3 < Analysis.getNumUserEntries(); ++n3) {
                if (!(fArray[n3] > 0.0f)) continue;
                this.entryUsageList[n].insert(fArray[n3], n3);
            }
        }
    }

    private TimelineObject[] getData(int n, int n2) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.mesgVector[n] = new Vector();
        this.createTL(n, this.beginTime, this.endTime, vector, vector2);
        int n3 = vector2.size();
        if (n3 > 0) {
            this.userEventsArray[n2] = new UserEvent[n3];
            for (int i = 0; i < n3; ++i) {
                this.userEventsArray[n2][i] = (UserEvent)vector2.elementAt(i);
            }
        } else {
            this.userEventsArray[n2] = null;
        }
        int n4 = vector.size();
        TimelineObject[] timelineObjectArray = new TimelineObject[n4];
        for (int i = 0; i < n4; ++i) {
            TimelineEvent timelineEvent = (TimelineEvent)vector.elementAt(i);
            Vector vector3 = timelineEvent.MsgsSent;
            int n5 = vector3 == null ? 0 : vector3.size();
            TimelineMessage[] timelineMessageArray = new TimelineMessage[n5];
            for (int j = 0; j < n5; ++j) {
                timelineMessageArray[j] = (TimelineMessage)vector3.elementAt(j);
                this.mesgVector[n].addElement((TimelineMessage)vector3.elementAt(j));
            }
            Vector vector4 = timelineEvent.PackTimes;
            int n6 = vector4 == null ? 0 : vector4.size();
            PackTime[] packTimeArray = new PackTime[n6];
            for (int j = 0; j < n6; ++j) {
                packTimeArray[j] = (PackTime)vector4.elementAt(j);
            }
            timelineObjectArray[i] = new TimelineObject(this, timelineEvent, timelineMessageArray, packTimeArray, n);
        }
        return timelineObjectArray;
    }

    public int getNumUserEvents() {
        if (this.userEventsArray == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.userEventsArray.length; ++i) {
            if (this.userEventsArray[i] == null) continue;
            n += this.userEventsArray[i].length;
        }
        return n;
    }

    public void drawConnectingLine(int n, long l, int n2, long l2, TimelineObject timelineObject, int n3) {
        int n4;
        int n5;
        Dimension dimension = this.displayCanvas.getSize();
        double d = this.pixelIncrement / (double)this.timeIncrement;
        long l3 = this.endTime - this.beginTime + 1L;
        int n6 = dimension.width;
        int n7 = this.offset + (int)((double)(this.endTime - this.beginTime) * this.pixelIncrement / (double)this.timeIncrement);
        int n8 = timelineObject.h;
        int n9 = timelineObject.startY;
        this.processorList.reset();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (n3 == 2) {
            int n13;
            boolean bl = false;
            for (n13 = 0; n13 < this.mesgCreateExecVector.size(); ++n13) {
                TimelineLine timelineLine = (TimelineLine)this.mesgCreateExecVector.elementAt(n13);
                if (timelineLine.pCurrent != n2 || timelineLine.executiontime != l2) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.mesgCreateExecVector.remove(n13);
            }
            this.displayCanvas.repaint();
            return;
        }
        for (n5 = 0; n5 < this.processorList.size(); ++n5) {
            n4 = this.processorList.nextElement();
            if (n4 == n) {
                n10 = n12;
            }
            if (n4 == n2) {
                n11 = n12;
            }
            ++n12;
        }
        this.processorList.reset();
        double d2 = (double)dimension.height / (double)this.processorList.size();
        n5 = (int)((double)(l - this.beginTime) * d + (double)this.offset);
        n4 = (int)((double)(l2 - this.beginTime) * d + (double)this.offset);
        int n14 = (int)(d2 * (double)n10 + (double)n8 + (double)n9 + 5.0 + 5.0);
        int n15 = (int)(d2 * (double)n11 + (double)n8);
        TimelineLine timelineLine = new TimelineLine(n, n2, timelineObject, l, l2);
        this.mesgCreateExecVector.add(timelineLine);
        this.displayCanvas.repaint();
    }

    public void drawAllLines() {
        Graphics graphics = this.displayCanvas.getGraphics();
        if (!this.mesgCreateExecVector.isEmpty()) {
            graphics.setColor(Analysis.foreground);
            Dimension dimension = this.displayCanvas.getSize();
            double d = this.pixelIncrement / (double)this.timeIncrement;
            double d2 = (double)dimension.height / (double)this.processorList.size();
            for (int i = 0; i < this.mesgCreateExecVector.size(); ++i) {
                int n;
                int n2;
                TimelineLine timelineLine = (TimelineLine)this.mesgCreateExecVector.elementAt(i);
                int n3 = 0;
                int n4 = 0;
                this.processorList.reset();
                for (n2 = 0; n2 < this.processorList.size(); ++n2) {
                    n = this.processorList.nextElement();
                    if (n == timelineLine.pCreation) {
                        n3 = n2;
                    }
                    if (n != timelineLine.pCurrent) continue;
                    n4 = n2;
                }
                n2 = (int)((double)(timelineLine.creationtime - this.beginTime) * d + (double)this.offset);
                n = (int)((double)(timelineLine.executiontime - this.beginTime) * d + (double)this.offset);
                int n5 = (int)(d2 * (double)n3 + (double)timelineLine.obj.h + (double)timelineLine.obj.startY + 5.0 + 5.0);
                int n6 = (int)(d2 * (double)n4 + (double)timelineLine.obj.h);
                graphics.drawLine(n2, n5, n, n6);
            }
        }
    }

    public void clearAllLines() {
        if (this.tloArray != null) {
            for (int i = 0; i < this.tloArray.length; ++i) {
                if (this.tloArray[i] == null) continue;
                for (int j = 0; j < this.tloArray[i].length; ++j) {
                    if (this.tloArray[i][j] == null) continue;
                    this.tloArray[i][j].clearCreationLine();
                }
            }
        }
        this.mesgCreateExecVector.clear();
    }

    public void addProcessor(int n) {
        this.oldplist = this.processorList.copyOf();
        this.processorList.insert(n);
        this.numPs = this.processorList.size();
        this.timelineWindow.validPEs = this.processorList;
        this.timelineWindow.procRangeDialog(false);
    }

    public Vector createTL(int n, long l, long l2, Vector vector, Vector vector2) {
        try {
            if (Analysis.hasLogData()) {
                return Analysis.logLoader.createtimeline(n, l, l2, vector, vector2);
            }
            System.err.println("createTL: No log files available!");
            return null;
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LOG LOAD EXCEPTION");
            return null;
        }
    }
}

